part of 'chat_reader_list_bloc.dart';

abstract class ChatReaderListState extends Equatable {
  const ChatReaderListState();

  @override
  List<Object> get props => [];
}

class ChatReaderListInitial extends ChatReaderListState {}

class ChatReaderListLoading extends ChatReaderListState {}

class ChatReaderListLoaded extends ChatReaderListState {
  final List<ChatReaderModel> result;

  ChatReaderListLoaded({
    this.result,
  });
  @override
  List<Object> get props => [result];
}

class ChatReaderListError extends ChatReaderListState {
  final String message;
  const ChatReaderListError({this.message});
  @override
  List<Object> get props => [message];
}

class ChatReaderListErrorUnauthorized extends ChatReaderListState {}
