part of 'chat_list_bloc.dart';

abstract class ChatListState extends Equatable {
  const ChatListState();

  @override
  List<Object> get props => [];
}

class ChatListInitial extends ChatListState {}

class ChatListLoading extends ChatListState {}

class ChatListLoaded extends ChatListState {
  final List<ChatMessageModel> result;
  final DateTime lastSend;

  ChatListLoaded({this.result, this.lastSend});
  @override
  List<Object> get props => [result, lastSend];
}

class ChatListNotFound extends ChatListState {}

class ChatListError extends ChatListState {
  final String message;
  const ChatListError({this.message});
  @override
  List<Object> get props => [message];
}

class ChatListErrorUnauthorized extends ChatListState {}
