import 'dart:async';

import 'package:bloc/bloc.dart';
import 'package:equatable/equatable.dart';

part 'chat_current_message_date_event.dart';
part 'chat_current_message_date_state.dart';

class ChatCurrentMessageDateBloc extends Bloc<ChatCurrentMessageDateEvent, ChatCurrentMessageDateState> {
  ChatCurrentMessageDateBloc() : super(ChatCurrentMessageDateInitial());

  @override
  Stream<ChatCurrentMessageDateState> mapEventToState(ChatCurrentMessageDateEvent event) async* {
    try {
      if (event is ChatCurrentMessageDateGetData) {
        yield ChatCurrentMessageDateLoaded(result: "23/11/2563");
      } else if (event is ChatCurrentMessageDateAddCurrentDate) {
        yield ChatCurrentMessageDateLoaded(result: event.currentDate);
      }
    } catch (e) {
      yield ChatCurrentMessageDateError(message: "Error");
    }
  }
}
