part of 'bottom_navigation_bloc.dart';

abstract class BottomNavigationState extends Equatable {
  const BottomNavigationState();

  @override
  List<Object> get props => [];
}

class BottomNavigationInitial extends BottomNavigationState {
  @override
  List<Object> get props => [];
}

class BottomNavigationLoading extends BottomNavigationState {}

class BottomNavigationLoaded extends BottomNavigationState {
  final int activeIndex;

  BottomNavigationLoaded({
    this.activeIndex,
  });
  @override
  List<Object> get props => [activeIndex];
}

class BottomNavigationNotFound extends BottomNavigationState {}

class BottomNavigationError extends BottomNavigationState {
  final String message;
  const BottomNavigationError({this.message});
  @override
  List<Object> get props => [message];
}