import 'dart:async';

import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:equatable/equatable.dart';

part 'bottom_navigation_event.dart';
part 'bottom_navigation_state.dart';

class BottomNavigationBloc extends Bloc<BottomNavigationEvent, BottomNavigationState> {
  BottomNavigationBloc() : super(BottomNavigationInitial());

  @override
  Stream<BottomNavigationState> mapEventToState(BottomNavigationEvent event) async* {
    try {
      if (event is BottomNavigationOnActive) {
        yield BottomNavigationLoaded(activeIndex: event.activeIndex);
      }
    } catch (e) {
      yield BottomNavigationError(message: "Error");
    }
  }
}
