part of 'authen_bloc.dart';

abstract class AuthenState extends Equatable {
  const AuthenState();

  @override
  List<Object> get props => [];
}

class AuthenInitial extends AuthenState {
  @override
  List<Object> get props => [];
}

class AuthenLoading extends AuthenState {}

class AuthenLoaded extends AuthenState {
  final bool isLogin;

  AuthenLoaded({
    this.isLogin,
  });
  @override
  List<Object> get props => [isLogin];
}

class AuthenNotFound extends AuthenState {}

class AuthenError extends AuthenState {
  final String message;
  const AuthenError({this.message});
  @override
  List<Object> get props => [message];
}

class AuthenErrorUnauthorized extends AuthenState {}
