part of 'activity_list_bloc.dart';

abstract class ActivityListState extends Equatable {
  const ActivityListState();

  @override
  List<Object> get props => [];
}

class ActivityListInitial extends ActivityListState {
  @override
  List<Object> get props => [];
}

class ActivityListLoading extends ActivityListState {}

class ActivityListLoaded extends ActivityListState {
  final List<ActivityModel> result;

  ActivityListLoaded({
    this.result,
  });
  @override
  List<Object> get props => [result];
}

class ActivityListNotFound extends ActivityListState {}

class ActivityListError extends ActivityListState {
  final String message;
  const ActivityListError({this.message});
  @override
  List<Object> get props => [message];
}

class ActivityListErrorUnauthorized extends ActivityListState {}
