import 'dart:async';

import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:equatable/equatable.dart';
import 'package:peasmartcare/models/activity_model.dart';
import 'package:peasmartcare/models/result_data_model.dart';
import 'package:peasmartcare/services/activity_service.dart';
import 'package:peasmartcare/utils/clear_count_notification_util.dart';
import 'package:peasmartcare/utils/share_data_util.dart';

part 'activity_list_event.dart';
part 'activity_list_state.dart';

class ActivityListBloc extends Bloc<ActivityListEvent, ActivityListState> {
  ActivityImpService service = ActivityImpService();
  // ShareDataUtilUtil ShareDataUtil = ShareDataUtilUtil();
  ResultData resultData;

  ActivityListBloc() : super(ActivityListInitial());

  @override
  Stream<ActivityListState> mapEventToState(ActivityListEvent event) async* {
    try {
      if (event is ActivityListGetList) {
        yield ActivityListLoading();

        await ClearCountNotificationUtil.activity();

        resultData = await service.getList(
          customerId: ShareDataUtil.getCustomerId(),
          authenKey: ShareDataUtil.getAuthenKey(),
        );

        if (resultData.statusCode == 401) {
          yield ActivityListErrorUnauthorized();
        } else {
          yield ActivityListLoaded(result: resultData.result);
        }
      }
    } catch (e) {
      yield ActivityListError(message: "Error");
    }
  }
}
