import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mwf_app/service/color.dart';
import 'package:mwf_app/service/fontsize.dart';
import 'package:mwf_app/service/header.dart';
import 'package:mwf_app/service/loader.dart';
import 'package:mwf_app/service/navigator.dart';
import 'package:mwf_app/service/notification_count.dart';
import 'package:mwf_app/service/screen.dart';
import 'package:mwf_app/service/shadow.dart';
import 'package:mwf_app/home.dart';
import 'package:mwf_app/model/TimelineCustomer_model.dart';
import 'package:mwf_app/set5/service_timeline.dart';

//Timeline_model
class Timeline extends StatefulWidget {
  @override
  _TimelineState createState() => _TimelineState();
}

class _TimelineState extends State<Timeline> {
  bool isLoading = false;
  @override
  void initState() {
    super.initState();
    Header.routes = HomePage();
    Header.currentPage = "";
    setState(() {
      NotificationCount.timelineCount = 0;
    });
    loadData();
  }

  loadData() async {
    setState(() {
      isLoading = true;
    });
    final list =
        await TimelineCustomer.getData(); // ไปเรียกฟังชั่นดึงข้อมูลจาก api
    setState(() {
      list.forEach((v) {
        final timelineList = TimelineCustomer.fromJson(v);
        TimelineCustomer.data.add(timelineList); // loop เก็บข้อมูล
      });
      isLoading = false;
    });
  }

  @override
  Widget build(BuildContext context) {
    if (isLoading == true) {
      AppLoader.show();
    }
    if (isLoading == false) {
      AppLoader.hide();
    }
    double _width = MediaQuery.of(context).size.width;
    return Material(
      color: AppColors.bgColor,
      child: WillPopScope(
        onWillPop: () async {
          Get.offAll(Header.routes);
          return false;
        },
        child: Stack(
          children: <Widget>[
            Header.header2ListPage(context),
            Header.mainMenu(context),
            Container(
              width: _width,
              height: mediaQuery(context, 'h', 1800),
              margin: EdgeInsets.only(
                top: mediaQuery(context, 'h', 400),
                left: mediaQuery(context, 'w', 60),
                right: mediaQuery(context, 'w', 60),
              ),
              child: SingleChildScrollView(
                child: Column(
                  children: <Widget>[
                    Container(
                      alignment: Alignment.center,
                      child: Text(
                        'เรียกดู Timeline',
                        style: TextStyle(
                          color: AppColors.color_gold,
                          fontSize:
                              mediaQuery(context, 'h', AppFontSize.headText),
                        ),
                      ),
                    ),
                    SizedBox(
                      height: mediaQuery(context, 'h', 50),
                    ),
                    Column(
                      children:
                          List.generate(TimelineCustomer.data.length, (index) {
                        return _buildContent(
                            context,
                            TimelineCustomer.data[index].customerID,
                            TimelineCustomer.data[index].cA,
                            TimelineCustomer.data[index].customerName,
                            TimelineCustomer.data[index].address);
                      }),
                    ),
                  ],
                ),
              ),
            ),
          ],
        ),
      ),
    );
  }

  _buildContent(context, companyID, title, company, message) {
    return GestureDetector(
      onTap: () {
        print("Call TimeLine");
        Nav.push(context, service_Timeline(companyID, company));
      },
      child: Container(
        width: mediaQuery(context, 'w', 1005),
        //      height: mediaQuery(context, 'h', 380),
        padding: EdgeInsets.all(
          mediaQuery(context, 'h', 50),
        ),
        margin: EdgeInsets.only(
          bottom: mediaQuery(context, 'h', 40),
        ),
        decoration: BoxDecoration(
          borderRadius: new BorderRadius.all(
            Radius.circular(
              mediaQuery(context, 'h', 20),
            ),
          ),
          boxShadow: [
            appShadow(),
          ],
          color: Colors.white,
        ),

        child: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: <Widget>[
            Text(
              title,
              style: TextStyle(
                color: AppColors.color_text,
                fontSize: mediaQuery(context, 'h', 55),
                fontWeight: FontWeight.bold,
              ),
            ),
            Text(
              company,
              style: TextStyle(
                color: AppColors.color_text,
                fontSize: mediaQuery(context, 'h', 40),
              ),
            ),
            Text(
              message,
              style: TextStyle(
                color: Color(0xFF8B939A),
                fontSize: mediaQuery(context, 'h', 40),
              ),
            ),
          ],
        ),
      ),
    );
  }
} //class
