import 'dart:convert';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:mwf_app/service/assets.dart';
import 'package:mwf_app/service/color.dart';
import 'package:mwf_app/service/header.dart';
import 'package:mwf_app/service/loader.dart';
import 'package:mwf_app/service/screen.dart';
import 'package:mwf_app/service/url.dart';
import 'package:mwf_app/model/ProfileInfo_model.dart';
import 'package:http/http.dart' as http;
import 'package:mwf_app/set5/personal_info.dart';
import 'package:mwf_app/service/shadow.dart';

class PersonalInfoEdit extends StatefulWidget {
  final ProfileInfo profileInfo;

  PersonalInfoEdit(this.profileInfo);

  @override
  _PersonalInfoEditState createState() =>
      _PersonalInfoEditState(this.profileInfo);
}

class _PersonalInfoEditState extends State<PersonalInfoEdit> {
  bool isLoading = false;
  ProfileInfo profileInfo;
  final _phonNumber = TextEditingController();
  final _email = TextEditingController();
  final _etc = TextEditingController();

  _PersonalInfoEditState(this.profileInfo);

  @override
  void initState() {
    super.initState();
    debugPrint(profileInfo.toJson().toString());
    _phonNumber..text = profileInfo.employeePhone;
    _email..text = profileInfo.employeeEmail;
    _etc..text = profileInfo.employeeContactEtc;
  }

  @override
  Widget build(BuildContext context) {
    if (isLoading == true) {
      AppLoader.show();
    }
    if (isLoading == false) {
      AppLoader.hide();
    }
    double _width = MediaQuery.of(context).size.width;

    return Material(
      color: AppColors.bgColor,
      child: Stack(
        children: <Widget>[
          Row(
            children: <Widget>[
              Image.asset(
                AppAssets.bg_home_layer1,
                fit: BoxFit.cover,
                width: _width,
                height: mediaQuery(context, "h", 796.7),
              )
            ],
          ),
          Padding(
            padding: EdgeInsets.only(
              top: mediaQuery(context, "h", 200),
              left: mediaQuery(context, "h", 33.1),
            ),
            child: Row(
              verticalDirection: VerticalDirection.down,
              children: <Widget>[
                GestureDetector(
                  onTap: () {
                    print("object3");
                    Navigator.pop(context);
                  },
                  child: Icon(
                    Icons.arrow_back_ios,
                    color: Colors.white,
                    size: mediaQuery(context, "h", 80),
                  ),
                ),
              ],
            ),
          ),
          Row(
            mainAxisAlignment: MainAxisAlignment.center,
            children: <Widget>[
              Container(
                margin: EdgeInsets.only(
                  top: mediaQuery(context, "h", 180),
                ),
//                color: Colors.red,
                child: Stack(
                  children: <Widget>[
                    Row(
                      mainAxisAlignment: MainAxisAlignment.spaceAround,
                      children: <Widget>[
                        Container(
                          width: mediaQuery(context, 'h', 420),
                          height: mediaQuery(context, 'h', 420),
                          margin: EdgeInsets.only(
                            top: mediaQuery(context, 'h', 70),
                          ),
                          decoration: BoxDecoration(
                            shape: BoxShape.circle,
                            border: Border.all(
                              color: Colors.white,
                              width: 6,
                            ),
                            boxShadow: [
                              appShadow(),
                            ],
                            image: DecorationImage(
                              fit: BoxFit.fill,
                              image: AssetImage(AppAssets.imageProfile),
                            ),
                          ),
                        ),
                      ],
                    ),
                    Padding(
                      padding: EdgeInsets.only(
                        top: mediaQuery(context, "h", 390),
                        left: mediaQuery(context, "w", 250),
                      ),
                      child: Row(
                        children: <Widget>[
                          Image.asset(
                            AppAssets.add_photo,
                            width: mediaQuery(context, "w", 110),
                            height: mediaQuery(context, "h", 110),
                          ),
                        ],
                      ),
                    ),
                  ],
                ),
              )
            ],
          ),
          Column(
            children: <Widget>[
              Row(
                mainAxisAlignment: MainAxisAlignment.center,
                children: <Widget>[
                  Container(
//                    color: Colors.red,
                    margin: EdgeInsets.only(
                      top: mediaQuery(context, "h", 800),
                    ),
                    child: Row(
                      mainAxisAlignment: MainAxisAlignment.center,
                      children: <Widget>[
                        Text(
                          "ข้อมูลส่วนตัว",
                          style: TextStyle(
                            color: AppColors.color,
                            fontSize: mediaQuery(context, "h", 70),
                          ),
                        ),
                      ],
                    ),
                  ),
                ],
              ),
            ],
          ),
          Header.mainMenu(context),
          Container(
            width: _width,
//            color: Colors.red,
            height: mediaQuery(context, 'h', 1250),
            margin: EdgeInsets.only(
              top: mediaQuery(context, 'h', 950),
              left: mediaQuery(context, 'w', 60),
              right: mediaQuery(context, 'w', 60),
            ),
            child: SingleChildScrollView(
              child: Column(
                children: <Widget>[
                  Row(
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    children: <Widget>[
                      Row(
                        children: <Widget>[
                          _buildTextMenu(context, "เบอร์โทรศัพท์"),
                        ],
                      ),
                    ],
                  ),
                  _buildSizeBox(context),
                  Row(
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    children: <Widget>[
                      Row(
                        children: <Widget>[
                          _buildRow(context, _phonNumber),
                        ],
                      ),
                    ],
                  ),
                  _buildSizeBox(context),
                  Row(
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    children: <Widget>[
                      Row(
                        children: <Widget>[
                          _buildTextMenu(context, "อีเมล"),
                        ],
                      ),
                    ],
                  ),
                  Row(
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    children: <Widget>[
                      Row(
                        children: <Widget>[
                          _buildRow(context, _email),
                        ],
                      ),
                    ],
                  ),
                  _buildSizeBox(context),
                  Row(
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    children: <Widget>[
                      Row(
                        children: <Widget>[
                          _buildTextMenu(context, "ช่องทางติดต่ออื่นๆ"),
                        ],
                      ),
                    ],
                  ),
                  _buildSizeBox(context),
                  Container(
                    color: Colors.white,
                    child: TextField(
                      maxLines: 5,
                      controller: _etc,
                      decoration: InputDecoration(
                          hintText: "",
                          border: OutlineInputBorder(),
                          labelText: ''),
                    ),
                  ),
                  _buildSizeBox(context),
                  _buildSizeBox(context),
                  _buildSizeBox(context),
                  Row(
                    mainAxisAlignment: MainAxisAlignment.spaceEvenly,
                    children: <Widget>[
                      _buildButton(
                          context, "ยกเลิก", Colors.white, AppColors.color),
                      _buildButton(
                          context, "บันทึก", AppColors.color, Colors.white),
                    ],
                  ),
                  _buildSizeBox(context),
                  _buildSizeBox(context),
                ],
              ),
            ),
          ),
        ],
      ),
    );
  }

  _buildButton(context, text, bgColor, fontColor) {
    return ButtonTheme(
      minWidth: mediaQuery(context, "w", 477),
      height: mediaQuery(context, "h", 120),
      child: FlatButton(
        shape: RoundedRectangleBorder(
            borderRadius: BorderRadius.circular(
              mediaQuery(context, "w", 50),
            ),
            side: BorderSide(color: AppColors.color)),
        color: bgColor,
        textColor: Colors.red,
        padding: EdgeInsets.all(
          mediaQuery(context, "w", 10),
        ),
        onPressed: () {
          if (text == "บันทึก") {
            _save();
          } else {
            Navigator.of(context).pop(false);
          }
          print(text);
        },
        child: Text(
          text,
          style: TextStyle(
            fontSize: 14.0,
            color: fontColor,
          ),
        ),
      ),
    );
  }

  _save() async {
    setState(() {
      isLoading = true;
    });
    profileInfo.employeeEmail = _email.text;
    profileInfo.employeePhone = _phonNumber.text;
    profileInfo.employeeContactEtc = _etc.text;

    Map<String, dynamic> data = {
      "employeeEmail": profileInfo.employeeEmail,
      "employeeContactEtc": profileInfo.employeeContactEtc,
      "employeePhone": profileInfo.employeePhone,
      "saleInfoId": profileInfo.saleInfoId,
      "authenKey": AppUrl.AuthenKey
    };

    final response = await http.post(AppUrl.Profile_SaleInfo_Update,
        headers: <String, String>{
          'Content-Type': 'application/json; charset=UTF-8',
        },
        body: jsonEncode(data));

    var responseBody = jsonDecode(response.body);
    setState(() {
      isLoading = false;
    });
    await Future.delayed(const Duration(milliseconds: 1000));
    AppLoader.showSuccess("บันทึกสำเร็จ");
    if (responseBody['statusCode'] == 200) {
      Navigator.pushReplacement(
          context, MaterialPageRoute(builder: (context) => PersonalInfo()));
    }
    //  debugPrint(response);
  }

  _buildSizeBox(context) {
    return SizedBox(
      height: mediaQuery(context, "h", 15),
    );
  }

  _buildTextMenu(context, text) {
    return Row(
      mainAxisAlignment: MainAxisAlignment.start,
      children: <Widget>[
        Text(
          text + " :",
          style: TextStyle(
              fontSize: mediaQuery(context, 'h', 40), color: AppColors.Black),
          textAlign: TextAlign.center,
        ),
      ],
    );
  }

  _buildRow(context, controller) {
    return Container(
      height: mediaQuery(context, 'h', 110),
      width: mediaQuery(context, 'w', 1005),
      child: TextField(
        controller: controller,
        enabled: true,
        decoration: InputDecoration(
          border: OutlineInputBorder(
            borderRadius: const BorderRadius.all(
              const Radius.circular(50.0),
            ),
          ),
          filled: true,
          counterText: "",
          contentPadding: EdgeInsets.fromLTRB(10.0, 0.0, 20.0, 10.0),
          hintStyle: TextStyle(color: Colors.grey[800]),
          fillColor: Colors.white70,
        ),
      ),
    );
  }
} //class
