import 'package:flutter/material.dart';
import 'package:mwf_app/service/assets.dart';
import 'package:mwf_app/service/color.dart';
import 'package:mwf_app/service/screen.dart';
import 'package:flutter_html/flutter_html.dart';
import 'package:flutter_html/image_properties.dart';

class Index extends StatefulWidget {
  @override
  _IndexState createState() => _IndexState();
}

class _IndexState extends State<Index> {
  @override
  Widget build(BuildContext context) {
    return Material(
      child: Center(
        child: Stack(
          children: <Widget>[
            Column(
              mainAxisAlignment: MainAxisAlignment.center,
              children: <Widget>[
                SizedBox(
                  width: mediaQuery(context, "w", 630),
                  height: mediaQuery(context, "h", 630),
                  child: Image.asset(
                    AppAssets.PEA_logo,
                    width: mediaQuery(context, "w", 630),
                    height: mediaQuery(context, "h", 630),
                  ),
                ),
                SizedBox(
                  height: mediaQuery(context, "h", 30),
                ),
                Row(
                  mainAxisAlignment: MainAxisAlignment.center,
                  children: <Widget>[
                    Text(
                      "CRM MOBILE WORKFORCE",
                      style: TextStyle(
                          fontSize: mediaQuery(context, "h", 70),
                          color: AppColors.color),
                    ),
                  ],
                ),
                Container(
                  width: mediaQuery(context, 'w', 1000),
                  height: mediaQuery(context, 'h', 1000),
//                  decoration: BoxDecoration(
//                    image: DecorationImage(
//                      image: NetworkImage(
//                        "http://202.6.26.23/CRMWorkforce.Web/UserImages/cat-cat-cat.jpg",
//                      ),
//                      fit: BoxFit.cover,
//                    ),
//                  ),
                  child: ListView(
                    children: <Widget>[
                      Html(
                        data:
                            '<p><strong><img alt="" src="http://202.6.26.23/CRMWorkforce.Web/UserImages/800600p542EDNmain67F31B9D-6601-4A68-9D00-A3D0F8204868.jpeg" style="height:599px; width:800px" /></strong></p> <p><strong>ทดสอบ upload ภาพ ตัวอย่าง &nbsp;ทดสอบ upload ภาพ ตัวอย่าง&nbsp; เทสเทสหลิน<img alt="" src="http://202.6.26.23/CRMWorkforce.Web/UserImages/cat-cat-cat.jpg" style="height:667px; width:1000px" /></strong></p>',
                        useRichText: true,
                        padding:
                            EdgeInsets.symmetric(horizontal: 20, vertical: 8),
                        defaultTextStyle: TextStyle(fontSize: 14),
                        imageProperties: ImageProperties(
                          //formatting images in html content
                          height: 150,
                          width: 150,
                        ),
                      )
                    ],
                  ),
                ),
              ],
            ),
          ],
        ),
      ),
    );
  }
}
