import 'package:flutter/material.dart';
import 'package:mwf_app/service/color.dart';
import 'package:mwf_app/service/fontsize.dart';
import 'package:mwf_app/service/header.dart';
import 'package:mwf_app/service/loader.dart';
import 'package:mwf_app/service/screen.dart';
import 'package:package_info/package_info.dart';

class AboutApp extends StatefulWidget {
  AboutApp({Key key}) : super(key: key);

  @override
  _AboutAppState createState() => _AboutAppState();
}

class _AboutAppState extends State<AboutApp> {
  bool isLoading = false;
  String appname = "";
  String appversion = "";
  @override
  void initState() {
    super.initState();
    getAppInfo();
  }

  getAppInfo() async {
    setState(() {
      isLoading = true;
    });
    PackageInfo packageInfo = await PackageInfo.fromPlatform();
    setState(() {
      String versionCode = packageInfo.buildNumber;
      appname = packageInfo.appName;
      appversion = packageInfo.version + "." + versionCode;
    });
    await new Future.delayed(const Duration(milliseconds: 500));
    setState(() {
      isLoading = false;
    });
  }

  @override
  Widget build(BuildContext context) {
    if (isLoading == true) {
      AppLoader.show();
    }
    if (isLoading == false) {
      AppLoader.hide();
    }
    return Material(
      color: AppColors.bgColor,
      child: Stack(
        children: <Widget>[
          Header.header2(context),
          Header.mainMenu(context),
          Container(
//            alignment: Alignment.center,
            margin: EdgeInsets.only(
              bottom: mediaQuery(context, 'h', 20),
              top: mediaQuery(context, 'h', 400),
            ),
            padding: EdgeInsets.only(
                left: mediaQuery(context, 'w', 60),
                right: mediaQuery(context, 'w', 60)),
            child: Column(children: <Widget>[
              Row(
                mainAxisAlignment: MainAxisAlignment.center,
                children: <Widget>[
                  Text(
                    // header text
                    "เกี่ยวกับแอพลิเคชั่น",
                    style: TextStyle(
                      color: AppColors.color,
                      fontSize: mediaQuery(context, 'h', AppFontSize.headText),
                    ),
                  )
                ],
              ),
              SizedBox(
                height: mediaQuery(context, 'h', 30),
              ),
              Row(children: <Widget>[
                Text(
                  "ชื่อโปรแกรม          :  ",
                  style: TextStyle(
                    fontSize: mediaQuery(context, 'h', 45),
                  ),
                ),
                Text(appname),
              ]),
              Row(children: <Widget>[
                Text(
                  "เวอร์ชัน               :  ",
                  style: TextStyle(
                    fontSize: mediaQuery(context, 'h', 45),
                  ),
                ),
                Text(appversion),
              ]),
              Row(children: <Widget>[
                Text(
                  "แจ้งปัญหาการใช้งาน :  ",
                  style: TextStyle(
                    fontSize: mediaQuery(context, 'h', 45),
                  ),
                ),
                Text("โทร.9960"),
              ])
            ]),
          ),
        ],
      ),
    );
  }
}
