import 'package:get/get.dart';
import 'package:flutter/material.dart';
import 'package:flutter/cupertino.dart';
import 'package:charts_flutter/flutter.dart' as charts;

import 'package:mwf_app/service/url.dart';
import 'package:mwf_app/service/color.dart';
import 'package:mwf_app/service/loader.dart';
import 'package:mwf_app/service/header.dart';
import 'package:mwf_app/service/screen.dart';
import 'package:mwf_app/service/convert.dart';
import 'package:mwf_app/service/fontsize.dart';
import 'package:mwf_app/service/notification_count.dart';

import 'package:mwf_app/home.dart';
import 'package:mwf_app/model/PerformanceChart_model.dart';

class PerformanceStatistics extends StatefulWidget {
  @override
  _PerformanceStatisticsState createState() => _PerformanceStatisticsState();
}

var chartWidgetActivity;
var chartCircleWidgetActivity;
var chartWidgetVisit;
var chartCircleWidgetVisit;
var chartWidgetVoc;
var chartCircleWidgetVoc;
var chartWidgetOfferService;
var chartCircleWidgetOfferService;
var titleLineActivity = "กิจกรรมแท่ง";
var titleLineVisit = "เยี่ยมเยือนแท่ง";
var titleLineVoc = "เสียงแท่ง";
var titleLineOfferService = "เสนอบริการเสริมแท่ง";
var titleCricleActivity = "กิจกรรมวงกลม";
var titleCricleVisit = "เยี่ยมเยือนวงกลม";
var titleCricleVoc = "เสียงวงกลม";
var titleCricleOfferService = "ผลการให้บริการเสริมที่ดำเนินการแล้วและแผนการให้บริการเสริม";
int fontDetailSize = 0;
Future _futureActivityCircle;
Future _futureActivityLine;

Future _futureVisitCircle;
Future _futureVisitLine;

Future _futureVoiceCircle;
Future _futureVoiceLine;

Future _futureOfferServiceCircle;
Future _futureOfferServiceLine;

class _PerformanceStatisticsState extends State<PerformanceStatistics> {
  bool isLoading = false;
  @override
  void initState() {
    super.initState();
    AppUrl.EmployeeID = NotificationCount.getPrefString('EmployeeID');
    Header.currentPage = "";
    Header.routes = HomePage();

    _futureActivityLine = _getDataActivityLine();
    _futureActivityCircle = _getDataActivityCircle();

    _futureVisitCircle = _getDataVisitCircle();
    _futureVisitLine = _getDataVisitLine();

    _futureVoiceCircle = _getDataVoiceCircle();
    _futureVoiceLine = _getDataVoiceLine();
    
    _futureOfferServiceCircle = _getDataOfferServiceCircle();
    _futureOfferServiceLine =  _getDataOfferServiceLine();
  }
  
  var dataActivity = [
    ClicksPerYear('ม.ค.', 0, AppColors.GOLD),
    ClicksPerYear('ก.พ.', 0, AppColors.GOLD),
    ClicksPerYear('มี.ค.', 0, AppColors.GOLD),
    ClicksPerYear('เม.ย.', 0, AppColors.GOLD),
    ClicksPerYear('พ.ค.', 0, AppColors.GOLD),
    ClicksPerYear('มิ.ย.', 0, AppColors.GOLD),
    ClicksPerYear('ก.ค.', 0, AppColors.GOLD),
    ClicksPerYear('ส.ค.', 0, AppColors.GOLD),
    ClicksPerYear('ก.ย.', 0, AppColors.GOLD),
    ClicksPerYear('ต.ค.', 0, AppColors.GOLD),
    ClicksPerYear('พ.ย.', 0, AppColors.GOLD),
    ClicksPerYear('ธ.ค.', 0, AppColors.GOLD),
  ];

  //  ข้อมูลเทสบนเครื่อง
  var dataActivity2 = [
    ClicksPieChart('กำลังดำเนินการ', '0', 0, AppColors.PURPLE),
    ClicksPieChart('ดำเนินการแล้ว', '0', 0, Color(0xFFBDD0D8)),
  ];

  var dataVisit = [
    ClicksPerYear('ม.ค.', 0, AppColors.GOLD),
    ClicksPerYear('ก.พ.', 0, AppColors.GOLD),
    ClicksPerYear('มี.ค.', 0, AppColors.GOLD),
    ClicksPerYear('เม.ย.', 0, AppColors.GOLD),
    ClicksPerYear('พ.ค.', 0, AppColors.GOLD),
    ClicksPerYear('มิ.ย.', 0, AppColors.GOLD),
    ClicksPerYear('ก.ค.', 0, AppColors.GOLD),
    ClicksPerYear('ส.ค.', 0, AppColors.GOLD),
    ClicksPerYear('ก.ย.', 0, AppColors.GOLD),
    ClicksPerYear('ต.ค.', 0, AppColors.GOLD),
    ClicksPerYear('พ.ย.', 0, AppColors.GOLD),
    ClicksPerYear('ธ.ค.', 0, AppColors.GOLD),
  ];

  //  ข้อมูลเทสบนเครื่อง
  var dataVisit2 = [
    ClicksPieChart('รอเยี่ยมเยือน', '0', 0, AppColors.PURPLE),
    ClicksPieChart('เยี่ยมเยือนแล้ว', '0', 0, AppColors.GOLD),
  ];

  var dataVoc = [
    ClicksPerYear('ม.ค.', 0, AppColors.GOLD),
    ClicksPerYear('ก.พ.', 0, AppColors.GOLD),
    ClicksPerYear('มี.ค.', 0, AppColors.GOLD),
    ClicksPerYear('เม.ย.', 0, AppColors.GOLD),
    ClicksPerYear('พ.ค.', 0, AppColors.GOLD),
    ClicksPerYear('มิ.ย.', 0, AppColors.GOLD),
    ClicksPerYear('ก.ค.', 0, AppColors.GOLD),
    ClicksPerYear('ส.ค.', 0, AppColors.GOLD),
    ClicksPerYear('ก.ย.', 0, AppColors.GOLD),
    ClicksPerYear('ต.ค.', 0, AppColors.GOLD),
    ClicksPerYear('พ.ย.', 0, AppColors.GOLD),
    ClicksPerYear('ธ.ค.', 0, AppColors.GOLD),
  ];

  //  ข้อมูลเทสบนเครื่อง
  var dataVoc2 = [
    ClicksPieChart('ชื่นชม', '0', 0, AppColors.PURPLE),
    ClicksPieChart('ตำนิ', '0', 0, AppColors.GOLD),
    ClicksPieChart('ตำนิ', '0', 0, AppColors.BLACK),
    ClicksPieChart('ตำนิ', '0', 0, AppColors.GREY),
    ClicksPieChart('ตำนิ', '0', 0, AppColors.WHITE),
    ClicksPieChart('ตำนิ', '0', 0, AppColors.BG_GREY),
  ];

  var dataBarChartOfferService = [
    ClicksPerYear('ม.ค.', 0, AppColors.GOLD),
    ClicksPerYear('ก.พ.', 0, AppColors.GOLD),
    ClicksPerYear('มี.ค.', 0, AppColors.GOLD),
    ClicksPerYear('เม.ย.', 0, AppColors.GOLD),
    ClicksPerYear('พ.ค.', 0, AppColors.GOLD),
    ClicksPerYear('มิ.ย.', 0, AppColors.GOLD),
    ClicksPerYear('ก.ค.', 0, AppColors.GOLD),
    ClicksPerYear('ส.ค.', 0, AppColors.GOLD),
    ClicksPerYear('ก.ย.', 0, AppColors.GOLD),
    ClicksPerYear('ต.ค.', 0, AppColors.GOLD),
    ClicksPerYear('พ.ย.', 0, AppColors.GOLD),
    ClicksPerYear('ธ.ค.', 0, AppColors.GOLD),
  ];

  var dataCircleOfferService = [
    ClicksPieChart('ชื่นชม', '0', 0, AppColors.PURPLE),
    ClicksPieChart('ตำนิ', '0', 0, AppColors.GOLD),
    ClicksPieChart('ตำนิ', '0', 0, AppColors.BLACK),
    ClicksPieChart('ตำนิ', '0', 0, AppColors.GREY),
    ClicksPieChart('ตำนิ', '0', 0, AppColors.WHITE),
    ClicksPieChart('ตำนิ', '0', 0, AppColors.BG_GREY),
  ];

  var titleLineActivity = "กิจกรรมแท่ง";
  var titleLineVisit = "เยี่ยมเยือนแท่ง";
  var titleLineVoc = "เสียงแท่ง";
  var titleLineOfferService = "เสนอบริการเสริมแท่ง";
  var titleCricleActivity = "กิจกรรมวงกลม";
  var titleCricleVisit = "เยี่ยมเยือนวงกลม";
  var titleCricleVoc = "เสียงวงกลม";
  var titleCircleOfferService = "เสนอบริการเสริมวงกลม";
  var arrayColor = [
    AppColors.PURPLE,
    AppColors.GOLD,
    AppColors.BLACK,
    AppColors.GREY,
    AppColors.bdColor,
    AppColors.BG_GREY
  ];

  Future<List<ClicksPerYear>> _getDataActivityLine() async {
    try{
      final listActivityLine = await PerformanceLine
        .getDataDashboardChartlineActivity();
      setState(() {
        titleLineActivity = listActivityLine["DashboardChartlineName"];
        var dataTemp = listActivityLine["DashboardChartlineValues"];

        dataTemp.forEach((v) {
          final scheduleList = LineValue.fromJson(v);
          dataActivity.add(ClicksPerYear(scheduleList.text,
              double.parse(scheduleList.value).floor(), AppColors.GOLD));
        });
      });
    }catch(e){
      print(e);
    }
    return dataActivity;
  }

  Future<List<ClicksPieChart>> _getDataActivityCircle() async {
    try{
      final listActivityCricle = await PerformanceLine
        .getDashboardCricleActivity();

      setState(() {
        titleCricleActivity = listActivityCricle["DashboardCircleName"];
        var dataTemp = listActivityCricle["DashboardCircleValues"];
        dataActivity2.clear();
        dataTemp.asMap().forEach((index, v) {
          final scheduleList = CircleValue.fromJson(v);
          dataActivity2.add(ClicksPieChart(
              scheduleList.text,
              scheduleList.value.split(".")[0] + " (" + scheduleList.percent.split(".")[0].toString() + "%)",
              double.parse(scheduleList.value).floor(),
              arrayColor[index]));
        });
      });
    }catch(e){
      print(e);
    }
    return dataActivity2;
  }

  Future<List<ClicksPerYear>> _getDataVisitLine() async {
    try{
      final listVisitLine = await PerformanceLine
        .getDataDashboardChartlineVisit();
    setState(() {
      titleLineVisit = listVisitLine["DashboardChartlineName"];
      var dataTemp = listVisitLine["DashboardChartlineValues"];

      dataTemp.forEach((v) {
        final scheduleList = LineValue.fromJson(v);
        dataVisit.add(ClicksPerYear(scheduleList.text,
            double.parse(scheduleList.value).floor(), AppColors.GOLD));
      });
    });
    }catch(e){
      print(e);
    }
    return dataVisit;
  }

  Future<List<ClicksPieChart>> _getDataVisitCircle() async {
    try{
      final listVisitCricle = await PerformanceLine
        .getDashboardCricleVisit();

      setState(() {
        titleCricleVisit = listVisitCricle["DashboardCircleName"];
        var dataTemp = listVisitCricle["DashboardCircleValues"];
        dataVisit2.clear();
        dataTemp.asMap().forEach((index, v) {
          final scheduleList = CircleValue.fromJson(v);
          dataVisit2.add(ClicksPieChart(
              scheduleList.text,
              scheduleList.value.split(".")[0] + " (" + scheduleList.percent.split(".")[0].toString() + "%)",
              double.parse(scheduleList.value).floor(),
              arrayColor[index]));
        });
      });
    }catch(e){
      print(e);
    }
    return dataVisit2;
  }

  Future<List<ClicksPerYear>> _getDataVoiceLine() async {
    try{
      final listVoc = await PerformanceLine
        .getDataDashboardChartlineVoc();
    setState(() {
      titleLineVoc = listVoc["DashboardChartlineName"];
      var dataTemp = listVoc["DashboardChartlineValues"];

      dataTemp.forEach((v) {
        final scheduleList = LineValue.fromJson(v);
        dataVoc.add(ClicksPerYear(scheduleList.text,
            double.parse(scheduleList.value).floor(), AppColors.GOLD));
      });
    });
    }catch(e){
      print(e);
    }
    return dataVoc;
  }

  Future<List<ClicksPieChart>> _getDataVoiceCircle() async {
    try{
      final listVocCricle = await PerformanceLine
        .getDashboardCricleVoc();

      setState(() {
        titleCricleVoc = listVocCricle["DashboardCircleName"];
        var dataTemp = listVocCricle["DashboardCircleValues"];
        dataVoc2.clear();
        dataTemp.asMap().forEach((i, v) {
          final scheduleList = CircleValue.fromJson(v);
          dataVoc2.add(ClicksPieChart(
              scheduleList.text,
              scheduleList.value.split(".")[0] + " (" + scheduleList.percent.split(".")[0].toString() + "%)",
              double.parse(scheduleList.value).floor(),
              arrayColor[i]));
        });
      });
    }catch(e){
      print(e);
    }
    return dataVoc2;
  }

  Future<List<ClicksPerYear>> _getDataOfferServiceLine() async {
    try{
      final listOfferService = await PerformanceStatistic.getData(); // ไปเรียกฟังชั่นดึงข้อมูลจาก api
      setState(() {
        titleLineOfferService = "Test";
        var dataTempOfferService = listOfferService['DataChart'];
        //dataBarChartOfferService.clear();
        dataTempOfferService.forEach((v) {
          final offerLine = DataChart.fromJson(v);
          dataBarChartOfferService.add(ClicksPerYear(MonthThai.convertMonthToThai(offerLine.yearMonths),
              offerLine.total, AppColors.GOLD));
        });
      });
    }catch(e){
      print(e);
    }
    return dataBarChartOfferService;
  }

  Future<List<ClicksPieChart>> _getDataOfferServiceCircle() async {
    try{
      final listOfferServiceCricle = await PerformanceStatistic.getData(); // ไปเรียกฟังชั่นดึงข้อมูลจาก api
      setState(() {
        titleCircleOfferService = "Test Circle";
        var datas = PerformanceStatistic.fromJson(listOfferServiceCricle);

        int summery = datas.cancelTotal + datas.completedTotal + datas.processTotal + datas.waitingProcessTotal;
        double percenOfWaiting = PerformanceStatistic.calcStatistic(summery, datas.waitingProcessTotal);
        double percenOfCancel = PerformanceStatistic.calcStatistic(summery, datas.cancelTotal);
        double percenOfCompleted = PerformanceStatistic.calcStatistic(summery, datas.completedTotal);
        double percenOfProcess = PerformanceStatistic.calcStatistic(summery, datas.processTotal);

        var dataCircleOfferServiecTemp = [
          {
            "name" : "รอดำเนินการ",
            "value" : datas.waitingProcessTotal,
            "percent" : percenOfWaiting,
          },
          {
            "name" : "ยกเลิกดำเนินการ",
            "value" : datas.cancelTotal,
            "percent" : percenOfCancel,
          },
          {
            "name" : "ดำเนินการเสร็จสิ้น",
            "value" : datas.completedTotal,
            "percent" : percenOfCompleted,
          },
          {
            "name" : "กำลังดำเนินการ",
            "value" : datas.processTotal,
            "percent" : percenOfProcess,
          },
        ];
        double value = 0.0;
        dataCircleOfferService.clear();
        dataCircleOfferServiecTemp.asMap().forEach((i,val) {
          if(val['value'] == 0){
            value = 0.0;
          }else{
            value = double.parse(val['value'].toString());
          }
          dataCircleOfferService.add(ClicksPieChart(
              val['name'],
              value.toString().split(".")[0] + " (" + val['percent'].toString().split(".")[0].toString() + "%)",
              value.floor(),
              arrayColor[i]));
        });
      });
    }catch(e){
      print(e);
    }
    return dataCircleOfferService;
  }

  @override
  Widget build(BuildContext context) {
    if (isLoading == true) {
      AppLoader.show();
    }
    if (isLoading == false) {
      AppLoader.hide();
    }
    double _width = MediaQuery.of(context).size.width;
    fontDetailSize = mediaQuery(context, 'w', 32).floor();
    //กราฟข้อมูลกิจกรรม
    var seriesActivity = [
      charts.Series(
        domainFn: (ClicksPerYear clickData, _) => clickData.year,
        measureFn: (ClicksPerYear clickData, _) => clickData.clicks,
        colorFn: (ClicksPerYear clickData, _) => clickData.color,
        labelAccessorFn: (ClicksPerYear clickData, _) => '${clickData.clicks}',
        id: 'Clicks',
        data: dataActivity,
      ),
    ];

    var seriesActivity2 = [
      charts.Series(
        domainFn: (ClicksPieChart clickData, _) => clickData.year,
        //measureFn: (ClicksPieChart clickData, _) => 2,
        measureFn: (ClicksPieChart clickData, _) => clickData.number,
        colorFn: (ClicksPieChart clickData, _) => clickData.color,
        labelAccessorFn: (ClicksPieChart clickData, _) => '${clickData.clicks}',
        id: 'Clicks',
        data: dataActivity2,
      ),
    ];

    var chartActivity = FutureBuilder(
      future: _futureActivityLine,
      builder: (BuildContext context, AsyncSnapshot snapshot) {
        if (snapshot.data == null && 
            snapshot.connectionState == ConnectionState.waiting || 
            snapshot.connectionState == ConnectionState.none) {
              return Container(
                child: Center(child: CircularProgressIndicator()),
              );
            }else if(snapshot.hasError){
              //AppLoader.hide();
              return Center(
                child: Text("เกิดข้อผิดพลาดในการโหลดข้อมูล", 
                  style: TextStyle(fontSize: mediaQuery(context, 'h', 40)),
              ));
            }else if(snapshot.connectionState == ConnectionState.done){
              return charts.BarChart(
                seriesActivity,
                animate: true,
                domainAxis: charts.OrdinalAxisSpec(
                  renderSpec: charts.SmallTickRendererSpec(
                      minimumPaddingBetweenLabelsPx: 0,
                      labelAnchor: charts.TickLabelAnchor.centered,
                      labelStyle: charts.TextStyleSpec(
                        fontSize: fontDetailSize,
                        color: charts.MaterialPalette.black,
                      ),
                      labelRotation: 60,
                      lineStyle:
                          charts.LineStyleSpec(color: charts.MaterialPalette.black)),
                ),
                defaultRenderer: charts.BarRendererConfig(
                  groupingType: charts.BarGroupingType.stacked,
                  stackHorizontalSeparator: 50,
                  barRendererDecorator: new charts.BarLabelDecorator(
                    labelPosition: charts.BarLabelPosition.outside,
                    outsideLabelStyleSpec: new charts.TextStyleSpec(
                      fontSize: fontDetailSize,
                      color: charts.ColorUtil.fromDartColor(Color(0xff202020)),
                      lineHeight: 0.14,
                    ),
                  ),
                )
              );
            } else {
              return charts.BarChart(
                seriesActivity,
                animate: true,
                domainAxis: charts.OrdinalAxisSpec(
                  renderSpec: charts.SmallTickRendererSpec(
                      minimumPaddingBetweenLabelsPx: 0,
                      labelAnchor: charts.TickLabelAnchor.centered,
                      labelStyle: charts.TextStyleSpec(
                        fontSize: fontDetailSize,
                        color: charts.MaterialPalette.black,
                      ),
                      labelRotation: 60,
                      lineStyle:
                          charts.LineStyleSpec(color: charts.MaterialPalette.black)),
                ),
                defaultRenderer: charts.BarRendererConfig(
                  groupingType: charts.BarGroupingType.stacked,
                  stackHorizontalSeparator: 50,
                  barRendererDecorator: new charts.BarLabelDecorator(
                    labelPosition: charts.BarLabelPosition.outside,
                    outsideLabelStyleSpec: new charts.TextStyleSpec(
                      fontSize: fontDetailSize,
                      color: charts.ColorUtil.fromDartColor(Color(0xff202020)),
                      lineHeight: 0.14,
                    ),
                  ),
                )
              );
            }
      });

    var chartCircleActivity = FutureBuilder(
      future: _futureActivityCircle,
      builder: (BuildContext context, AsyncSnapshot snapshot) {
        if (snapshot.data == null && 
            snapshot.connectionState == ConnectionState.waiting || 
            snapshot.connectionState == ConnectionState.none) {
              return Container(
                child: Center(child: CircularProgressIndicator()),
              );
            }else if(snapshot.hasError){
              return Center(
                child: Text("เกิดข้อผิดพลาดในการโหลดข้อมูล", 
                  style: TextStyle(fontSize: mediaQuery(context, 'h', 40)),
              ));
            }else if(snapshot.connectionState == ConnectionState.done){
              return charts.PieChart(
                seriesActivity2,
                animate: true,
                behaviors: [
                  charts.DatumLegend(
                    outsideJustification: charts.OutsideJustification.endDrawArea,
                    horizontalFirst: false,
                    desiredMaxRows: 1,
                    cellPadding: EdgeInsets.only(right: 4.0, bottom: 4.0, top: 4.0),
                    entryTextStyle: charts.TextStyleSpec(
                      fontFamily: 'Kanit',
                      fontSize: fontDetailSize,
                    ),
                  )
                ],
                defaultRenderer: charts.ArcRendererConfig(
                  startAngle: 10,
                  arcWidth: 30,
                  arcRendererDecorators: [
                    charts.ArcLabelDecorator(
                      showLeaderLines: false,
                      labelPosition: charts.ArcLabelPosition.auto,
                    )
                  ],
                ),
              );
            } else {
              return charts.PieChart(
                seriesActivity2,
                animate: true,
                behaviors: [
                  charts.DatumLegend(
                    outsideJustification: charts.OutsideJustification.endDrawArea,
                    horizontalFirst: false,
                    desiredMaxRows: 1,
                    cellPadding: EdgeInsets.only(right: 4.0, bottom: 4.0, top: 4.0),
                    entryTextStyle: charts.TextStyleSpec(
                      fontFamily: 'Kanit',
                      fontSize: fontDetailSize,
                    ),
                  )
                ],
                defaultRenderer: charts.ArcRendererConfig(
                  startAngle: 10,
                  arcWidth: 30,
                  arcRendererDecorators: [
                    charts.ArcLabelDecorator(
                      showLeaderLines: false,
                      labelPosition: charts.ArcLabelPosition.auto,
                    )
                  ],
                ),
              );
            }
        });

    var chartWidgetActivity = Padding(
      padding: EdgeInsets.all(
        mediaQuery(context, 'h', 20),
      ),
      child: SizedBox(
        height: mediaQuery(context, 'h', 900),
        child: chartActivity,
      ),
    );

    var chartCircleWidgetActivity = Padding(
      padding: EdgeInsets.all(
        mediaQuery(context, 'h', 20),
      ),
      child: SizedBox(
        height: mediaQuery(context, 'h', 900),
        child: chartCircleActivity,
      ),
    );

    //กราฟข้อมูลการเยี่ยมเยียน
    var seriesVisit = [
      charts.Series(
        domainFn: (ClicksPerYear clickData, _) => clickData.year,
        measureFn: (ClicksPerYear clickData, _) => clickData.clicks,
        colorFn: (ClicksPerYear clickData, _) => clickData.color,
        labelAccessorFn: (ClicksPerYear clickData, _) => '${clickData.clicks}',
        id: 'Clicks',
        data: dataVisit,
      ),
    ];

    var seriesVisit2 = [
      charts.Series(
        domainFn: (ClicksPieChart clickData, _) => clickData.year,
        measureFn: (ClicksPieChart clickData, _) => clickData.number,
        colorFn: (ClicksPieChart clickData, _) => clickData.color,
        labelAccessorFn: (ClicksPieChart clickData, _) => '${clickData.clicks}',
        id: 'Clicks',
        data: dataVisit2,
      ),
    ];

    var chartVisit = FutureBuilder(
      future: _futureVisitLine,
      builder: (BuildContext context, AsyncSnapshot snapshot) {
        if (snapshot.data == null && 
            snapshot.connectionState == ConnectionState.waiting || 
            snapshot.connectionState == ConnectionState.none) {
              return Container(
                child: Center(child: CircularProgressIndicator()),
              );
            }else if(snapshot.hasError){
              return Center(
                child: Text("เกิดข้อผิดพลาดในการโหลดข้อมูล", 
                  style: TextStyle(fontSize: mediaQuery(context, 'h', 40)),
              ));
            }else if(snapshot.connectionState == ConnectionState.done){
              return charts.BarChart(
                seriesVisit,
                animate: true,
                domainAxis: charts.OrdinalAxisSpec(
                  renderSpec: charts.SmallTickRendererSpec(
                      minimumPaddingBetweenLabelsPx: 0,
                      labelAnchor: charts.TickLabelAnchor.centered,
                      labelStyle: charts.TextStyleSpec(
                        fontSize: fontDetailSize,
                        color: charts.MaterialPalette.black,
                      ),
                      labelRotation: 60,
                      lineStyle:
                          charts.LineStyleSpec(color: charts.MaterialPalette.black)),
                ),
                defaultRenderer: charts.BarRendererConfig(
                  groupingType: charts.BarGroupingType.stacked,
                  stackHorizontalSeparator: 50,
                  barRendererDecorator: new charts.BarLabelDecorator(
                    labelPosition: charts.BarLabelPosition.outside,
                    outsideLabelStyleSpec: new charts.TextStyleSpec(
                      fontSize: fontDetailSize,
                      color: charts.ColorUtil.fromDartColor(Color(0xff202020)),
                      lineHeight: 0.14,
                    ),
                  ),
                ),
              );
            } else {
              return charts.BarChart(
                seriesVisit,
                animate: true,
                domainAxis: charts.OrdinalAxisSpec(
                  renderSpec: charts.SmallTickRendererSpec(
                      minimumPaddingBetweenLabelsPx: 0,
                      labelAnchor: charts.TickLabelAnchor.centered,
                      labelStyle: charts.TextStyleSpec(
                        fontSize: fontDetailSize,
                        color: charts.MaterialPalette.black,
                      ),
                      labelRotation: 60,
                      lineStyle:
                          charts.LineStyleSpec(color: charts.MaterialPalette.black)),
                ),
                defaultRenderer: charts.BarRendererConfig(
                  groupingType: charts.BarGroupingType.stacked,
                  stackHorizontalSeparator: 50,
                  barRendererDecorator: new charts.BarLabelDecorator(
                    labelPosition: charts.BarLabelPosition.outside,
                    outsideLabelStyleSpec: new charts.TextStyleSpec(
                      fontSize: fontDetailSize,
                      color: charts.ColorUtil.fromDartColor(Color(0xff202020)),
                      lineHeight: 0.14,
                    ),
                  ),
                ),
              );
            }
      });

   
    var chartCircleVisit = FutureBuilder(
      future: _futureVisitCircle,
      builder: (BuildContext context, AsyncSnapshot snapshot) {
        if (snapshot.data == null && 
            snapshot.connectionState == ConnectionState.waiting || 
            snapshot.connectionState == ConnectionState.none) {
              return Container(
                child: Center(child: CircularProgressIndicator()),
              );
            }else if(snapshot.hasError){
              return Center(
                child: Text("เกิดข้อผิดพลาดในการโหลดข้อมูล", 
                  style: TextStyle(fontSize: mediaQuery(context, 'h', 40)),
              ));
            }else if(snapshot.connectionState == ConnectionState.done){
              return charts.PieChart(
                seriesVisit2,
                animate: true,
                behaviors: [
                  charts.DatumLegend(
                    outsideJustification: charts.OutsideJustification.endDrawArea,
                    horizontalFirst: false,
                    desiredMaxRows: 1,
                    cellPadding: EdgeInsets.only(right: 4.0, bottom: 4.0, top: 4.0),
                    entryTextStyle: charts.TextStyleSpec(
                      fontFamily: 'Kanit',
                      fontSize: fontDetailSize,
                    ),
                  )
                ],
                defaultRenderer: charts.ArcRendererConfig(
                  startAngle: 15,
                  arcWidth: 30,
                  arcRendererDecorators: [
                    charts.ArcLabelDecorator(
                      showLeaderLines: false,
                      labelPosition: charts.ArcLabelPosition.outside,
                    )
                  ],
                ),
              );
            } else {
              return charts.PieChart(
                seriesVisit2,
                animate: true,
                behaviors: [
                  charts.DatumLegend(
                    outsideJustification: charts.OutsideJustification.endDrawArea,
                    horizontalFirst: false,
                    desiredMaxRows: 1,
                    cellPadding: EdgeInsets.only(right: 4.0, bottom: 4.0, top: 4.0),
                    entryTextStyle: charts.TextStyleSpec(
                      fontFamily: 'Kanit',
                      fontSize: fontDetailSize,
                    ),
                  )
                ],
                defaultRenderer: charts.ArcRendererConfig(
                  startAngle: 15,
                  arcWidth: 30,
                  arcRendererDecorators: [
                    charts.ArcLabelDecorator(
                      showLeaderLines: false,
                      labelPosition: charts.ArcLabelPosition.outside,
                    )
                  ],
                ),
              );
            }
      });

    var chartWidgetVisit = Padding(
      padding: EdgeInsets.all(
        mediaQuery(context, 'h', 20),
      ),
      child: SizedBox(
        height: mediaQuery(context, 'h', 900),
        child: chartVisit,
      ),
    );

    var chartCircleWidgetVisit = Padding(
      padding: EdgeInsets.all(
        mediaQuery(context, 'h', 20),
      ),
      child: SizedBox(
        height: mediaQuery(context, 'h', 900),
        child: chartCircleVisit,
      ),
    );

    //กราฟข้อมูลเสียงลูกค้า
    var seriesVoc = [
      charts.Series(
        domainFn: (ClicksPerYear clickData, _) => clickData.year,
        measureFn: (ClicksPerYear clickData, _) => clickData.clicks,
        colorFn: (ClicksPerYear clickData, _) => clickData.color,
        labelAccessorFn: (ClicksPerYear clickData, _) => '${clickData.clicks}',
        id: 'Clicks',
        data: dataVoc,
      ),
    ];

    var seriesVoc2 = [
      charts.Series(
        domainFn: (ClicksPieChart clickData, _) => clickData.year,
        measureFn: (ClicksPieChart clickData, _) => clickData.number,
        colorFn: (ClicksPieChart clickData, _) => clickData.color,
        labelAccessorFn: (ClicksPieChart clickData, _) => '${clickData.clicks}',
        id: 'Clicks',
        data: dataVoc2,
      ),
    ];

    var chartVoc = FutureBuilder(
      future: _futureVoiceLine,
      builder: (BuildContext context, AsyncSnapshot snapshot) {
        if (snapshot.data == null && 
            snapshot.connectionState == ConnectionState.waiting || 
            snapshot.connectionState == ConnectionState.none) {
              return Container(
                child: Center(child: CircularProgressIndicator()),
              );
            }else if(snapshot.hasError){
              return Center(
                child: Text("เกิดข้อผิดพลาดในการโหลดข้อมูล", 
                  style: TextStyle(fontSize: mediaQuery(context, 'h', 40)),
              ));
            }else if(snapshot.connectionState == ConnectionState.done){
              return charts.BarChart(
                seriesVoc,
                animate: true,
                domainAxis: charts.OrdinalAxisSpec(
                  renderSpec: charts.SmallTickRendererSpec(
                      minimumPaddingBetweenLabelsPx: 0,
                      labelAnchor: charts.TickLabelAnchor.centered,
                      labelStyle: charts.TextStyleSpec(
                        fontSize: fontDetailSize,
                        color: charts.MaterialPalette.black,
                      ),
                      labelRotation: 60,
                      lineStyle:
                          charts.LineStyleSpec(color: charts.MaterialPalette.black)),
                ),
                defaultRenderer: charts.BarRendererConfig(
                  groupingType: charts.BarGroupingType.stacked,
                  stackHorizontalSeparator: 50,
                  barRendererDecorator: new charts.BarLabelDecorator(
                    // labelAnchor: charts.BarLabelAnchor.middle,
                    labelPosition: charts.BarLabelPosition.outside,
                    outsideLabelStyleSpec: new charts.TextStyleSpec(
                      fontSize: fontDetailSize,
                      color: charts.ColorUtil.fromDartColor(Color(0xff202020)),
                      lineHeight: 0.14,
                    ),
                  ),
                ),
              );
            } else {
              return charts.BarChart(
                seriesVoc,
                animate: true,
                domainAxis: charts.OrdinalAxisSpec(
                  renderSpec: charts.SmallTickRendererSpec(
                      minimumPaddingBetweenLabelsPx: 0,
                      labelAnchor: charts.TickLabelAnchor.centered,
                      labelStyle: charts.TextStyleSpec(
                        fontSize: fontDetailSize,
                        color: charts.MaterialPalette.black,
                      ),
                      labelRotation: 60,
                      lineStyle:
                          charts.LineStyleSpec(color: charts.MaterialPalette.black)),
                ),
                defaultRenderer: charts.BarRendererConfig(
                  groupingType: charts.BarGroupingType.stacked,
                  stackHorizontalSeparator: 50,
                  barRendererDecorator: new charts.BarLabelDecorator(
                    // labelAnchor: charts.BarLabelAnchor.middle,
                    labelPosition: charts.BarLabelPosition.outside,
                    outsideLabelStyleSpec: new charts.TextStyleSpec(
                      fontSize: fontDetailSize,
                      color: charts.ColorUtil.fromDartColor(Color(0xff202020)),
                      lineHeight: 0.14,
                    ),
                  ),
                ),
              );
            }
      });

    var chartCircleVoc = FutureBuilder(
      future: _futureVoiceCircle,
      builder: (BuildContext context, AsyncSnapshot snapshot) {
        if (snapshot.data == null && 
            snapshot.connectionState == ConnectionState.waiting || 
            snapshot.connectionState == ConnectionState.none) {
              return Container(
                child: Center(child: CircularProgressIndicator()),
              );
            }else if(snapshot.hasError){
              return Center(
                child: Text("เกิดข้อผิดพลาดในการโหลดข้อมูล", 
                  style: TextStyle(fontSize: mediaQuery(context, 'h', 40)),
              ));
            }else if(snapshot.connectionState == ConnectionState.done){
              return charts.PieChart(
                seriesVoc2,
                animate: true,
                behaviors: [
                  charts.DatumLegend(
                    outsideJustification: charts.OutsideJustification.endDrawArea,
                    horizontalFirst: false,
                    desiredMaxRows: 3,
                    cellPadding:
                        EdgeInsets.only(left: 4.0, right: 4.0, bottom: 4.0, top: 4.0),
                    entryTextStyle: charts.TextStyleSpec(
                      fontFamily: 'Kanit',
                      fontSize: fontDetailSize,
                    ),
                  )
                ],
                defaultRenderer: charts.ArcRendererConfig(
                  startAngle: 20,
                  arcWidth: 30,
                  arcRendererDecorators: [
                    charts.ArcLabelDecorator(
                      showLeaderLines: false,
                      labelPosition: charts.ArcLabelPosition.outside,
                    )
                  ],
                ),
              );
            } else {
              return charts.PieChart(
                seriesVoc2,
                animate: true,
                behaviors: [
                  charts.DatumLegend(
                    outsideJustification: charts.OutsideJustification.endDrawArea,
                    horizontalFirst: false,
                    desiredMaxRows: 3,
                    cellPadding:
                        EdgeInsets.only(left: 4.0, right: 4.0, bottom: 4.0, top: 4.0),
                    entryTextStyle: charts.TextStyleSpec(
                      fontFamily: 'Kanit',
                      fontSize: fontDetailSize,
                    ),
                  )
                ],
                defaultRenderer: charts.ArcRendererConfig(
                  startAngle: 20,
                  arcWidth: 30,
                  arcRendererDecorators: [
                    charts.ArcLabelDecorator(
                      showLeaderLines: false,
                      labelPosition: charts.ArcLabelPosition.outside,
                    )
                  ],
                ),
              );
            }
      });

    

    var chartWidgetVoc = Padding(
      padding: EdgeInsets.all(
        mediaQuery(context, 'h', 20),
      ),
      child: SizedBox(
        height: mediaQuery(context, 'h', 900),
        child: chartVoc,
      ),
    );

    var chartCircleWidgetVoc = Padding(
      padding: EdgeInsets.all(
        mediaQuery(context, 'h', 50),
      ),
      child: SizedBox(
        height: mediaQuery(context, 'h', 900),
        child: chartCircleVoc,
      ),
    );

    ///  กราฟเสนอบริการเสริม
    var seriesBarOfferService = [
      charts.Series(
        domainFn: (ClicksPerYear clickData, _) => clickData.year,
        measureFn: (ClicksPerYear clickData, _) => clickData.clicks,
        colorFn: (ClicksPerYear clickData, _) => clickData.color,
        labelAccessorFn: (ClicksPerYear clickData, _) => '${clickData.clicks}',
        id: 'Clicks',
        data: dataBarChartOfferService,
      ),
    ];

    var seriesCircleOfferService = [
      charts.Series(
        domainFn: (ClicksPieChart clickData, _) => clickData.year,
        measureFn: (ClicksPieChart clickData, _) => clickData.number,
        colorFn: (ClicksPieChart clickData, _) => clickData.color,
        //labelAccessorFn: (ClicksPieChart clickData, _) => '1',
         labelAccessorFn: (ClicksPieChart clickData, _) => '${clickData.clicks}',
        id: 'Clicks',
        data: dataCircleOfferService,
      ),
    ];

    var chartOfferService = FutureBuilder(
      future: _futureOfferServiceLine,
      builder: (BuildContext context, AsyncSnapshot snapshot) {
        if (snapshot.data == null && 
            snapshot.connectionState == ConnectionState.waiting || 
            snapshot.connectionState == ConnectionState.none) {
              return Container(
                child: Center(child: CircularProgressIndicator()),
              );
            }else if(snapshot.hasError){
              return Center(
                child: Text("เกิดข้อผิดพลาดในการโหลดข้อมูล", 
                  style: TextStyle(fontSize: mediaQuery(context, 'h', 40)),
              ));
            }else if(snapshot.connectionState == ConnectionState.done){
              return charts.BarChart(
                seriesBarOfferService,
                animate: true,
                domainAxis: charts.OrdinalAxisSpec(
                  renderSpec: charts.SmallTickRendererSpec(
                      minimumPaddingBetweenLabelsPx: 0,
                      labelAnchor: charts.TickLabelAnchor.centered,
                      labelStyle: charts.TextStyleSpec(
                        fontSize: fontDetailSize,
                        color: charts.MaterialPalette.black,
                      ),
                      labelRotation: 60,
                      lineStyle:
                          charts.LineStyleSpec(color: charts.MaterialPalette.black)),
                ),
                defaultRenderer: charts.BarRendererConfig(
                  groupingType: charts.BarGroupingType.stacked,
                  stackHorizontalSeparator: 50,
                  barRendererDecorator: new charts.BarLabelDecorator(
                    // labelAnchor: charts.BarLabelAnchor.middle,
                    labelPosition: charts.BarLabelPosition.outside,
                    outsideLabelStyleSpec: new charts.TextStyleSpec(
                      fontSize: fontDetailSize,
                      color: charts.ColorUtil.fromDartColor(Color(0xff202020)),
                      lineHeight: 0.14,
                    ),
                  ),
                ),
              );
            } else {
              return charts.BarChart(
                seriesBarOfferService,
                animate: true,
                domainAxis: charts.OrdinalAxisSpec(
                  renderSpec: charts.SmallTickRendererSpec(
                    minimumPaddingBetweenLabelsPx: 0,
                    labelAnchor: charts.TickLabelAnchor.centered,
                    labelStyle: charts.TextStyleSpec(
                      fontSize: fontDetailSize,
                      color: charts.MaterialPalette.black,
                    ),
                    labelRotation: 60,
                    lineStyle:
                      charts.LineStyleSpec(color: charts.MaterialPalette.black)),
                ),
                defaultRenderer: charts.BarRendererConfig(
                  groupingType: charts.BarGroupingType.stacked,
                  stackHorizontalSeparator: 50,
                  barRendererDecorator: new charts.BarLabelDecorator(
                    // labelAnchor: charts.BarLabelAnchor.middle,
                    labelPosition: charts.BarLabelPosition.outside,
                    outsideLabelStyleSpec: new charts.TextStyleSpec(
                      fontSize: fontDetailSize,
                      color: charts.ColorUtil.fromDartColor(Color(0xff202020)),
                      lineHeight: 0.14,
                    ),
                  ),
                ),
              );
            }
      });

    

    var chartCircleOfferService = FutureBuilder(
      future: _futureOfferServiceCircle,
      builder: (BuildContext context, AsyncSnapshot snapshot) {
        if (snapshot.data == null && 
            snapshot.connectionState == ConnectionState.waiting || 
            snapshot.connectionState == ConnectionState.none) {
              return Container(
                child: Center(child: CircularProgressIndicator()),
              );
            }else if(snapshot.hasError){
              return Center(
                child: Text("เกิดข้อผิดพลาดในการโหลดข้อมูล", 
                  style: TextStyle(fontSize: mediaQuery(context, 'h', 40)),
              ));
            }else if(snapshot.connectionState == ConnectionState.done){
              return charts.PieChart(
                seriesCircleOfferService,
                animate: true,
                behaviors: [
                  charts.DatumLegend(
                    outsideJustification: charts.OutsideJustification.endDrawArea,
                    horizontalFirst: false,
                    desiredMaxRows: 3,
                    cellPadding:
                      EdgeInsets.only(left: 4.0, right: 4.0, bottom: 4.0, top: 4.0),
                      entryTextStyle: charts.TextStyleSpec(
                      fontFamily: 'Kanit',
                      fontSize: fontDetailSize,
                    ),
                  )
                ],
                defaultRenderer: charts.ArcRendererConfig(
                  startAngle: 4,
                  arcWidth: 30,
                  arcRendererDecorators: [
                    charts.ArcLabelDecorator(
                      showLeaderLines: false,
                      labelPosition: charts.ArcLabelPosition.outside,
                    )
                  ],
                ),
              );
            } else {
              return charts.PieChart(
                seriesCircleOfferService,
                animate: true,
                behaviors: [
                  charts.DatumLegend(
                    outsideJustification: charts.OutsideJustification.endDrawArea,
                    horizontalFirst: false,
                    desiredMaxRows: 3,
                    cellPadding:
                      EdgeInsets.only(left: 4.0, right: 4.0, bottom: 4.0, top: 4.0),
                      entryTextStyle: charts.TextStyleSpec(
                      fontFamily: 'Kanit',
                      fontSize: fontDetailSize,
                    ),
                  )
                ],
                defaultRenderer: charts.ArcRendererConfig(
                  startAngle: 4,
                  arcWidth: 30,
                  arcRendererDecorators: [
                    charts.ArcLabelDecorator(
                      showLeaderLines: false,
                      labelPosition: charts.ArcLabelPosition.outside,
                    )
                  ],
                ),
              );
            }
      });

    var chartWidgetOfferService = Padding(
      padding: EdgeInsets.all(
        mediaQuery(context, 'h', 20),
      ),
      child: SizedBox(
        height: mediaQuery(context, 'h', 900),
        child: chartOfferService,
      ),
    );

    var chartCircleWidgetOfferService = Padding(
      padding: EdgeInsets.all(
        mediaQuery(context, 'h', 20),
      ),
      child: SizedBox(
        height: mediaQuery(context, 'h', 900),
        child: chartCircleOfferService,
      ),
    );

    /// Start Draw Material to show on device
    return Material(
      color: AppColors.BG_GREY,
      child: WillPopScope(
        onWillPop: () async {
          Get.offAll(Header.routes);
          return false;
        },
        child: Stack(
          children: <Widget>[
            Header.header2ListPage(context),
            Header.mainMenu(context),
            Container(
              width: _width,
              height: mediaQuery(context, 'h', 1820),
              margin: EdgeInsets.only(
                top: mediaQuery(context, 'h', 400),
                left: mediaQuery(context, 'w', 60),
                right: mediaQuery(context, 'w', 60),
              ),
              child: SingleChildScrollView(
                child: Column(
                  children: <Widget>[
                    Row(
                      mainAxisAlignment: MainAxisAlignment.center,
                      children: <Widget>[
                        Text(
                          'สถิติผลการดำเนินงาน',
                          textAlign: TextAlign.center,
                          style: TextStyle(
                            color: Color(0xFFB58E38),
                            fontSize:
                                mediaQuery(context, 'h', AppFontSize.headText),
                          ),
                        ),
                      ],
                    ),
                    SizedBox(
                      height: mediaQuery(context, 'h', 60),
                    ),

                    //Activity
                    Row(
                      children: <Widget>[
                        Expanded(
                          child: Container(
                            decoration: BoxDecoration(
                              borderRadius: BorderRadius.all(
                                Radius.circular(
                                  mediaQuery(context, 'h', 60),
                                ),
                              ),
                              color: Colors.white,
                            ),
                            padding: EdgeInsets.all(
                              mediaQuery(context, 'h', 40),
                            ),
                            child: Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: <Widget>[
                                Text(
                                  titleLineActivity,
                                  style: TextStyle(
                                    fontSize: mediaQuery(context, 'h', 42),
                                    color: AppColors.BLACK,
                                  ),
                                ),
                                chartWidgetActivity
                              ],
                            ),
                          ),
                        ),
                      ],
                    ),
                    SizedBox(
                      height: mediaQuery(context, 'h', 60),
                    ),
                    Container(
                      width: mediaQuery(context, 'w', 1005),
                      decoration: BoxDecoration(
                        borderRadius: BorderRadius.all(
                          Radius.circular(
                            mediaQuery(context, 'h', 60),
                          ),
                        ),
                        color: Colors.white,
                      ),
                      padding: EdgeInsets.all(
                        mediaQuery(context, 'h', 40),
                      ),
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: <Widget>[
                          Text(
                            titleCricleActivity,
                            style: TextStyle(
                              fontSize: mediaQuery(context, 'h', 42),
                              color: AppColors.BLACK,
                            ),
                          ),
                          chartCircleWidgetActivity
                        ],
                      ),
                    ),
                    SizedBox(
                      height: mediaQuery(context, 'h', 60),
                    ),

                    //Visit
                    Row(
                      children: <Widget>[
                        Expanded(
                          child: Container(
                            decoration: BoxDecoration(
                              borderRadius: BorderRadius.all(
                                Radius.circular(
                                  mediaQuery(context, 'h', 60),
                                ),
                              ),
                              color: Colors.white,
                            ),
                            padding: EdgeInsets.all(
                              mediaQuery(context, 'h', 40),
                            ),
                            child: Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: <Widget>[
                                Text(
                                  titleLineVisit,
                                  style: TextStyle(
                                    fontSize: mediaQuery(context, 'h', 42),
                                    color: AppColors.BLACK,
                                  ),
                                ),
                                chartWidgetVisit
                              ],
                            ),
                          ),
                        ),
                      ],
                    ),
                    SizedBox(
                      height: mediaQuery(context, 'h', 60),
                    ),
                    Container(
                      width: mediaQuery(context, 'w', 1005),
                      decoration: BoxDecoration(
                        borderRadius: BorderRadius.all(
                          Radius.circular(
                            mediaQuery(context, 'h', 60),
                          ),
                        ),
                        color: Colors.white,
                      ),
                      padding: EdgeInsets.all(
                        mediaQuery(context, 'h', 40),
                      ),
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: <Widget>[
                          Text(
                            titleCricleVisit,
                            style: TextStyle(
                              fontSize: mediaQuery(context, 'h', 42),
                              color: AppColors.BLACK,
                            ),
                          ),
                          chartCircleWidgetVisit
                        ],
                      ),
                    ),
                    SizedBox(
                      height: mediaQuery(context, 'h', 60),
                    ),

                    //Voice
                    Row(
                      children: <Widget>[
                        Expanded(
                          child: Container(
                            decoration: BoxDecoration(
                              borderRadius: BorderRadius.all(
                                Radius.circular(
                                  mediaQuery(context, 'h', 60),
                                ),
                              ),
                              color: Colors.white,
                            ),
                            padding: EdgeInsets.all(
                              mediaQuery(context, 'h', 40),
                            ),
                            child: Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: <Widget>[
                                Text(
                                  titleLineVoc,
                                  style: TextStyle(
                                    fontSize: mediaQuery(context, 'h', 42),
                                    color: AppColors.BLACK,
                                  ),
                                ),
                                chartWidgetVoc
                              ],
                            ),
                          ),
                        ),
                      ],
                    ),
                    SizedBox(
                      height: mediaQuery(context, 'h', 60),
                    ),
                    Container(
                      width: mediaQuery(context, 'w', 1005),
                      decoration: BoxDecoration(
                        borderRadius: BorderRadius.all(
                          Radius.circular(
                            mediaQuery(context, 'h', 60),
                          ),
                        ),
                        color: Colors.white,
                      ),
                      padding: EdgeInsets.all(
                        mediaQuery(context, 'h', 40),
                      ),
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: <Widget>[
                          Text(
                            titleCricleVoc,
                            style: TextStyle(
                              fontSize: mediaQuery(context, 'h', 42),
                              color: AppColors.BLACK,
                            ),
                          ),
                          chartCircleWidgetVoc
                        ],
                      ),
                    ),
                    SizedBox(
                      height: mediaQuery(context, 'h', 60),
                    ),

                     //Make to OfferService
                    Row(
                      children: <Widget>[
                        Expanded(
                          child: Container(
                            decoration: BoxDecoration(
                              borderRadius: BorderRadius.all(
                                Radius.circular(
                                  mediaQuery(context, 'h', 60),
                                ),
                              ),
                              color: Colors.white,
                            ),
                            padding: EdgeInsets.all(
                              mediaQuery(context, 'h', 40),
                            ),
                            child: Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: <Widget>[
                                Text(
                                  //titleLineOfferService,
                                  "จำนวนการให้บริการเสริมรายเดือน",
                                  style: TextStyle(
                                    fontSize: mediaQuery(context, 'h', 42),
                                    color: AppColors.BLACK,
                                  ),
                                ),
                                //แก้ไขแสดงกราฟที่นี่
                                chartWidgetOfferService
                              ],
                            ),
                          ),
                        ),
                      ],
                    ),
                    SizedBox(
                      height: mediaQuery(context, 'h', 60),
                    ),
                    //เสนอบริการเสริมวงกลม
                    Container(
                      width: mediaQuery(context, 'w', 1005),
                      decoration: BoxDecoration(
                        borderRadius: BorderRadius.all(
                          Radius.circular(
                            mediaQuery(context, 'h', 60),
                          ),
                        ),
                        color: Colors.white,
                      ),
                      padding: EdgeInsets.all(
                        mediaQuery(context, 'h', 40),
                      ),
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: <Widget>[
                          Text(
                            titleCricleOfferService,
                            style: TextStyle(
                              fontSize: mediaQuery(context, 'h', 42),
                              color: AppColors.BLACK,
                            ),
                          ),
                          //แก้ไขแสดงกราฟที่นี่
                          chartCircleWidgetOfferService
                        ],
                      ),
                    ),
                    SizedBox(
                      height: mediaQuery(context, 'h', 60),
                    ),


                  ],
                ),
              ),
            ),
          ],
        ),
      ),
    );
  }
} //class

class Task {
  final int taskVal;
  final String taskDetails;
  final String colorVal;
  Task(this.taskDetails, this.taskVal, this.colorVal);

  Task.fromMap(Map<String, dynamic> map)
      : assert(map['taskdetails'] != null),
        assert(map['taskVal'] != null),
        assert(map['colorVal'] != null),
        taskDetails = map['taskdetails'],
        taskVal = map['taskVal'],
        colorVal = map['colorVal'];

  @override
  String toString() => "Record<$taskVal:$taskDetails>";
}

class SalesData {
  SalesData(this.year, this.sales, this.segmentColor);

  final String year;
  final double sales;
  final Color segmentColor;
}

class ClicksPerYear {
  final String year;
  final int clicks;
  final charts.Color color;

  ClicksPerYear(this.year, this.clicks, Color color)
      : this.color = charts.Color(
            r: color.red, g: color.green, b: color.blue, a: color.alpha);
}

class ClicksPieChart {
  final String year;
  final String clicks;
  final int number;
  final charts.Color color;

  ClicksPieChart(this.year, this.clicks, this.number, Color color)
      : this.color = charts.Color(
            r: color.red, g: color.green, b: color.blue, a: color.alpha);
}
