import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:mwf_app/service/assets.dart';
import 'package:mwf_app/service/screen.dart';
import 'package:mwf_app/model/StatusReadMasterReadList_model.dart';
import 'package:need_resume/need_resume.dart';
import 'package:mwf_app/set7/read_item.dart';

class ShowRead extends StatefulWidget {
  final String chatId;

  ShowRead({
    this.chatId,
  });

  @override
  _ShowReadState createState() => _ShowReadState();
}

class _ShowReadState extends ResumableState<ShowRead> {
  @override
  void onReady() {
    super.onReady();
    loadData();
  }

  @override
  void onResume() {
    super.onResume();
    loadData();
  }

  Future<void> loadData() async {
    final list = await StatusReadMasterReadList.getData(widget.chatId);
    setState(() {
      list.forEach((v) {
        final masterReadList = StatusReadMasterReadList.fromJson(v);
        StatusReadMasterReadList.data.add(masterReadList);
      });
    });
  }

  @override
  Widget build(BuildContext context) {
    var mediaquery = MediaQuery.of(context);

    return GestureDetector(
      child: Container(
        height: mediaquery.size.height,
        width: mediaquery.size.width,
        margin: EdgeInsets.all(mediaQuery(context, 'w', 50)),
        decoration: BoxDecoration(
          borderRadius: BorderRadius.all(Radius.circular(15.0)),
          color: Colors.white,
        ),
        child: Padding(
          padding: const EdgeInsets.all(5.0),
          child: Scaffold(
            backgroundColor: Colors.white,
            appBar: (AppBar(
              backgroundColor: Colors.white,
              elevation: 0.0,
              leading: Container(),
              actions: <Widget>[
                IconButton(
                  icon: Icon(
                    Icons.close,
                    color: Colors.black,
                  ),
                  onPressed: () {
                    Navigator.of(context, rootNavigator: true).pop();
                  },
                ),
              ],
            )),
            body: Container(
              child: ListView.builder(
                itemCount: StatusReadMasterReadList.data.length,
                itemBuilder: (context, position) {
                  return ListReaditem(
                    name: StatusReadMasterReadList.data[position].userName,
                    image: AppAssets.imageProfile,
                    createDate: StatusReadMasterReadList.data[position].createDate,
                    customerName: StatusReadMasterReadList.data[position].customerName,
                  );
                },
              ),
            ),
          ),
        ),
      ),
    );
  }
}
