import 'package:flutter/material.dart';
import 'package:flutter/widgets.dart';
import 'package:mwf_app/service/screen.dart';

class ListReaditem extends StatelessWidget {
  final String image;
  final String name;
  final String customerName;
  final String createDate;

  const ListReaditem({
    this.name,
    this.image,
    this.createDate,
    this.customerName,
  });

  @override
  Widget build(BuildContext context) {
    return Column(
      children: <Widget>[
        ListTile(
          title: Row(
            children: <Widget>[
              Container(
                child: ClipRRect(
                  child: Container(
                    child: SizedBox(
                      child: Image.asset(
                        image,
                        fit: BoxFit.cover,
                      ),
                    ),
                    color: Colors.orange,
                  ),
                  borderRadius: BorderRadius.circular(50),
                ),
                height: mediaQuery(context, 'h', 200),
                width: mediaQuery(context, 'h', 200),
                padding: const EdgeInsets.all(0.0),
                decoration: BoxDecoration(
                  border: Border.all(width: 3, color: Colors.white),
                  shape: BoxShape.circle,
                  color: Colors.black,
                  boxShadow: [
                    BoxShadow(
                      color: Colors.black26,
                      blurRadius: 5.0,
                      spreadRadius: 3,
                      offset: Offset(0.0, 5.0),
                    )
                  ],
                ),
              ),
              SizedBox(
                width: mediaQuery(context, 'w', 10),
              ),
              Container(
                constraints: BoxConstraints(
                    maxWidth: MediaQuery.of(context).size.width * .46),
                padding: const EdgeInsets.all(15.0),
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: <Widget> [
                    Text(
                      customerName,
                      style: TextStyle(
                        color: Colors.black,
                        fontSize: mediaQuery(context, 'h', 45),
                      ),
                    ),
                    Text(
                      name,
                      style: TextStyle(
                        color: Colors.black,
                        fontSize: mediaQuery(context, 'h', 45),
                      ),
                    ),
                    Text(
                      createDate,
                      style: TextStyle(
                        color: Colors.black,
                        fontSize: mediaQuery(context, 'h', 40),
                      ),
                    ),
                  ],
                ),
              ),
            ],
          ),
          trailing: Text(
            'อ่านแล้ว',
            style: TextStyle(
              color: Colors.grey,
              fontSize: mediaQuery(context, 'h', 50),
            ),
          ),
        ),
        Divider(
          endIndent: 20.0,
          indent: 30.0,
          height: 0,
        ),
      ],
    );
  }
}
