import 'package:flutter/material.dart';
import 'package:provider/provider.dart';
import 'package:cloud_firestore/cloud_firestore.dart';
import 'package:flutter_slidable/flutter_slidable.dart';

import 'package:mwf_app/service/url.dart';
import 'package:mwf_app/service/pref.dart';
import 'package:mwf_app/service/assets.dart';
import 'package:mwf_app/service/screen.dart';
import 'package:mwf_app/set7/chat_page.dart';
import 'package:mwf_app/service/strings.dart';
import 'package:mwf_app/service/notification_count.dart';

class ChatListGroup extends StatelessWidget {
  final String name;
  final String time;
  static int newMesssageCount;
  final bool hasUnreadMessage;
  final String chatMasterId;
  final String accountId;
  final String typeAccount;

  const ChatListGroup({
    this.name,
    this.time,
    this.hasUnreadMessage,
    this.chatMasterId,
    this.accountId,
    this.typeAccount,
  });

  static getCountGroup(chatMasterId) async {
    if(chatMasterId != ""){
      var number = await getPref("int", chatMasterId);
      if(number == null && chatMasterId == "fb0593bf-bee9-4350-845f-9aad236f7186"){
        setPref("int", chatMasterId, 0);
        newMesssageCount = 0;
      }else if(number != null && chatMasterId == "fb0593bf-bee9-4350-845f-9aad236f7186"){
        newMesssageCount = await getPref("int", chatMasterId);
        print(" group count $chatMasterId : " + newMesssageCount.toString());
      }
    }else{
      newMesssageCount = 0;
    }
  }

  @override
  Widget build(BuildContext context) {
    getCountGroup(chatMasterId);
    return Slidable(
      actionPane: SlidableDrawerActionPane(),
      actionExtentRatio: 0.25,
      child: Padding(
        padding: const EdgeInsets.all(8.0),
        child: Container(
          decoration: new BoxDecoration(
            shape: BoxShape.rectangle,
            borderRadius: BorderRadius.all(Radius.circular(8.0)),
            color: Color(0xff7F3F98),
            boxShadow: [
              BoxShadow(
                color: Colors.black26,
                blurRadius: 10.0,
                spreadRadius: 2,
                offset: Offset(0.0, 5.0),
              )
            ],
          ),
          width: mediaQuery(context, 'w', 1000),
          height: mediaQuery(context, 'h', 250),
          child: Column(
            mainAxisAlignment: MainAxisAlignment.center,
            crossAxisAlignment: CrossAxisAlignment.center,
            children: <Widget>[
              Row(
                children: <Widget>[
                  Expanded(
                    child: ListTile(
                      title: Row(
                        children: <Widget>[
                          Container(
                            child: Image.asset(
                              AppAssets.iconsgroup,
                              height: mediaQuery(context, 'h', 150),
                              width: mediaQuery(context, 'w', 150),
                            ),
                          ),
                          SizedBox(
                            width: mediaQuery(context, 'w', 20),
                          ),
                          Container(
                            height: mediaQuery(context, 'h', 160),
                            width: 1,
                            color: Colors.white,
                          ),
                          SizedBox(
                            width: mediaQuery(context, 'w', 20),
                          ),
                          Container(
                            child: Text(
                              name ?? "",
                              style: TextStyle(
                                fontSize: mediaQuery(context, 'w', 60),
                                fontWeight: FontWeight.bold,
                                color: Colors.white,
                              ),
                            ),
                          ),
                        ],
                      ),
                      trailing: Container(
                        child: Column(
                          children: <Widget>[
                            Text(
                              time ?? "",
                              style: TextStyle(color: Colors.white),
                            ),
                            StreamBuilder(
                              stream: FirebaseFirestore
                                .instance.collection(AppStrings.collection)
                                .doc("chat-masterid-fb0593bf-bee9-4350-845f-9aad236f7186").snapshots(),
                              builder: (BuildContext context,  snapshot) {
                                if(!snapshot.hasData){
                                  return SizedBox(width: 0,);
                                }else{
                                  int calc = 0;
                                  var number = snapshot.data["running_number"];
                                  print("Group number :: " + number.toString());
                                  if(chatMasterId == "fb0593bf-bee9-4350-845f-9aad236f7186" ){
                                    int storeGroup = NotificationCount.getCounts(chatMasterId+"_store");
                                    if(storeGroup != 0){
                                      calc = NotificationCount.calcNoti(chatMasterId, number);
                                    }else {
                                      setPref('int', chatMasterId+"_store", number);
                                      setPref('int', chatMasterId, 0);
                                      calc = 0;
                                    }
                                  }
                                  if(calc.isNegative){
                                    calc = 0;
                                  }
                                  
                                  if(number != 0){
                                    if(number > 99){
                                      number = "99+";
                                    }
                                    return _notifyAlert(context, calc);
                                  }else{
                                    return SizedBox(width: 0,);
                                  }
                                }
                              },
                            ),
                          ],
                        ),
                      ),
                      onTap: () async {
                        AppUrl.chatMasterId = "fb0593bf-bee9-4350-845f-9aad236f7186";
                        AppUrl.typeAccount = "2ae2539c-4a49-4578-9bd3-136eab70ddfc";
                        AppUrl.accountId = accountId;
                        int currentNewMsg = NotificationCount.getCounts(chatMasterId);
                        int calc = 0;
                        bool checkChat = await checkPref("chat");
                        if(checkChat){
                          var chat = await getPref('int', "chat");
                          calc = chat - currentNewMsg;
                          if(calc.isNegative){
                            calc = 0;
                          }
                        }else{
                          setPref("int", "chat", 0);
                        }
                        Provider.of<NotificationCount>(context,listen: false).addChatCount(calc);
                        setPref('int', "chat", calc);
                        setPref("int", chatMasterId, 0);
                        Navigator.push(
                          context,
                          MaterialPageRoute(
                            builder: (context) => ChatPages(
                              masterId: "fb0593bf-bee9-4350-845f-9aad236f7186",
                              customerId : "",
                              roomName: name,
                              id: "0325d48b-0e85-4fce-854a-88328d417426",
                              roomType: "group",
                            ),
                          ),
                        );
                      },
                    ),
                  ),
                ],
              ),
            ],
          ),
        ),
      ),
      secondaryActions: <Widget>[
        IconSlideAction(
          caption: 'Archive',
          color: Colors.blue,
          icon: Icons.archive,
          onTap: () {},
        ),
        IconSlideAction(
          caption: 'Share',
          color: Colors.indigo,
          icon: Icons.share,
          onTap: () {},
        ),
      ],
    );
  }

  Widget _notifyAlert(context, int number){
    return number != 0 ? 
    Container(
      margin: EdgeInsets.only(
        top: mediaQuery(context, 'w', 5.0),
      ),
      height: mediaQuery(context, 'h', 80),
      width: mediaQuery(context, 'w', 80),                                  
      decoration: BoxDecoration(
        color: Colors.white,
        borderRadius: BorderRadius.all(
          Radius.circular(25.0),
        ),
      ),
      child: Center(
        child: Text(
          "$number",
          style: TextStyle(
            fontSize: mediaQuery(context, 'h', 45),
            color: Colors.black,
          ),
        ),
      ),
    ) : SizedBox(width: 0,);
  }
}
