import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mwf_app/model/Permission_model.dart';
import 'package:mwf_app/service/color.dart';
import 'package:mwf_app/service/header.dart';
import 'package:mwf_app/service/loader.dart';
import 'package:mwf_app/service/screen.dart';
import 'package:mwf_app/service/shadow.dart';
import 'package:mwf_app/service/strings.dart';
import 'package:mwf_app/model/voice.dart';
import 'package:mwf_app/set1/serve_customers.dart';
import 'package:mwf_app/set6/customer_voice_save.dart';
import 'package:mwf_app/set6/customer_voice_view.dart';
import 'package:need_resume/need_resume.dart';

class ServiceReportUser extends StatefulWidget {
 
  ServiceReportUser();

  @override
  _ServiceReportUserState createState() => _ServiceReportUserState();
}

class _ServiceReportUserState extends ResumableState<ServiceReportUser> {
  _ServiceReportUserState();

  bool isLoading = false;
  String isView = '';
  String isAdd = '';
  String isUpdate = '';
  String isDelete = '';
  String isAll = '';

  @override
  void onReady() {
    print('Screen is ready! service_report_user.dart');
    print('Permission for this menu ...');
    setPermission();
    loadData(); // ดึงข้อมูล
  }

  @override
  void onResume() {
    loadData(); // ดึงข้อมูลใหม่
    print('Screen is resumed!');
  }

  @override
  void onPause() {
    print('Screen is paused!');
  }

  setPermission() async {
    var data = await Permission.getResource("menuReportUserData");
    isAdd = data.add;
    isUpdate = data.edit;
    isDelete = data.delete;
    isAll = data.all;
    print("isView -->" + isView);
    print("isAdd -->" + isAdd);
    print("isUpdate -->" + isUpdate);
    print("isDelete -->" + isDelete);
    print("isAll -->" + isAll);
  }

  Future<void> loadData() async {
    print('Screen service_report_user : loadData');
    setState(() {
      isLoading = true;
    });
    AppLoader.show();
    try {
      final list = await Voice.getData(); // ไปเรียกฟังชั่นดึงข้อมูลจาก api
      setState(() {
        list.forEach((v) {
          final voiceList = Voice.fromJson(v);
          Voice.data.add(voiceList); // loop เก็บข้อมูล
        });
      });
      await new Future.delayed(const Duration(milliseconds: 2000));
      setState(() {
        isLoading = false;
      });
    } catch (e) {
      setState(() {
        isLoading = false;
      });
      print(e);
    }
    AppLoader.hide();
  }

  @override
  Widget build(BuildContext context) {
    double _width = MediaQuery.of(context).size.width;
    Header.routes = ServeCustomer();
    return Material(
      color: AppColors.bgColor,
      child: WillPopScope(
        onWillPop: () async {
          Get.offAll(Header.routes);
          return false;
        },
        child: Stack(
          children: <Widget>[
            Header.headerListPage(context),
            Header.mainMenu(context),
            Container(
              width: _width,
              margin: EdgeInsets.only(
                top: mediaQuery(context, 'h', 950),
                left: mediaQuery(context, 'w', 60),
                right: mediaQuery(context, 'w', 60),
                bottom: mediaQuery(context, 'h', 30),
              ),
              child: Column(
                children: <Widget>[
                  Container(
                    alignment: Alignment.center,
                    margin: EdgeInsets.only(
                      bottom: mediaQuery(context, 'h', 60),
                    ),
                    child: Row(
                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                      children: <Widget>[
                        Container(
                          width: mediaQuery(context, 'w', 200),
                        ),
                        Text(
                          AppStrings.service_report_user,
                          style: TextStyle(
                            color: Color(0xFFB58E38),
                            fontSize: mediaQuery(context, 'h', 70),
                          ),
                        ),
                        isAdd == "1" || isAdd == '' || isAll == "1"
                            ? GestureDetector(
                                onTap: () {
                                  push(
                                    context,
                                    MaterialPageRoute(
                                      builder: (context) => CustomerVoiceSave(),
                                    ),
                                  );
                                },
                                child: Row(
                                  children: <Widget>[
                                    Icon(
                                      Icons.add_circle_outline,
                                      size: mediaQuery(context, 'h', 100),
                                      color: AppColors.color,
                                    ),
                                    SizedBox(
                                      width: mediaQuery(context, 'w', 14),
                                    ),
                                    Text(
                                      AppStrings.addTask,
                                      style: TextStyle(
                                        color: AppColors.color,
                                        fontSize: mediaQuery(context, 'h', 40),
                                      ),
                                    ),
                                  ],
                                ),
                              )
                            : Container(width: mediaQuery(context, 'w', 14)),
                      ],
                    ),
                  ),
                ],
              ),
            ),
            Container(
              width: _width,
              height: mediaQuery(context, 'h', 1150),
              margin: EdgeInsets.only(
                top: mediaQuery(context, 'h', 1100),
                left: mediaQuery(context, 'w', 60),
                right: mediaQuery(context, 'w', 60),
              ),
              child: SingleChildScrollView(
                child: Column(
                  children: List.generate(Voice.data.length, (index) {
                    return _buildContent(
                      context,
                      (index + 1).toString(),
                      Voice.data[index].date,
                      Voice.data[index].complaintNo,
                      Voice.data[index].voiceType,
                      Voice.data[index].voiceStatus,
                      false,
                      index,
                      Voice.data[index].complainerID,
                    );
                  }),
                ),
              ),
            )
          ],
        ),
      ),
    );
  }

  _buildContent(context, number, datetime, numberReport, type, status,
      bool statuscolor, index, complainerID) {
    return Container(
      width: mediaQuery(context, 'w', 1005),
//      height: mediaQuery(context, 'h', 380),
      padding: EdgeInsets.all(
        mediaQuery(context, 'h', 50),
      ),
      margin: EdgeInsets.only(
        bottom: mediaQuery(context, 'h', 40),
      ),
      decoration: BoxDecoration(
        borderRadius: new BorderRadius.all(
          Radius.circular(
            mediaQuery(context, 'h', 20),
          ),
        ),
        boxShadow: [
          appShadow(),
        ],
        color: Colors.white,
      ),
      child: Row(
        children: <Widget>[
          Container(
            width: mediaQuery(context, 'w', 780),
            child: Wrap(
              spacing: 5.0,
              runSpacing: 5.0,
              direction: Axis.vertical,
              children: <Widget>[
                Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: <Widget>[
                    Row(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: <Widget>[
                        Text(
                          'ลำดับ : ',
                          style: TextStyle(
                            color: AppColors.color_text,
                            fontSize: mediaQuery(context, 'h', 42),
                          ),
                        ),
                        Text(
                          number,
                          style: TextStyle(
                            color: AppColors.color_text,
                            fontSize: mediaQuery(context, 'h', 40),
                          ),
                        ),
                      ],
                    ),
                    Row(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: <Widget>[
                        Text(
                          'วันเวลา : ',
                          style: TextStyle(
                            color: AppColors.color_text,
                            fontSize: mediaQuery(context, 'h', 42),
                          ),
                        ),
                        Text(
                          datetime == null ? "" : datetime,
                          style: TextStyle(
                            color: AppColors.color_text,
                            fontSize: mediaQuery(context, 'h', 40),
                          ),
                        ),
                      ],
                    ),
                    Row(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: <Widget>[
                        Text(
                          'หมายเลขขอร้องเรียน : ',
                          style: TextStyle(
                            color: AppColors.color_text,
                            fontSize: mediaQuery(context, 'h', 42),
                          ),
                        ),
                        Text(
                          numberReport ?? "",
                          style: TextStyle(
                            color: AppColors.color_text,
                            fontSize: mediaQuery(context, 'h', 40),
                          ),
                        ),
                      ],
                    ),
                    Row(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: <Widget>[
                        Text(
                          'ประเภท : ',
                          style: TextStyle(
                            color: AppColors.color_text,
                            fontSize: mediaQuery(context, 'h', 42),
                          ),
                        ),
                        Text(
                          type == null ? "" : type,
                          style: TextStyle(
                            color: AppColors.color_text,
                            fontSize: mediaQuery(context, 'h', 40),
                          ),
                        ),
                      ],
                    ),
                    Row(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: <Widget>[
                        Text(
                          'สถานะ : ',
                          style: TextStyle(
                            color: AppColors.color_text,
                            fontSize: mediaQuery(context, 'h', 42),
                          ),
                        ),
                        statuscolor == true
                            ? Text(
                                status == null ? "" : status,
                                style: TextStyle(
                                  color: Colors.green,
                                  fontSize: mediaQuery(context, 'h', 40),
                                ),
                              )
                            : Text(
                                status == null ? "" : status,
                                style: TextStyle(
                                  color: AppColors.color_gold,
                                  fontSize: mediaQuery(context, 'h', 40),
                                ),
                              )
                      ],
                    ),
                  ],
                ),
              ],
            ),
          ),
          isView == "1" || isView.isEmpty || isAll == "1"
              ? Flexible(
                  child: GestureDetector(
                    onTap: () {
                      push(
                        context,
                        MaterialPageRoute(
                          builder: (context) =>
                              CustomerVoiceView(index, complainerID),
                        ),
                      );
                    },
                    child: Container(
                      alignment: Alignment.center,
                      padding: EdgeInsets.only(
                        left: mediaQuery(context, 'w', 40),
                      ),
                      child: Center(
                        child: Icon(
                          Icons.search,
                          size: mediaQuery(context, 'h', 100),
                          color: AppColors.color,
                        ),
                      ),
                    ),
                  ),
                )
              : Text(""),
        ],
      ),
    );
  }
}
