import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mwf_app/service/color.dart';
import 'package:mwf_app/service/header.dart';
import 'package:mwf_app/service/loader.dart';
import 'package:mwf_app/service/navigator.dart';
import 'package:mwf_app/service/screen.dart';
import 'package:mwf_app/service/shadow.dart';
import 'package:mwf_app/service/style.dart';
import 'package:mwf_app/model/Survey_model.dart';
import 'package:mwf_app/set1/serve_customers.dart';
import 'package:mwf_app/set6/service_survey.dart';

//Survey_model
class SaveSurveyList extends StatefulWidget {
  @override
  _SaveSurveyListState createState() => _SaveSurveyListState();
}

class _SaveSurveyListState extends State<SaveSurveyList> {
  static List<dynamic> surveyList = [
    {"sGId": "S0004", "sQName": "แบบสำรวจหม้อแปลงไฟฟ้า"},
    {"sGId": "S0004", "sQName": "แบบสำรวจหม้อแปลงไฟฟ้า"},
    {"sGId": "S0004", "sQName": "แบบสำรวจหม้อแปลงไฟฟ้า"},
  ]; // รายการบันทึกแบบสำรวจ  // ถ้ามี api มา ลบค่าออก
  bool isLoading = false;

  @override
  void initState() {
    super.initState();
    print("set6/save_survey_list.dart");
    loadData(); // ดึงข้อมูล
  }

  loadData() async {
    setState(() {
      isLoading = true;
    });
    try {
      final list = await Survey.getData(); // ไปเรียกฟังชั่นดึงข้อมูลจาก api
      setState(() {
        list.forEach((v) {
          final sList = Survey.fromJson(v);
          Survey.data.add(sList); // loop เก็บข้อมูล
        });
      });
      await new Future.delayed(const Duration(milliseconds: 2000));
      setState(() {
        isLoading = false;
      });
    } catch (e) {
      print(e);
    }
  }

  @override
  Widget build(BuildContext context) {
    if (isLoading == true) {
      AppLoader.show();
    }
    if (isLoading == false) {
      AppLoader.hide();
    }
    double _width = MediaQuery.of(context).size.width;
    double _height = MediaQuery.of(context).size.height;
    Header.routes = ServeCustomer();
    return Material(
      color: AppColors.bgColor,
      child:  WillPopScope(
        onWillPop: () async {
          Get.offAll(Header.routes);
          return false;
        },
        child: Stack(
          children: <Widget>[
            Header.headerListPage(context),
            Header.mainMenu(context),
            Container(
              margin: EdgeInsets.only(
                top: mediaQuery(context, 'h', 950),
              ),
              child: Row(
                mainAxisAlignment: MainAxisAlignment.center,
                children: <Widget>[
                  Text(
                    "บันทึกแบบสำรวจ",
                    style: AppStyle.headTextStyle(context),
                  )
                ],
              ),
            ),
            Container(
              //color: Colors.red,
              width: _width,
              height: mediaQuery(context, 'h', 1100),
              margin: EdgeInsets.only(
                top: mediaQuery(context, 'h', 1100),
                left: mediaQuery(context, 'w', 40),
                right: mediaQuery(context, 'w', 40),
              ),
              child: SingleChildScrollView(
                child: Column(
                  mainAxisAlignment: MainAxisAlignment.center,
                  children: <Widget>[
                    Column(
                      children: List.generate(Survey.data.length, (index) {
                        return _buildContent(
                          context,
                          Survey.data[index].sQCode,
                          Survey.data[index].sQName,
                          Survey.data[index].sQId,
                        );
                      }),
                    ),
                  ],
                ),
              ),
            ),
          ],
        ),
      ),
    );
  }

  _buildSizeBox(context) {
    return SizedBox(
      height: mediaQuery(context, "h", 15),
    );
  }

  _buildContent(context, String code, String detail, String sQId) {
    return Container(
      margin: EdgeInsets.only(
        bottom: mediaQuery(context, 'h', 35),
      ),
      child: Row(
        mainAxisAlignment: MainAxisAlignment.center,
        children: <Widget>[
          GestureDetector(
            onTap: () {
              print("Code : " + code + ", SQ_ID : " + sQId);
              Nav.push(context, service_survey(sQId, code, detail));
            },
            child: Container(
              width: mediaQuery(context, 'w', 1008),
              height: mediaQuery(context, 'h', 150),
              decoration: BoxDecoration(
                borderRadius: new BorderRadius.all(
                  Radius.circular(
                    mediaQuery(context, 'h', 140),
                  ),
                ),
                boxShadow: [
                  BoxShadow(
                    offset: Offset(2.0, 2.0),
                    blurRadius: 10.0,
                    color: Color(0xFF000000).withOpacity(0.10),
                  ),
                ],
                color: Colors.white,
              ),
              child: Row(
                children: <Widget>[
                  Container(
                    width: mediaQuery(context, 'w', 310),
                    height: mediaQuery(context, 'h', 150),
                    padding: EdgeInsets.all(
                      mediaQuery(context, 'h', 35),
                    ),
                    decoration: BoxDecoration(
                      borderRadius: new BorderRadius.all(
                        Radius.circular(
                          mediaQuery(context, 'h', 70),
                        ),
                      ),
                      boxShadow: [
                        appShadow(),
                      ],
                      color: AppColors.color,
                    ),
                    child: Text(
                      code,
                      textAlign: TextAlign.center,
                      style: TextStyle(
                        fontSize: mediaQuery(context, 'h', 50),
                        color: Colors.white,
                        fontWeight: FontWeight.bold,
                      ),
                    ),
                  ),
                  Container(
                    //color: Colors.red,
                    padding: EdgeInsets.only(
                      left: mediaQuery(context, 'w', 50),
                    ),
                    width: mediaQuery(context, 'h', 750),
                    child: Text(
                      detail,
                      style: TextStyle(
                        fontSize: mediaQuery(context, 'h', 50),
                        color: Color(0xFF383838),
                      ),
                    ),
                  ),
                ],
              ),
            ),
          ),
        ],
      ),
    );
  }
} //class
