import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:mwf_app/service/color.dart';
import 'package:mwf_app/service/header.dart';
import 'package:mwf_app/service/screen.dart';
import 'package:mwf_app/service/strings.dart';
import 'package:mwf_app/service/style.dart';

class CreateActivity extends StatefulWidget {
  @override
  _CreateActivityState createState() => _CreateActivityState();
}

class _CreateActivityState extends State<CreateActivity> {
  TextEditingController subject = TextEditingController(); //เรื่อง
  TextEditingController startDate = TextEditingController(); // วันที่เริ่มต้น
  TextEditingController startTime = TextEditingController(); //เวลาที่เริ่มต้น
  TextEditingController endDate = TextEditingController(); //วันที่สิ้นสุด
  TextEditingController endTime = TextEditingController(); //เวลาที่สิ้นสุด
  TextEditingController peopleInvited =
      TextEditingController(); //จำนวนคนที่เชิญ
  TextEditingController peopleAttended =
      TextEditingController(); //จำนวนคนที่ร่วมงาน

  final List<String> _dropdownStatus = [
    "ระบุประเภทกิจกรรม",
    "...",
    "Three",
    "Four",
    "Five"
  ]; //The list of values we want on the dropdown
  @override
  void initState() {
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    double _width = MediaQuery.of(context).size.width;

    return Material(
      color: AppColors.bgColor,
      child: Stack(
        children: <Widget>[
          Header.header1(context),
          Header.mainMenu(context),
          Container(
            margin: EdgeInsets.only(
              top: mediaQuery(context, 'h', 950),
            ),
            child: Row(
              mainAxisAlignment: MainAxisAlignment.center,
              children: <Widget>[
                Text(
                  "สร้างกิจกรรม",
                  style: AppStyle.headTextStyle(context),
                )
              ],
            ),
          ),
          Container(
//            color: Colors.teal,
            width: _width,
            height: mediaQuery(context, 'h', 1100),
            margin: EdgeInsets.only(
              top: mediaQuery(context, 'h', 1100),
              left: mediaQuery(context, 'w', 60),
              right: mediaQuery(context, 'w', 60),
            ),
            child: SingleChildScrollView(
              child: Column(
                children: <Widget>[
                  _buildTextMenu(context, "เรื่อง :"),
                  _buildSizeBox(context),
                  _buildRow(context, subject),
                  _buildSizeBox(context),
                  _buildTextMenuTwoColumn(
                      context, 'วันที่เริ่มต้น :', "เวลา :", 400.0),
                  _buildSizeBox(context),
                  _buildTextFieldTwoColumn(context, startDate, startTime),
                  _buildSizeBox(context),
                  _buildTextMenuTwoColumn(context, AppStrings.TaskList_EndDate,
                      AppStrings.TaskList_time, 400.0),
                  _buildSizeBox(context),
                  _buildSizeBox(context),
                  _buildTextFieldTwoColumn(context, endDate, endTime),
                  _buildSizeBox(context),
                  _buildTextMenu(context, "ประเภทกิจกรรม :"),
                  _buildSizeBox(context),
                  _buildDropDown(context, _dropdownStatus),
                  _buildButtonRow(
                      context, "ค้นหา", AppColors.color_gold, Colors.white),
                  _buildSizeBox(context),
                  _buildTextMenuTwoColumn(context, 'จำนวนคนที่เชิญ :',
                      "จำนวนคนที่ร่วมงาน :", 400.0),
                  _buildTextFieldTwoColumnNoIcon(
                      context, peopleInvited, peopleAttended),
                  Row(
                    mainAxisAlignment: MainAxisAlignment.spaceEvenly,
                    children: <Widget>[
                      _buildButton(
                          context, "ยกเลิก", Colors.white, AppColors.color),
                      _buildButton(
                          context, "บันทึก", AppColors.color, Colors.white),
                    ],
                  ),
                ],
              ),
            ),
          ),
        ],
      ),
    );
  }

  _buildButtonRow(context, text, bgColor, fontColor) {
    return Row(
      mainAxisAlignment: MainAxisAlignment.center,
      children: <Widget>[
        ButtonTheme(
          minWidth: mediaQuery(context, "w", 1005),
          height: mediaQuery(context, "h", 120),
          child: FlatButton(
            shape: new RoundedRectangleBorder(
                borderRadius: new BorderRadius.circular(
                  mediaQuery(context, "w", 50),
                ),
                side: BorderSide(color: AppColors.color)),
            color: bgColor,
            textColor: Colors.red,
            padding: EdgeInsets.all(
              mediaQuery(context, "w", 10),
            ),
            onPressed: () {
              print(text);
            },
            child: Text(
              text,
              style: TextStyle(
                fontSize: 14.0,
                color: fontColor,
              ),
            ),
          ),
        )
      ],
    );
  }

  _buildButton(context, text, bgColor, fontColor) {
    return ButtonTheme(
      minWidth: mediaQuery(context, "w", 477),
      height: mediaQuery(context, "h", 120),
      child: FlatButton(
        shape: new RoundedRectangleBorder(
            borderRadius: new BorderRadius.circular(
              mediaQuery(context, "w", 50),
            ),
            side: BorderSide(color: AppColors.color)),
        color: bgColor,
        textColor: Colors.red,
        padding: EdgeInsets.all(
          mediaQuery(context, "w", 10),
        ),
        onPressed: () {
          if (text == "บันทึก") {
            //
          } else {
            Navigator.of(context).pop(false);
          }
          print(text);
        },
        child: Text(
          text,
          style: TextStyle(
            fontSize: 14.0,
            color: fontColor,
          ),
        ),
      ),
    );
  }

  _buildDropDown(context, List<String> _dropdownValues) {
    return Row(
      mainAxisAlignment: MainAxisAlignment.center,
      children: <Widget>[
        Container(
          height: mediaQuery(context, 'h', 110),
          width: mediaQuery(context, 'w', 1005),
          padding: EdgeInsets.symmetric(horizontal: 10.0),
          decoration: BoxDecoration(
            color: Colors.white,
            borderRadius: BorderRadius.circular(53.0),
            border: Border.all(
                color: AppColors.color_border,
                style: BorderStyle.solid,
                width: 0.80),
          ),
          child: DropdownButtonHideUnderline(
            child: DropdownButton(
              style: TextStyle(
                color: AppColors.Black,
                fontSize: mediaQuery(context, "w", 30),
              ),
              items: _dropdownValues
                  .map((value) => DropdownMenuItem(
                        child: Text(value),
                        value: value,
                      ))
                  .toList(),
              onChanged: (String value) {},
              isExpanded: true,
              value: _dropdownValues.first,
            ),
          ),
        ),
      ],
    );
  }

  _buildTextMenuTwoColumn(context, text_1, text_2, width) {
    return Row(
      mainAxisAlignment: MainAxisAlignment.start,
      children: <Widget>[
        _buildTextMenu(context, text_1),
        SizedBox(
          width: mediaQuery(context, "w", width),
        ),
        _buildTextMenu(context, text_2),
      ],
    );
  }

  _buildTextFieldTwoColumnNoIcon(context, TextEditingController controller1,
      TextEditingController controller2) {
    return Row(
      mainAxisAlignment: MainAxisAlignment.spaceEvenly,
      children: <Widget>[
        Container(
          height: mediaQuery(context, 'h', 105),
          width: mediaQuery(context, 'w', 490),
          child: Stack(
            children: <Widget>[
              TextField(
                controller: controller1,
                enabled: true,
                decoration: new InputDecoration(
//                                  prefixIcon: Icon(Icons.search),
                    border: new OutlineInputBorder(
                      borderRadius: const BorderRadius.all(
                        const Radius.circular(50.0),
                      ),
                    ),
                    filled: true,
                    hintStyle: new TextStyle(color: Colors.grey[800]),
                    counterText: "",
                    contentPadding: EdgeInsets.fromLTRB(15.0, 0.0, 20.0, 10.0),
                    fillColor: Colors.white70),
              ),
              GestureDetector(
                onTap: () {
                  print("Call calendar");
                },
                child: Container(
                  margin: EdgeInsets.only(
                    top: mediaQuery(context, 'h', 10),
                    left: mediaQuery(context, 'w', 400),
                  ),
                  child: Text("คน"),
                ),
              ),
            ],
          ),
        ),
        Container(
          height: mediaQuery(context, 'h', 105),
          width: mediaQuery(context, 'w', 490),
          child: Stack(
            children: <Widget>[
              TextField(
                controller: controller2,
                enabled: true,
                decoration: new InputDecoration(
//                                  prefixIcon: Icon(Icons.search),
                    border: new OutlineInputBorder(
                      borderRadius: const BorderRadius.all(
                        const Radius.circular(50.0),
                      ),
                    ),
                    filled: true,
                    hintStyle: new TextStyle(color: Colors.grey[800]),
                    counterText: "",
                    contentPadding: EdgeInsets.fromLTRB(15.0, 0.0, 20.0, 10.0),
                    fillColor: Colors.white70),
              ),
              GestureDetector(
                onTap: () {
                  print("Call calendar");
                },
                child: Container(
                  margin: EdgeInsets.only(
                    top: mediaQuery(context, 'h', 10),
                    left: mediaQuery(context, 'w', 400),
                  ),
                  child: Text("คน"),
                ),
              ),
            ],
          ),
        ),
      ],
    );
  }

  _buildTextFieldTwoColumn(context, TextEditingController controller1,
      TextEditingController controller2) {
    return Row(
      mainAxisAlignment: MainAxisAlignment.spaceEvenly,
      children: <Widget>[
        Container(
          height: mediaQuery(context, 'h', 105),
          width: mediaQuery(context, 'w', 490),
          child: Stack(
            children: <Widget>[
              TextField(
                controller: controller1,
                enabled: true,
                decoration: new InputDecoration(
//                                  prefixIcon: Icon(Icons.search),
                    border: new OutlineInputBorder(
                      borderRadius: const BorderRadius.all(
                        const Radius.circular(50.0),
                      ),
                    ),
                    filled: true,
                    hintStyle: new TextStyle(color: Colors.grey[800]),
                    counterText: "",
                    contentPadding: EdgeInsets.fromLTRB(15.0, 0.0, 20.0, 10.0),
                    fillColor: Colors.white70),
              ),
              GestureDetector(
                onTap: () {
                  print("Call calendar");
                },
                child: Container(
                  margin: EdgeInsets.only(
                    top: mediaQuery(context, 'h', 10),
                    left: mediaQuery(context, 'w', 400),
                  ),
                  child: Icon(
                    Icons.calendar_today,
                    color: Colors.grey,
                  ),
                ),
              ),
            ],
          ),
        ),
        Container(
          height: mediaQuery(context, 'h', 105),
          width: mediaQuery(context, 'w', 490),
          child: Stack(
            children: <Widget>[
              TextField(
                controller: controller2,
                enabled: true,
                decoration: new InputDecoration(
//                                  prefixIcon: Icon(Icons.search),
                    border: new OutlineInputBorder(
                      borderRadius: const BorderRadius.all(
                        const Radius.circular(50.0),
                      ),
                    ),
                    filled: true,
                    hintStyle: new TextStyle(color: Colors.grey[800]),
                    counterText: "",
                    contentPadding: EdgeInsets.fromLTRB(15.0, 0.0, 20.0, 10.0),
                    fillColor: Colors.white70),
              ),
              GestureDetector(
                onTap: () {
                  print("Call Time");
                },
                child: Container(
                  margin: EdgeInsets.only(
                    top: mediaQuery(context, 'h', 10),
                    left: mediaQuery(context, 'w', 400),
                  ),
                  child: Icon(
                    Icons.expand_more,
                    color: Colors.grey,
                  ),
                ),
              ),
            ],
          ),
        ),
      ],
    );
  }

  _buildRow(context, TextEditingController controller) {
    return Container(
      height: mediaQuery(context, 'h', 110),
      width: mediaQuery(context, 'w', 1005),
      child: new TextField(
        controller: controller,
        enabled: true,
        decoration: new InputDecoration(
            border: new OutlineInputBorder(
              borderRadius: const BorderRadius.all(
                const Radius.circular(50.0),
              ),
            ),
            filled: true,
            counterText: "",
            contentPadding: EdgeInsets.fromLTRB(10.0, 0.0, 20.0, 10.0),
            hintStyle: new TextStyle(color: Colors.grey[800]),
            fillColor: Colors.white70),
      ),
    );
  }

  _buildSizeBox(context) {
    return SizedBox(
      height: mediaQuery(context, "h", 15),
    );
  }

  _buildTextMenu(context, text) {
    return Row(
      mainAxisAlignment: MainAxisAlignment.start,
      children: <Widget>[
        Text(
          text,
          style: TextStyle(
              fontSize: mediaQuery(context, 'h', 30), color: AppColors.Black),
          textAlign: TextAlign.center,
        ),
      ],
    );
  }
} //class
