import 'dart:async';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:mwf_app/service/color.dart';
import 'package:mwf_app/service/header.dart';
import 'package:mwf_app/service/loader.dart';
import 'package:mwf_app/service/screen.dart';
import 'package:mwf_app/service/url.dart';
import 'package:mwf_app/model/ResearchAnswer_model.dart';
import 'package:webview_flutter/webview_flutter.dart';
// import 'package:flutter_webview_plugin/src/javascript_channel.dart';
// import 'package:flutter_webview_plugin/src/javascript_message.dart';

class AnswerQuestionWebView extends StatefulWidget {
  final RQId, RQCode, RQName;
  AnswerQuestionWebView(this.RQId, this.RQCode, this.RQName);

  @override
  _AnswerQuestionWebViewState createState() =>
      _AnswerQuestionWebViewState(this.RQId, this.RQCode, this.RQName);
}

class _AnswerQuestionWebViewState extends State<AnswerQuestionWebView> {
  final Completer<WebViewController> _webviewController =
      Completer<WebViewController>();
  String _rqId = "";

  var RQId, RQCode, RQName;
  var urlMain = AppUrl.Questionnaire_AnswerForm +
      "?id={id}&" +
      "customerId={customerId}" +
      "&username={username}"+
      "&authenKey="+AppUrl.AuthenKey;

  _AnswerQuestionWebViewState(this.RQId, this.RQCode, this.RQName);

  @override
  void initState() {
    super.initState();
  }

  @override
  void dispose() {
    super.dispose();
  }

  JavascriptChannel _saveFinnishJavascriptChannel(BuildContext context) {
    print('_saveFinnishJavascriptChannel');
    return new JavascriptChannel(
        name: 'saveFinnish',
        onMessageReceived: (message) {
          Navigator.pop(context);
        });
  }

  _bulidWebView3() {
    setState(() {
      urlMain = Uri.encodeFull(urlMain
          .replaceAll("{id}", RQId)
          .replaceAll("{customerId}", AppUrl.CustomerID)
          .replaceAll("{username}", AppUrl.userName));
    });

    print(urlMain);

    return Container(
      width: MediaQuery.of(context).size.width,
      height: MediaQuery.of(context).size.height - 175,
      margin: EdgeInsets.only(
        top: mediaQuery(context, 'h', 338),
        // left: mediaQuery(context, 'w', 0),
        // right: mediaQuery(context, 'w', 0),
      ),
      child: WebView(
        initialUrl: urlMain,
        javascriptMode: JavascriptMode.unrestricted,
        javascriptChannels: <JavascriptChannel>[
          _saveFinnishJavascriptChannel(context),
        ].toSet(),
        onWebViewCreated: (WebViewController webViewController) {
          _webviewController.complete(webViewController);
        },
        onPageStarted: (url) {
          if (url.contains(new RegExp(r'MobileSuccess', caseSensitive: true))) {
            Navigator.of(context).pop(true);
          } else if (url
              .contains(new RegExp(r'MobileFailed', caseSensitive: true))) {
            AppLoader.showError('บันทึกไม่สำเร็จ');
          }
        },
      ),
    );
  }

  @override
  Widget build(BuildContext context) {
    double _width = MediaQuery.of(context).size.width;
    double _height = MediaQuery.of(context).size.height;

    // _bulidFlutterWebViewPlugin(urlMain);

    return Material(
      color: AppColors.bgColor,
      child: Stack(
        children: <Widget>[
          Header.mainMenu(context),
          _bulidWebView3(),
          Header.header2(context),
        ],
      ),
    );
  }
}

class AnswerListSend {
  List<AnswerList> listanswer;
  AnswerListSend({this.listanswer});
  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    this.listanswer.map((v) => v.toJson()).toList();
    return data;
  }
}
