import 'dart:async';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:mwf_app/service/color.dart';
import 'package:mwf_app/service/header.dart';
import 'package:mwf_app/service/loader.dart';
import 'package:mwf_app/service/screen.dart';
import 'package:mwf_app/service/url.dart';
import 'package:webview_flutter/webview_flutter.dart';

class SaveSurveyWebView extends StatefulWidget {
  final String sQId;
  final String sRcqId;
  SaveSurveyWebView(this.sQId, this.sRcqId);
  @override
  _SaveSurveyWebViewState createState() =>
      _SaveSurveyWebViewState(this.sQId, this.sRcqId);
}

class _SaveSurveyWebViewState extends State<SaveSurveyWebView> {
  bool isLoading = false;
  String sQId = '';
  String sRcqId = '';
  String id;
  String name;
  final Completer<WebViewController> _webviewController =
      Completer<WebViewController>();

  var urlMain = AppUrl.Survey_AnswerForm +
      "?id={id}&" +
      "customerId={customerId}" +
      "&username={username}" +
      "&srcqId={sRcqId}"+
      "&authenKey="+AppUrl.AuthenKey;



  _SaveSurveyWebViewState(this.sQId, this.sRcqId);

  JavascriptChannel _saveFinnishJavascriptChannel(BuildContext context) {
    return new JavascriptChannel(
        name: 'saveFinnish',
        onMessageReceived: (message) {
          Navigator.pop(context);
        });
  }

  _bulidWebView() {
    setState(() {
      isLoading = true;
    });
    setState(() {
      urlMain = Uri.encodeFull(urlMain
          .replaceAll("{id}", this.sQId)
          .replaceAll("{customerId}", AppUrl.CustomerID)
          .replaceAll("{username}", AppUrl.userName)
          .replaceAll("{sRcqId}", this.sRcqId));
    });

    print(urlMain);
    setState(() {
      isLoading = false;
    });
    return Container(
      width: MediaQuery.of(context).size.width,
      height: MediaQuery.of(context).size.height - 175,
      margin: EdgeInsets.only(
        top: mediaQuery(context, 'h', 338),
        // left: mediaQuery(context, 'w', 0),
        // right: mediaQuery(context, 'w', 0),
      ),
      child: WebView(
        initialUrl: urlMain,
        javascriptMode: JavascriptMode.unrestricted,
        javascriptChannels: <JavascriptChannel>[
          _saveFinnishJavascriptChannel(context),
        ].toSet(),
        onWebViewCreated: (WebViewController webViewController) {
          _webviewController.complete(webViewController);
        },
        onPageStarted: (url) {
          if (url.contains(new RegExp(r'MobileSuccess', caseSensitive: true))) {
            Navigator.of(context).pop(true);
          } else if (url
              .contains(new RegExp(r'MobileFailed', caseSensitive: true))) {
            AppLoader.showError('บันทึกไม่สำเร็จ');
          }
        },
      ),
    );
  }

  @override
  Widget build(BuildContext context) {
    if (isLoading == true) {
      AppLoader.show();
    }
    if (isLoading == false) {
      AppLoader.hide();
    }
    double _width = MediaQuery.of(context).size.width;
    double _height = MediaQuery.of(context).size.height;

    return Material(
      color: AppColors.bgColor,
      child: Stack(
        children: <Widget>[
          Header.mainMenu(context),
          _bulidWebView(),
          Header.header1(context),
        ],
      ),
    );
  }
} //class
