import 'dart:async';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:grouped_buttons/grouped_buttons.dart';
import 'package:intl/intl.dart';
import 'package:mwf_app/service/alert.dart';
import 'package:mwf_app/service/color.dart';
import 'package:mwf_app/service/header.dart';
import 'package:mwf_app/service/screen.dart';
import 'package:mwf_app/service/shadow.dart';
import 'package:mwf_app/service/strings.dart';
import 'package:mwf_app/service/style.dart';
import 'package:mwf_app/service/url.dart';
import 'package:mwf_app/model/Survey_model.dart';
import 'package:buddhist_datetime_dateformat/buddhist_datetime_dateformat.dart';
import 'package:need_resume/need_resume.dart';
import 'package:webview_flutter/webview_flutter.dart';

class SaveSurvey extends StatefulWidget {
  final String sQId;
  SaveSurvey(this.sQId);
  @override
  _SaveSurveyState createState() => _SaveSurveyState(this.sQId);
}

var powerSystem = "";
var lineType = "";
var lineSize = "";
var transformMVA = "";
var transformMVAAmount = "";
var transformKVA = "";
var transformKVAAmount = "";
var switchCut = "";

TextEditingController modelNumber = TextEditingController();
TextEditingController watt = TextEditingController(); // กำลังไฟฟ้า วัตต์
TextEditingController manufacturingCompany =
    TextEditingController(); // บริษัทผู้ผลิต
TextEditingController serialNumber = TextEditingController(); // serial number
TextEditingController latestMaintenanceDate =
    TextEditingController(); // วันที่บำรุงรักษาล่าสุด
TextEditingController wattMaintenance =
    TextEditingController(); //  กำลังไฟฟ้า วัตต์ ข้อมูลการบำรุงรักษา

int _radioValue = 0;

String id;
String name;
String voltageSize; //ขนาดแรงดัน
String startDate; //วันที่เริ่มต้น
String endDate; //วันที่สิ้นสุด
String transformerType = ""; // ประเภทหม้อแปลง

bool underMaintenance; // อยู่ระหว่างบำรุงรักษา
bool monVal = false;

final List<String> _dropdownTransformType = []; // ประเภทหม้อแปลงList

class _SaveSurveyState extends ResumableState<SaveSurvey> {
  final _key = UniqueKey();
  final Completer<WebViewController> _webviewController =
      Completer<WebViewController>();
  //  List<dynamic> surveyList = Survey.surveyList; // รายการแบบสำรวจ

  var urlMain = AppUrl.Survey_AnswerForm +
      "?id={id}&" +
      "customerId={customerId}" +
      "&username={username}";
  _SaveSurveyState(this.sQId);
  String sQId = '';

  @override
  void onReady() {
    // Implement your code inside here
    loadData();
    print('Screen is ready!');
    print('หน้าเพิ่มรายการใหม่ set5/save_survey.dart');
    print(sQId);
  }

  @override
  void onResume() {
    // Implement your code inside here
    loadData();
    print('Screen is resumed!');
  }

  @override
  void onPause() {
    // Implement your code inside here
    print('Screen is paused!');
  }

  loadData() async {
    try {
      final list = await Survey.getDataBySQIDForm(
          this.sQId); // ไปเรียกฟังชั่นดึงข้อมูลจาก api
      setState(() {
        Survey.data.clear();
        SurveyQuestion.dataListForm.clear();
        final listSurveyQuestion = list["SurveyQuestion"];
        //      listSurveyQuestion.forEach((v) {
        final surveyList = Survey.fromJson(listSurveyQuestion);
        Survey.data.add(surveyList); // loop เก็บข้อมูล
        //      });
        final listQuestionType = list["QuestionDetail"];
        listQuestionType.forEach((vv) {
          final SurveyQuestionList = SurveyQuestion.fromJson(vv);
          SurveyQuestion.dataListForm.add(SurveyQuestionList);
          final listSurveyQuestionChoice = vv["SurveyQuestionChoice"];
          listSurveyQuestionChoice.forEach((vvv) {
            final SurveyQuestionChoiceList = SurveyQuestionChoice.fromJson(vvv);
            SurveyQuestionChoice.dataListForm
                .add(SurveyQuestionChoiceList); // loop เก็บข้อมูล
          });
        });
      });
    } catch (e) {
      print(e);
    }
  }

  JavascriptChannel _saveFinnishJavascriptChannel(BuildContext context) {
    return new JavascriptChannel(
        name: 'saveFinnish',
        onMessageReceived: (message) {
          Navigator.pop(context);
        });
  }

  @override
  Widget build(BuildContext context) {
    double _width = MediaQuery.of(context).size.width;
    double _height = MediaQuery.of(context).size.height;

    return Material(
      color: AppColors.bgColor,
      child: Stack(
        children: <Widget>[
          Header.header1(context),
          Header.mainMenu(context),
          // Container(
          //   margin: EdgeInsets.only(
          //     top: mediaQuery(context, 'h', 950),
          //   ),
          //   child: Row(
          //     mainAxisAlignment: MainAxisAlignment.center,
          //     children: <Widget>[
          //       Text(
          //         "แบบสำรวจ",
          //         style: AppStyle.headTextStyle(context),
          //       )
          //     ],
          //   ),
          // ),
          Container(
//            color: Colors.teal,
            width: _width,
            height: mediaQuery(context, 'h', 1100),
            margin: EdgeInsets.only(
              top: mediaQuery(context, 'h', 1050),
              left: mediaQuery(context, 'w', 0),
              right: mediaQuery(context, 'w', 0),
            ),
            child: Column(
              children: [
                // _buildRow(context, Survey.data[0].sQCode.toString(), Survey.data[0].sQName.toString()),
                // SizedBox(
                //   height: mediaQuery(context, "h", 50),
                // ),

                Row(
                  mainAxisAlignment: MainAxisAlignment.center,
                  children: [
                    Container(
                      width: _width,
                      height: mediaQuery(context, 'h', 900),
                      margin: EdgeInsets.only(
                        left: mediaQuery(context, 'w', 0),
                        right: mediaQuery(context, 'w', 0),
                      ),
                      child: WebView(
                        initialUrl:
                            _buildWebViewUrl(this.sQId, AppUrl.CustomerID),
                        javascriptMode: JavascriptMode.unrestricted,
                        javascriptChannels: <JavascriptChannel>[
                          _saveFinnishJavascriptChannel(context),
                        ].toSet(),
                        onWebViewCreated:
                            (WebViewController webViewController) {
                          _webviewController.complete(webViewController);
                        },
                      ),
                    )
                  ],
                ),

                _buildSizeBox(context),

                Row(
                  mainAxisAlignment: MainAxisAlignment.center,
                  children: <Widget>[
                    _buildButton(
                        context, "ยกเลิก", Colors.white, AppColors.color),
                    // _buildButton(context, "ส่ง", AppColors.color, Colors.white),
                  ],
                ),
              ],
            ),
          ),
        ],
      ),
    );
  }

  _buildWebViewUrl(String id, String customerId) {
    print("id : " + id);
    print("customerId : " + customerId);

    setState(() {
      urlMain = Uri.encodeFull(urlMain
          .replaceAll("{id}", id)
          .replaceAll("{customerId}", AppUrl.CustomerID)
          .replaceAll("{username}", AppUrl.userName));
    });
    return urlMain;
  }

  _buildButton(context, text, bgColor, fontColor) {
    return ButtonTheme(
      minWidth: mediaQuery(context, 'w', 1005),
      height: mediaQuery(context, "h", 120),
      child: FlatButton(
        shape: new RoundedRectangleBorder(
            borderRadius: new BorderRadius.circular(
              mediaQuery(context, "w", 50),
            ),
            side: BorderSide(color: AppColors.color)),
        color: bgColor,
        textColor: Colors.red,
        padding: EdgeInsets.all(
          mediaQuery(context, "w", 10),
        ),
        onPressed: () {
          if (text == "บันทึก") {
            saveVoice(context);
          } else {
            Navigator.of(context).pop(false);
          }
          print(text);
        },
        child: Text(
          text,
          style: TextStyle(
            fontSize: 14.0,
            color: fontColor,
          ),
        ),
      ),
    );
  }

  buildRowQuestion(context, index, name_question) {
    return Column(
      mainAxisAlignment: MainAxisAlignment.center,
      children: <Widget>[
        _buildTextMenu(context, name_question),
        _buildSizeBox(context),
        _buildSizeBox(context),
      ],
    );
  }

  _buildRedio(context, TextEditingController controller, index) {
    return RadioButtonGroup(labels: <String>[
      "Option 1",
      "Option 2",
    ], onSelected: (String selected) => print(selected));
  }

  _buildCheckBox(context, TextEditingController controller, index) {
    return Row(
      children: <Widget>[
        Checkbox(
          value: monVal,
          onChanged: (bool value) {
            setState(() {
              monVal = value;
              underMaintenance = value;
            });
            print("underMaintenance = $underMaintenance");
          },
        ),
        // Text(SurveyQuestionChoice.dataListForm[index].SQC_Name),
      ],
    );
  }

  _buildTextArea(context, TextEditingController controller, index) {
    controller.text = SurveyQuestionChoice.dataListForm[index].SQC_Ans;
    return Container(
      color: Colors.white,
      child: TextField(
        controller: controller,
        onChanged: (text) {
          print("First text field: $text");
          if (SurveyQuestionChoice.dataListForm[index].SQC_Ans != "") {
            SurveyQuestionChoice.dataListForm[index].SQC_Ans = text;
          }
        },
        maxLines: 5,
        decoration: InputDecoration(
          fillColor: Colors.white70,
          border: new OutlineInputBorder(
            borderRadius: const BorderRadius.all(
              const Radius.circular(10.0),
            ),
          ),
          hintText: "",
          labelText: '',
        ),
      ),
    );
  }

  _buildTextFieldDateTime(
      context, TextEditingController date, TextEditingController time, index) {
    DateTime strDate = DateTime.now().toUtc();
    if (SurveyQuestionChoice.dataListForm[index].SQC_Ans != null) {
      if (SurveyQuestionChoice.dataListForm[index].SQC_Ans.split(" ").length !=
          0) {
        if (SurveyQuestionChoice.dataListForm[index].SQC_Ans
                .split(" ")
                .length ==
            1) {
          date.text =
              SurveyQuestionChoice.dataListForm[index].SQC_Ans.split(" ")[0];
          var formatter = DateFormat.yMd();
          var showDate = formatter.formatInBuddhistCalendarThai(strDate);
          date.text = showDate.toString();
        } else if (SurveyQuestionChoice.dataListForm[index].SQC_Ans
                .split(" ")
                .length ==
            2) {
          date.text =
              SurveyQuestionChoice.dataListForm[index].SQC_Ans.split(" ")[0];
          time.text =
              SurveyQuestionChoice.dataListForm[index].SQC_Ans.split(" ")[1];
        }
      }
    }
    return Row(
      mainAxisAlignment: MainAxisAlignment.spaceBetween,
      children: <Widget>[
        Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: <Widget>[
            Text(
              'วันที่ :',
              style: TextStyle(
                  fontSize: mediaQuery(context, 'h', 40),
                  color: AppColors.Black),
              textAlign: TextAlign.center,
            ),
            Container(
              height: mediaQuery(context, 'h', 105),
              width: mediaQuery(context, 'w', 490),
              child: GestureDetector(
                onTap: () async {
                  DateTime newDate = await showDatePicker(
                    context: context,
                    initialDate: DateTime.now(),
                    firstDate: DateTime(DateTime.now().year),
                    lastDate: DateTime(DateTime.now().year, 12, 31),
//                      locale: Locale("th", "TH"),
                    builder: (context, child) {
                      return Theme(
                        data: Theme.of(context).copyWith(
                          primaryColor: AppColors.color,
                          accentColor: AppColors.color_gold,
                          colorScheme: ColorScheme.light(
                            primary: AppColors.color,
                          ),
                          buttonTheme: ButtonThemeData(
                            textTheme: ButtonTextTheme.primary,
                          ),
                        ),
                        child: Container(
                          height: 450,
                          width: 700,
                          child: child,
                        ),
                      );
                    },
                  );
                  if (newDate != null) {
                    var dtArray = newDate.toString().split(" ");
                    setState(() {
                      var formatter = DateFormat.yMd();
                      var showDate =
                          formatter.formatInBuddhistCalendarThai(newDate);
                      date.text = showDate;
                      strDate = newDate;
                      SurveyQuestionChoice.dataListForm[index].SQC_Ans =
                          dtArray[0];
//                      DateCreate =dtArray[0];
                    });
                  }
                },
                child: Container(
                  height: mediaQuery(context, 'h', 105),
                  width: mediaQuery(context, 'w', 490),
                  padding: EdgeInsets.only(
                    left: mediaQuery(context, 'h', 20),
                    right: mediaQuery(context, 'h', 20),
                  ),
                  decoration: BoxDecoration(
                    borderRadius: new BorderRadius.all(
                      Radius.circular(
                        mediaQuery(
                          context,
                          'h',
                          150,
                        ),
                      ),
                    ),
                    border: Border.all(
                      color: Colors.grey[500],
                    ),
                    color: Colors.white,
                  ),
                  child: Row(
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    children: <Widget>[
                      Text(date.text),
                      Icon(
                        Icons.calendar_today,
                        color: Colors.grey,
                        size: mediaQuery(
                          context,
                          'h',
                          80,
                        ),
                      ),
                    ],
                  ),
                ),
              ),
            ),
          ],
        ),
        Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: <Widget>[
            Text(
              'เวลา :',
              style: TextStyle(
                  fontSize: mediaQuery(context, 'h', 40),
                  color: AppColors.Black),
              textAlign: TextAlign.center,
            ),
            Container(
              height: mediaQuery(context, 'h', 105),
              width: mediaQuery(context, 'w', 490),
              child: GestureDetector(
                onTap: () async {
                  TimeOfDay newTime = await showTimePicker(
                    context: context,
                    initialTime: TimeOfDay.now(),
                    builder: (context, child) {
                      return Theme(
                        data: Theme.of(context).copyWith(
                          primaryColor: AppColors.color,
                          accentColor: AppColors.color_gold,
                          colorScheme: ColorScheme.light(
                            primary: AppColors.color,
                          ),
                          buttonTheme: ButtonThemeData(
                            textTheme: ButtonTextTheme.primary,
                          ),
                        ),
                        child: Container(
                          height: 450,
                          width: 700,
                          child: child,
                        ),
                      );
                    },
                  );
                  if (newTime != null) {
                    String timeStr = newTime.hour.toString() +
                        ":" +
                        newTime.minute.toString();
                    setState(() {
                      time.text = timeStr;
                      SurveyQuestionChoice.dataListForm[index].SQC_Ans +=
                          " " + timeStr;
                    });
                  }
                },
                child: Container(
                  height: mediaQuery(context, 'h', 105),
                  width: mediaQuery(context, 'w', 490),
                  padding: EdgeInsets.only(
                    left: mediaQuery(context, 'h', 20),
                    right: mediaQuery(context, 'h', 20),
                  ),
                  decoration: BoxDecoration(
                    borderRadius: new BorderRadius.all(
                      Radius.circular(
                        mediaQuery(
                          context,
                          'h',
                          150,
                        ),
                      ),
                    ),
                    border: Border.all(
                      color: Colors.grey[500],
                    ),
                    color: Colors.white,
                  ),
                  child: Row(
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    children: <Widget>[
                      Text(time.text),
                      Icon(
                        Icons.access_time,
                        color: Colors.grey,
                        size: mediaQuery(
                          context,
                          'h',
                          80,
                        ),
                      ),
                    ],
                  ),
                ),
              ),
            ),
          ],
        ),
      ],
    );
  }

  _buildTextFieldDate(context, TextEditingController date, index) {
    date.text = SurveyQuestionChoice.dataListForm[index].SQC_Ans;
    return Container(
      height: mediaQuery(context, 'h', 110),
      width: mediaQuery(context, 'w', 1005),
      child: GestureDetector(
        onTap: () async {
          DateTime newDate = await showDatePicker(
            context: context,
            initialDate: DateTime.now(),
            firstDate: DateTime(DateTime.now().year),
            lastDate: DateTime(DateTime.now().year, 12, 31),
            builder: (context, child) {
              return Theme(
                data: Theme.of(context).copyWith(
                  primaryColor: AppColors.color,
                  accentColor: AppColors.color_gold,
                  colorScheme: ColorScheme.light(
                    primary: AppColors.color,
                  ),
                  buttonTheme: ButtonThemeData(
                    textTheme: ButtonTextTheme.primary,
                  ),
                ),
                child: Container(
                  height: 450,
                  width: 700,
                  child: child,
                ),
              );
            },
          );
          if (newDate != null) {
            var dtArray = newDate.toString().split(" ");
            setState(() {
              var formatter = DateFormat.yMd();
              var showDate = formatter.formatInBuddhistCalendarThai(newDate);
              date.text = showDate;
              if (SurveyQuestionChoice.dataListForm[index].SQC_Ans != "") {
                SurveyQuestionChoice.dataListForm[index].SQC_Ans = dtArray[0];
              }
            });
          }
        },
        child: Container(
          height: mediaQuery(context, 'h', 105),
          width: mediaQuery(context, 'w', 490),
          padding: EdgeInsets.only(
            left: mediaQuery(context, 'h', 20),
            right: mediaQuery(context, 'h', 20),
          ),
          decoration: BoxDecoration(
            borderRadius: new BorderRadius.all(
              Radius.circular(
                mediaQuery(
                  context,
                  'h',
                  150,
                ),
              ),
            ),
            border: Border.all(
              color: Colors.grey[500],
            ),
            color: Colors.white,
          ),
          child: Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: <Widget>[
              Text(date.text),
              Icon(
                Icons.calendar_today,
                color: Colors.grey,
                size: mediaQuery(
                  context,
                  'h',
                  80,
                ),
              ),
            ],
          ),
        ),
      ),
    );
  }

  _buildTextFieldString(context, TextEditingController controller, index) {
    controller.text = SurveyQuestionChoice.dataListForm[index].SQC_Ans;
    return Container(
      height: mediaQuery(context, 'h', 110),
      width: mediaQuery(context, 'w', 1005),
      child: new TextField(
        controller: controller,
        onChanged: (text) {
          print("First text field: $text");
          if (SurveyQuestionChoice.dataListForm[index].SQC_Ans != "") {
            SurveyQuestionChoice.dataListForm[index].SQC_Ans = text;
          }
        },
        enabled: true,
        decoration: new InputDecoration(
            border: new OutlineInputBorder(
              borderRadius: const BorderRadius.all(
                const Radius.circular(50.0),
              ),
            ),
            filled: true,
            counterText: "",
            contentPadding: EdgeInsets.fromLTRB(10.0, 0.0, 20.0, 10.0),
            hintStyle: new TextStyle(color: Colors.grey[800]),
            fillColor: Colors.white70),
      ),
    );
  }

  _buildTextFieldNumber(context, TextEditingController controller, index) {
    controller.text = SurveyQuestionChoice.dataListForm[index].SQC_Ans;
    return Container(
      height: mediaQuery(context, 'h', 110),
      width: mediaQuery(context, 'w', 1005),
      child: new TextField(
        keyboardType: TextInputType.numberWithOptions(signed: true),
        controller: controller,
        onChanged: (text) {
          print("First text field: $text");
          if (SurveyQuestionChoice.dataListForm[index].SQC_Ans != "") {
            SurveyQuestionChoice.dataListForm[index].SQC_Ans = text;
          }
        },
        enabled: true,
        decoration: new InputDecoration(
            border: new OutlineInputBorder(
              borderRadius: const BorderRadius.all(
                const Radius.circular(50.0),
              ),
            ),
            filled: true,
            counterText: "",
            contentPadding: EdgeInsets.fromLTRB(10.0, 0.0, 20.0, 10.0),
            hintStyle: new TextStyle(color: Colors.grey[800]),
            fillColor: Colors.white70),
      ),
    );
  }

  _buildTextFieldDecimal(context, TextEditingController controller, index) {
    controller.text = SurveyQuestionChoice.dataListForm[index].SQC_Ans;
    return Container(
      height: mediaQuery(context, 'h', 110),
      width: mediaQuery(context, 'w', 1005),
      child: new TextField(
        keyboardType: TextInputType.numberWithOptions(decimal: true),
        controller: controller,
        onChanged: (text) {
          print("First text field: $text");
          if (SurveyQuestionChoice.dataListForm[index].SQC_Ans != "") {
            SurveyQuestionChoice.dataListForm[index].SQC_Ans = text;
          }
        },
        enabled: true,
        decoration: new InputDecoration(
            border: new OutlineInputBorder(
              borderRadius: const BorderRadius.all(
                const Radius.circular(50.0),
              ),
            ),
            filled: true,
            counterText: "",
            contentPadding: EdgeInsets.fromLTRB(10.0, 0.0, 20.0, 10.0),
            hintStyle: new TextStyle(color: Colors.grey[800]),
            fillColor: Colors.white70),
      ),
    );
  }

  _buildRadio(context, text, int value) {
//    double _width = MediaQuery.of(context).size.width;
    return SizedBox(
//      width: _width,
      height: 30,
      child: Row(
        children: <Widget>[
          new Radio(
            value: value,
            groupValue: _radioValue,
            onChanged: _handleRadioValueChange,
          ),
          Text(text)
        ],
      ),
    );
  }

  void _handleRadioValueChange(int value) {
    setState(() {
      _radioValue = value;
      voltageSize = _radioValue.toString() + " KV";
    });
    print(voltageSize);
  }

  _buildRowTextFieldIcon(context, controller) {
    return Row(
      mainAxisAlignment: MainAxisAlignment.spaceEvenly,
      children: <Widget>[
        Container(
          height: mediaQuery(context, 'h', 105),
          width: mediaQuery(context, 'w', 790),
          child: GestureDetector(
            onTap: () async {
              DateTime newDate = await showDatePicker(
                context: context,
                initialDate: DateTime.now(),
                firstDate: DateTime(DateTime.now().year),
                lastDate: DateTime(DateTime.now().year, 12, 31),
//                      locale: Locale("th", "TH"),
                builder: (context, child) {
                  return Theme(
                    data: Theme.of(context).copyWith(
                      primaryColor: AppColors.color,
                      accentColor: AppColors.color_gold,
                      colorScheme: ColorScheme.light(
                        primary: AppColors.color,
                      ),
                      buttonTheme: ButtonThemeData(
                        textTheme: ButtonTextTheme.primary,
                      ),
                    ),
                    child: Container(
                      height: 450,
                      width: 700,
                      child: child,
                    ),
                  );
                },
              );
              if (newDate != null) {
                var dtArray = newDate.toString().split(" ");
                setState(() {
                  var formatter = DateFormat.yMd();
                  var showDate =
                      formatter.formatInBuddhistCalendarThai(newDate);
                  controller.text = showDate;
//                  strcontroller =dtArray[0];
                });
              }
            },
            child: Container(
              height: mediaQuery(context, 'h', 105),
              width: mediaQuery(context, 'w', 490),
              padding: EdgeInsets.only(
                left: mediaQuery(context, 'h', 20),
                right: mediaQuery(context, 'h', 20),
              ),
              decoration: BoxDecoration(
                borderRadius: new BorderRadius.all(
                  Radius.circular(
                    mediaQuery(
                      context,
                      'h',
                      150,
                    ),
                  ),
                ),
                border: Border.all(
                  color: Colors.grey[500],
                ),
                color: Colors.white,
              ),
              child: Row(
                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                children: <Widget>[
                  Text(controller.text),
                  Icon(
                    Icons.calendar_today,
                    color: Colors.grey,
                    size: mediaQuery(
                      context,
                      'h',
                      80,
                    ),
                  ),
                ],
              ),
            ),
          ),
        ),
//        Container(
//          height: mediaQuery(context, 'h', 105),
//          width: mediaQuery(context, 'w', 790),
//          child: Stack(
//            children: <Widget>[
//              TextField(
//                enabled: true,
//                controller: controller,
//                decoration: new InputDecoration(
////                                  prefixIcon: Icon(Icons.search),
//                    border: new OutlineInputBorder(
//                      borderRadius: const BorderRadius.all(
//                        const Radius.circular(50.0),
//                      ),
//                    ),
//                    filled: true,
//                    hintStyle: new TextStyle(color: Colors.grey[800]),
//                    counterText: "",
//                    contentPadding: EdgeInsets.fromLTRB(15.0, 0.0, 20.0, 10.0),
//                    fillColor: Colors.white70),
//              ),
//              GestureDetector(
//                onTap: () {
//                  print("Call calendar");
//                },
//                child: Container(
//                  margin: EdgeInsets.only(
//                    top: mediaQuery(context, 'h', 10),
//                    left: mediaQuery(context, 'w', 700),
//                  ),
//                  child: Icon(
//                    Icons.calendar_today,
//                    color: Colors.grey,
//                  ),
//                ),
//              ),
//            ],
//          ),
//        ),
      ],
    );
  }

  _buildRowNumberSR(context, TextEditingController controller) {
    return Container(
      height: mediaQuery(context, 'h', 110),
      width: mediaQuery(context, 'w', 1005),
      child: new TextField(
        keyboardType: TextInputType.number,
        controller: controller,
        enabled: true,
        decoration: new InputDecoration(
            border: new OutlineInputBorder(
              borderRadius: const BorderRadius.all(
                const Radius.circular(50.0),
              ),
            ),
            filled: true,
            counterText: "",
            contentPadding: EdgeInsets.fromLTRB(10.0, 0.0, 20.0, 10.0),
            hintStyle: new TextStyle(color: Colors.grey[800]),
            fillColor: Colors.white70),
      ),
    );
  }

  _buildRowNumber(context, TextEditingController controller) {
    return Container(
      height: mediaQuery(context, 'h', 110),
      width: mediaQuery(context, 'w', 790),
      child: new TextField(
        keyboardType: TextInputType.number,
        controller: controller,
        enabled: true,
        decoration: new InputDecoration(
            border: new OutlineInputBorder(
              borderRadius: const BorderRadius.all(
                const Radius.circular(50.0),
              ),
            ),
            filled: true,
            counterText: "",
            contentPadding: EdgeInsets.fromLTRB(10.0, 0.0, 20.0, 10.0),
            hintStyle: new TextStyle(color: Colors.grey[800]),
            fillColor: Colors.white70),
      ),
    );
  }

  _buildRowTextField(context, TextEditingController controller) {
    return Container(
      height: mediaQuery(context, 'h', 110),
      width: mediaQuery(context, 'w', 790),
      child: new TextField(
        controller: controller,
        enabled: true,
        decoration: new InputDecoration(
            border: new OutlineInputBorder(
              borderRadius: const BorderRadius.all(
                const Radius.circular(50.0),
              ),
            ),
            filled: true,
            counterText: "",
            contentPadding: EdgeInsets.fromLTRB(10.0, 0.0, 20.0, 10.0),
            hintStyle: new TextStyle(color: Colors.grey[800]),
            fillColor: Colors.white70),
      ),
    );
  }

  _buildDropDown(context, List<String> _dropdownValues) {
    return Row(
      mainAxisAlignment: MainAxisAlignment.center,
      children: <Widget>[
        Container(
          height: mediaQuery(context, 'h', 110),
          width: mediaQuery(context, 'w', 1005),
          padding: EdgeInsets.symmetric(horizontal: 10.0),
          decoration: BoxDecoration(
            color: Colors.white,
            borderRadius: BorderRadius.circular(53.0),
            border: Border.all(
                color: AppColors.color_border,
                style: BorderStyle.solid,
                width: 0.80),
          ),
          child: DropdownButtonHideUnderline(
            child: DropdownButton(
              style: TextStyle(
                color: AppColors.Black,
                fontSize: mediaQuery(context, "w", 30),
              ),
              items: _dropdownValues
                  .map((value) => DropdownMenuItem(
                        child: Text(value),
                        value: value,
                      ))
                  .toList(),
              onChanged: (String value) {
                setState(() {
                  transformerType = value;
                });
                print(transformerType);
              },
              isExpanded: true,
              value: _dropdownValues.first,
            ),
          ),
        ),
      ],
    );
  }

  _buildTextMenu(context, text) {
    return Row(
      mainAxisAlignment: MainAxisAlignment.start,
      children: <Widget>[
/*        Text(
          text,
          style: TextStyle(
              fontSize: mediaQuery(context, 'h', 46), color: AppColors.Black),
          textAlign: TextAlign.center,
        ),*/
        Flexible(
          child: Text(
            text,
            style: TextStyle(
                fontSize: mediaQuery(context, 'h', 46), color: AppColors.Black),
            textAlign: TextAlign.left,
          ),
        ),
      ],
    );
  }

  _buildLine(context) {
    return Row(
      mainAxisAlignment: MainAxisAlignment.center,
      children: <Widget>[
        Expanded(
          child: new Container(
            padding: EdgeInsets.only(
              left: mediaQuery(context, "w", 10),
              right: mediaQuery(context, "w", 10),
            ),
            child: Divider(
              color: AppColors.color_line,
            ),
          ),
        ),
      ],
    );
  }

  _buildSizeBox(context) {
    return SizedBox(
      height: mediaQuery(context, "h", 15),
    );
  }

  _buildRow(context, String code, String name) {
    return Row(
      mainAxisAlignment: MainAxisAlignment.center,
      children: <Widget>[
        Row(
          mainAxisAlignment: MainAxisAlignment.center,
          children: <Widget>[
            Container(
              width: mediaQuery(context, 'w', 1005),
              height: mediaQuery(context, 'h', 150),
              decoration: BoxDecoration(
                borderRadius: new BorderRadius.all(
                  Radius.circular(
                    mediaQuery(context, 'h', 140),
                  ),
                ),
                boxShadow: [
                  BoxShadow(
                    offset: Offset(2.0, 2.0),
                    blurRadius: 10.0,
                    color: Color(0xFF000000).withOpacity(0.10),
                  ),
                ],
                color: Colors.white,
              ),
              child: Row(
                children: <Widget>[
                  Container(
                    width: mediaQuery(context, 'w', 230),
                    height: mediaQuery(context, 'h', 150),
                    padding: EdgeInsets.all(
                      mediaQuery(context, 'h', 35),
                    ),
                    decoration: BoxDecoration(
                      borderRadius: new BorderRadius.all(
                        Radius.circular(
                          mediaQuery(context, 'h', 70),
                        ),
                      ),
                      boxShadow: [
                        appShadow(),
                      ],
                      color: AppColors.color,
                    ),
                    child: Text(
                      code,
                      textAlign: TextAlign.center,
                      style: TextStyle(
                        fontSize: mediaQuery(context, 'h', 50),
                        color: Colors.white,
                        fontWeight: FontWeight.bold,
                      ),
                    ),
                  ),
                  Container(
//                    color: Colors.red,
                    width: mediaQuery(context, 'h', 800),
                    child: Column(
                      mainAxisAlignment: MainAxisAlignment.center,
                      children: <Widget>[
                        Text(
                          name,
                          textAlign: TextAlign.center,
                          style: TextStyle(
                            fontSize: mediaQuery(context, 'h', 50),
                            color: Color(0xFF383838),
                          ),
                        ),
                      ],
                    ),
                  ),
                ],
              ),
            ),
          ],
        ),
      ],
    );
  }

  saveVoice(context) async {
    if (await checkForm([
      modelNumber.text,
      powerSystem,
      lineType,
      lineSize,
      transformMVA,
      transformMVAAmount,
      transformKVA,
      transformKVAAmount,
      switchCut
    ])) {
      Map data = {
        "modelNumber": modelNumber.text,
        "powerSystem": powerSystem,
        "lineType": lineType,
        "lineSize": lineSize,
        "transformMVA": transformMVA,
        "transformMVAAmount": transformMVAAmount,
        "transformKVA": transformMVAAmount,
        "transformKVAAmount": transformKVA,
        "switchCut": transformKVAAmount,
        "AuthenKey": AppUrl.AuthenKey,
      };

      Survey.saveData(context, data);
    } else {
      alertForm(context, "แจ้งเตือน", "กรอกข้อมูลไม่ครบ");
    }
  }
} //class
