import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:mwf_app/service/color.dart';
import 'package:mwf_app/service/header.dart';
import 'package:mwf_app/service/screen.dart';
import 'package:mwf_app/service/strings.dart';
import 'package:mwf_app/service/style.dart';
import 'package:mwf_app/service/alert.dart';
import 'package:mwf_app/model/visit_plan.dart';
import 'package:mwf_app/set4/service_visit_user.dart';
import 'package:mwf_app/service/navigator.dart';

//VisitPlan_model
class VisitingPlan extends StatefulWidget {
  VisitingPlan(this.visitid, {Key key, this.list, this.detail, this.prob})
      : super(key: key);
  final visitid;
  Map list;
  Map detail;
  Map prob;

  @override
  _VisitingPlanState createState() => _VisitingPlanState(visitid);
}

class KeyValueModel {
  String key;
  String value;

  KeyValueModel({this.key, this.value});
}

bool isLoading = true;

String problemType1;

List<KeyValueModel> _dropdownProb = [
  KeyValueModel(key: "เลือก", value: ""),
];

class _VisitingPlanState extends State<VisitingPlan> {
  String visitid;
  _VisitingPlanState(this.visitid);
  @override
  void initState() {
    super.initState();
    print(visitid);
    loadDataListprob().then((res) {
      setState(() {
        //_radioValue = 0;
        isLoading = false;
      });
    });
  }

  //===============================================================================================
  //                                      Dropdown List Problame
  //===============================================================================================

  loadDataListprob() async {
    final listLocationType =
        await DataListProb.getDataListProb(); // ไปเรียกฟังชั่นดึงข้อมูลจาก api
    problemType1 = null;

    _dropdownProb = [
      KeyValueModel(key: "เลือก", value: ""),
    ];
    problemType.clear();
    for (var i = 0; i < listLocationType.length; i++) {
      //print(listLocationType);

      setState(() {
        _dropdownProb.add(
          KeyValueModel(
            key: listLocationType[i]['CategoryProblem']
                .toString(), // key คือค่าที่แสดง

            value: listLocationType[i]['CategoryProblemId'].toString(),
          ),
        );
      });
    }
  }

  //===============================================================================================
  //
  //===============================================================================================

  @override
  Widget build(BuildContext context) {
    double _width = MediaQuery.of(context).size.width;

    return Material(
      color: AppColors.bgColor,
      child: Stack(
        children: <Widget>[
          Header.header1(context),
          Header.mainMenu(context),
          Container(
            margin: EdgeInsets.only(
              top: mediaQuery(context, "h", 1000),
            ),
            child: Row(
              mainAxisAlignment: MainAxisAlignment.center,
              children: <Widget>[
                Text(
                  AppStrings.VisitingPlan,
                  style: AppStyle.headTextStyle(context),
                ),
              ],
            ),
          ),
          Container(
//            color: Colors.red,
            width: _width,
            height: mediaQuery(context, 'h', 1100),
            margin: EdgeInsets.only(
              top: mediaQuery(context, 'h', 1150),
              left: mediaQuery(context, 'w', 60),
              right: mediaQuery(context, 'w', 60),
            ),
            child: SingleChildScrollView(
              child: Column(
                children: <Widget>[
                  Row(
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    children: <Widget>[
                      _buildTextMenu(
                          context, "ประเภทปัญหา / ความต้องการของลูกค้า"),
                    ],
                  ),
                  _buildSizeBox(context),
                  //======================================
                  //
                  //======================================
                  Row(
                    mainAxisAlignment: MainAxisAlignment.center,
                    children: <Widget>[
                      Container(
                        width: mediaQuery(context, "w", 1005),
                        padding: EdgeInsets.symmetric(horizontal: 10.0),
                        decoration: BoxDecoration(
                          borderRadius: BorderRadius.circular(53.0),
                          border: Border.all(
                              color: AppColors.color_border,
                              style: BorderStyle.solid,
                              width: 0.80),
                        ),
                        child: DropdownButtonHideUnderline(
                          child: DropdownButton(
                            style: TextStyle(
                              color: AppColors.Black,
                              fontSize: mediaQuery(context, "w", 30),
                            ),
                            items: _dropdownProb
                                .map(
                                  (data) => DropdownMenuItem<String>(
                                    child: Container(
                                      child: Text(
                                        data.key,
                                        style: TextStyle(
                                          fontSize:
                                              mediaQuery(context, "h", 50),
                                        ),
                                        textScaleFactor: 0.7,
                                      ),
                                    ),
                                    value: data.key + "|" + data.value,
                                  ),
                                )
                                .toList(),
                            onChanged: (value) {
                              setState(() {
                                problemType1 = value;
                              });
                            },
                            isExpanded: true,
                            value:
                                problemType1 == null ? "เลือก|" : problemType1,
                          ),
                        ),
                      ),
                    ],
                  ),
                  _buildSizeBox(context),
                  _buildSizeBox(context),
                  Row(
                    mainAxisAlignment: MainAxisAlignment.spaceEvenly,
                    children: <Widget>[
                      _buildButton(
                          context, "ยกเลิก", Colors.white, AppColors.color),
                      _buildButton(
                          context, "บันทึก", AppColors.color, Colors.white),
                    ],
                  ),
                ],
              ),
            ),
          ),
        ],
      ),
    );
  }

  _buildButton(context, text, bgColor, fontColor) {
    return ButtonTheme(
      minWidth: mediaQuery(context, "w", 477),
      height: mediaQuery(context, "h", 120),
      child: FlatButton(
        shape: new RoundedRectangleBorder(
            borderRadius: new BorderRadius.circular(
              mediaQuery(context, "w", 50),
            ),
            side: BorderSide(color: AppColors.color)),
        color: bgColor,
        textColor: Colors.red,
        padding: EdgeInsets.all(
          mediaQuery(context, "w", 10),
        ),
        onPressed: () {
          if (text == "บันทึก") {
            saveProb();
          } else {
            Navigator.of(context).pop(false);
          }
        },
        child: Text(
          text,
          style: TextStyle(
            fontSize: 14.0,
            color: fontColor,
          ),
        ),
      ),
    );
  }

  _buildSizeBox(context) {
    return SizedBox(
      height: mediaQuery(context, "h", 15),
    );
  }

  _buildTextMenu(context, text) {
    return Row(
      mainAxisAlignment: MainAxisAlignment.start,
      children: <Widget>[
        Text(
          text + " :",
          style: TextStyle(
              fontSize: mediaQuery(context, 'h', 30), color: AppColors.Black),
          textAlign: TextAlign.center,
        ),
      ],
    );
  }

  //==================================================================================================
  //
  //==================================================================================================
  saveProb() async {
    if (problemType1 == null) {
      alertForm(context, "แจ้งเตือน", "กรอกข้อมูลไม่ครบ");
    } else {
      TextEditingController xx = TextEditingController();
      xx.text = problemType1;
      var _list = ProbData(xx);

      dataProb.add(_list);

      Navigator.of(context).pushReplacement(
        MaterialPageRoute(
          settings: const RouteSettings(name: '/serviceVisitUser'),
          builder: (context) => ServiceVisitUser(
            visitid,
            file: {
              'files': null,
            },
            list: {'lists': widget.list},
            detail: {'details': widget.detail},
            prob: {'prob': dataProb},
          ),
        ),
      );
      
      
      
      //return Nav.push(context, ServiceVisitUser(visitid));

    }
  }
  //==================================================================================================
  //
  //==================================================================================================

} //class
