import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter_widget_from_html/flutter_widget_from_html.dart';
import 'package:mwf_app/service/color.dart';
import 'package:mwf_app/service/header.dart';
import 'package:mwf_app/service/navigator.dart';
import 'package:mwf_app/service/screen.dart';
import 'package:mwf_app/service/shadow.dart';
import 'package:mwf_app/service/strings.dart';
import 'package:mwf_app/model/PackageRequestHistory_model.dart';
import 'package:mwf_app/model/package.dart';
import 'package:mwf_app/set4/detail_additional_view.dart';

//Package_model
class OfferAdditional extends StatefulWidget {
  final packageOptionID;
  final pId;

  final packageId;
  final packageName;
  final packageStatus;
  final packageTextStatus;
  final packageDetail;

  OfferAdditional(
    this.packageOptionID,
    this.pId,
    this.packageId,
    this.packageName,
    this.packageStatus,
    this.packageTextStatus,
    this.packageDetail,
  );
  @override
  _OfferAdditionalState createState() => _OfferAdditionalState(
        this.packageOptionID,
        this.packageId,
        this.pId,
        this.packageName,
        this.packageStatus,
        this.packageTextStatus,
        this.packageDetail,
      );
}

TextEditingController requirement =
    TextEditingController(); // ความต้องการลูกค้า
String packageStatus; // สถานะการดำเนินการ
TextEditingController process = TextEditingController(); //การดำเนินงาร

class _OfferAdditionalState extends State<OfferAdditional> {
  String packageOptionID;
  String pId;
  String packageId;
  String packageName;
  int packageStatus;
  String packageDetail;

  String packageTextStatus;
  bool isLoading;

  List<KeyValueModel> packageStatusList = [
    KeyValueModel(key: "เลือก", value: "เลือก"),
  ];

  var statusProcess;
  var operationStatus = 'เลือก';

  _OfferAdditionalState(
      this.packageOptionID,
      this.pId,
      this.packageId,
      this.packageName,
      this.packageStatus,
      this.packageTextStatus,
      this.packageDetail);

  @override
  void initState() {
    super.initState();

    loadDataHistory();
    loadPackageStatusList().then((res) {
      setState(() {
        isLoading = true;
      });
    });
  }

  loadDataHistory() async {
    final list =
        await PackageRequestHistory.getData(); // ไปเรียกฟังชั่นดึงข้อมูลจาก api

    print(list);

    setState(() {
      list.forEach((v) {
        final list = PackageRequestHistory.fromJson(v);
        PackageRequestHistory.data.add(list); // loop เก็บข้อมูล
      });
    });
  }

  loadPackageStatusList() async {
    final getPackageStatusList = await Package
        .getDataPackageStatusList(); // ไปเรียกฟังชั่นดึงข้อมูลจาก api
    for (var i = 0; i < getPackageStatusList.length; i++) {
      setState(() {
        packageStatusList.add(
          KeyValueModel(
            key: getPackageStatusList[i]['Id'].toString(), // key คือค่าที่แสดง
            value: getPackageStatusList[i]['StatusType']
                .toString(), // value ค่าที่บันทึก
          ),
        );
      });
    }
    return "xx";
  }

//  saveRequest(context) async {
//    Map<String, dynamic> data = {"customerRequest": requirement.text};
//    Package.saveData(context, data);
//  }

  saveProcess(context) async {
    Map<String, dynamic> data = {
      "pRId": packageOptionID,
      "pId": pId,
      "ca": AppStrings.serviceElectricityUserNumberName,
      "createBy": AppStrings.userID,
      "pRDescreption": requirement.text,
    };
    print(data);
    Package.packageRequestUpdate(context, data);
  }

  saveHistory(context) async {
    Map<String, dynamic> data = {
      "pRId": packageOptionID,
      "cA": AppStrings.serviceElectricityUserNumberName,
      "pStatusType": operationStatus,
      "pHDescreption": process.text,
      "createBy": AppStrings.userID,
    };
    print(data);
    Package.packageRequestHistoryCreate(context, data);
  }

  @override
  Widget build(BuildContext context) {
    double _width = MediaQuery.of(context).size.width;

    return Material(
      color: AppColors.bgColor,
      child: Stack(
        children: <Widget>[
          Header.header1(context),
          Header.mainMenu(context),
          Container(
            width: _width,
            height: mediaQuery(context, 'h', 1300),
            margin: EdgeInsets.only(
              top: mediaQuery(context, 'h', 950),
              left: mediaQuery(context, 'w', 60),
              right: mediaQuery(context, 'w', 60),
            ),
            child: SingleChildScrollView(
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: <Widget>[
                  Container(
                    alignment: Alignment.center,
                    margin: EdgeInsets.only(
                      bottom: mediaQuery(context, 'h', 50),
                    ),
                    child: Text(
                      AppStrings.offerAdditional,
                      textAlign: TextAlign.center,
                      style: TextStyle(
                        color: Color(0xFFB58E38),
                        fontSize: mediaQuery(context, 'h', 50),
                      ),
                    ),
                  ),
                  Container(
                    width: mediaQuery(context, 'w', 1005),
                    height: mediaQuery(context, 'h', 150),
                    decoration: BoxDecoration(
                      borderRadius: BorderRadius.all(
                        Radius.circular(
                          mediaQuery(context, 'h', 140),
                        ),
                      ),
                      boxShadow: [
                        appShadow(),
                      ],
                      color: Colors.white,
                    ),
                    child: Row(
                      children: <Widget>[
                        Container(
                          width: mediaQuery(context, 'w', 230),
                          height: mediaQuery(context, 'h', 150),
                          padding: EdgeInsets.all(
                            mediaQuery(context, 'h', 35),
                          ),
                          decoration: BoxDecoration(
                            borderRadius: BorderRadius.all(
                              Radius.circular(
                                mediaQuery(context, 'h', 90),
                              ),
                            ),
                            boxShadow: [
                              appShadow(),
                            ],
                            color: AppColors.color_gold,
                          ),
                          child: Text(
                            packageId,
                            textAlign: TextAlign.center,
                            style: TextStyle(
                              fontSize: mediaQuery(context, 'h', 50),
                              color: Colors.white,
                              fontWeight: FontWeight.bold,
                            ),
                          ),
                        ),
                        Container(
                          width: mediaQuery(context, 'h', 340),
                          child: Column(
                            mainAxisAlignment: MainAxisAlignment.center,
                            children: <Widget>[
                              Text(
                                packageName,
                                textAlign: TextAlign.center,
                                style: TextStyle(
                                  fontSize: mediaQuery(context, 'h', 36),
                                  color: Color(0xFF383838),
                                ),
                              ),
                            ],
                          ),
                        ),
                        Container(
                          width: mediaQuery(context, 'w', 2),
                          height: mediaQuery(context, 'h', 100),
                          color: AppColors.color_gold,
                        ),
                        Container(
                          width: mediaQuery(context, 'h', 453),
                          padding: EdgeInsets.only(
                            left: mediaQuery(context, 'w', 66),
                          ),
                          child: Column(
                            mainAxisAlignment: MainAxisAlignment.center,
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: <Widget>[
                              Text(
                                'สถานะ',
                                textAlign: TextAlign.center,
                                style: TextStyle(
                                  fontSize: mediaQuery(context, 'h', 36),
                                  color: Color(0xFF383838),
                                ),
                              ),
                              Text(
                                packageTextStatus,
                                textAlign: TextAlign.center,
                                style: TextStyle(
                                  fontSize: mediaQuery(context, 'h', 36),
                                  color: AppColors.color_gold,
                                ),
                              ),
                            ],
                          ),
                        ),
                      ],
                    ),
                  ),
                  SizedBox(
                    height: mediaQuery(context, 'h', 50),
                  ),
                  GestureDetector(
                    onTap: () {
                      Nav.push(
                        context,
                        DetailAdditionalView(),
                      );
                    },
                    child: Container(
                      width: mediaQuery(context, 'w', 1005),
                      height: mediaQuery(context, 'h', 150),
                      decoration: BoxDecoration(
                        borderRadius: BorderRadius.all(
                          Radius.circular(
                            mediaQuery(context, 'h', 100),
                          ),
                        ),
                        boxShadow: [
                          appShadow(),
                        ],
                        color: AppColors.color_gold,
                      ),
                      child: Center(
                        child: Text(
                          'ข้อมูลบริการเสริม',
                          textAlign: TextAlign.center,
                          style: TextStyle(
                            fontSize: mediaQuery(context, 'h', 50),
                            color: Colors.white,
                          ),
                        ),
                      ),
                    ),
                  ),
                  SizedBox(
                    height: mediaQuery(context, 'h', 50),
                  ),
                  Container(
                    padding: EdgeInsets.only(
                      left: mediaQuery(context, 'w', 50),
                      right: mediaQuery(context, 'w', 50),
                    ),
                    decoration: BoxDecoration(
                      borderRadius: BorderRadius.all(
                        Radius.circular(
                          mediaQuery(context, 'h', 50),
                        ),
                      ),
                      boxShadow: [
                        appShadow(),
                      ],
                      color: Color(0xFFD1DADE),
                    ),
                    child: HtmlWidget(
                      packageDetail,
                      customWidgetBuilder: (element) {
                        if (element.localName == 'img') {
                          return Image.network(element.attributes['src']);
                        }
                        return null;
                      },
                    ),
                  ),
                  SizedBox(
                    height: mediaQuery(context, 'h', 50),
                  ),
                  Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: <Widget>[
                      Text(
                        'ความต้องการลูกค้า :',
                        textAlign: TextAlign.center,
                        style: TextStyle(
                          fontSize: mediaQuery(context, 'h', 34),
                          color: Color(0xFF383838),
                        ),
                      ),
                      Card(
                        color: Colors.white,
                        child: Padding(
                          padding: EdgeInsets.all(
                            mediaQuery(context, 'h', 40),
                          ),
                          child: TextField(
                            controller: requirement,
                            maxLines: 8,
                            style: TextStyle(
                              fontSize: mediaQuery(context, 'h', 36),
                              color: Color(0xFF707070),
                            ),
                            decoration: InputDecoration.collapsed(
                                hintText: "กรอกคำแนะนำได้ที่นี่เลย"),
                          ),
                        ),
                      ),
                    ],
                  ),
                  SizedBox(
                    height: mediaQuery(context, 'h', 50),
                  ),
                  Container(
                    width: mediaQuery(context, 'w', 1005),
                    height: mediaQuery(context, 'h', 150),
                    child: RaisedButton(
                      color: AppColors.color,
                      onPressed: () {
                        saveProcess(context);
                      },
                      shape: RoundedRectangleBorder(
                        borderRadius: BorderRadius.circular(
                          mediaQuery(context, 'h', 90),
                        ),
                      ),
                      child: Text(
                        'บันทึก / แก้ไข',
                        style: TextStyle(
                          color: Colors.white,
                          fontSize: mediaQuery(context, 'h', 50),
                        ),
                      ),
                    ),
                  ),
                  SizedBox(
                    height: mediaQuery(context, 'h', 50),
                  ),
                  Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: <Widget>[
                      Text(
                        'สถานะการดำเนินการ :',
                        textAlign: TextAlign.center,
                        style: TextStyle(
                          fontSize: mediaQuery(context, 'h', 34),
                          color: Color(0xFF383838),
                        ),
                      ),
                      _buildDropDownRow(context, statusProcess),
                    ],
                  ),
                  SizedBox(
                    height: mediaQuery(context, 'h', 50),
                  ),
                  Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: <Widget>[
                      Text(
                        'การดำเนินงาน :',
                        textAlign: TextAlign.center,
                        style: TextStyle(
                          fontSize: mediaQuery(context, 'h', 34),
                          color: Color(0xFF383838),
                        ),
                      ),
                      Card(
                        color: Colors.white,
                        child: Padding(
                          padding: EdgeInsets.all(
                            mediaQuery(context, 'h', 40),
                          ),
                          child: TextField(
                            controller: process,
                            maxLines: 8,
                            style: TextStyle(
                              fontSize: mediaQuery(context, 'h', 36),
                              color: Color(0xFF707070),
                            ),
                            decoration: InputDecoration.collapsed(
                                hintText: "กรอกคำแนะนำได้ที่นี่เลย"),
                          ),
                        ),
                      ),
                    ],
                  ),
                  SizedBox(
                    height: mediaQuery(context, 'h', 50),
                  ),
                  Container(
                    width: mediaQuery(context, 'w', 1005),
                    height: mediaQuery(context, 'h', 150),
                    child: Row(
                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                      children: <Widget>[
                        Container(
                          width: mediaQuery(context, 'w', 487),
                          child: RaisedButton(
                            color: Color(0xFFF2F5F7),
                            onPressed: () {
                              Navigator.of(context).pop(false);
                            },
                            shape: RoundedRectangleBorder(
                              borderRadius: BorderRadius.circular(
                                mediaQuery(context, 'h', 90),
                              ),
                              side: BorderSide(color: AppColors.color),
                            ),
                            child: Text(
                              'ยกเลิก',
                              style: TextStyle(
                                color: AppColors.color,
                                fontSize: mediaQuery(context, 'h', 50),
                              ),
                            ),
                          ),
                        ),
                        Container(
                          width: mediaQuery(context, 'w', 487),
                          child: RaisedButton(
                            color: AppColors.color,
                            onPressed: () {
                              saveProcess(context);
                            },
                            shape: RoundedRectangleBorder(
                              borderRadius: BorderRadius.circular(
                                mediaQuery(context, 'h', 90),
                              ),
                            ),
                            child: Text(
                              'บันทึก',
                              style: TextStyle(
                                color: Colors.white,
                                fontSize: mediaQuery(context, 'h', 50),
                              ),
                            ),
                          ),
                        ),
                      ],
                    ),
                  ),
                  SizedBox(
                    height: mediaQuery(context, 'h', 80),
                  ),
                  Column(
                    children: List.generate(PackageRequestHistory.data.length,
                        (index) {
                      return _buildCard(
                          context,
                          PackageRequestHistory.data[index].pStatusType,
                          PackageRequestHistory.data[index].createDate,
                          PackageRequestHistory.data[index].pHDescreption,
                          PackageRequestHistory.data[index].createBy);
                    }),
                  ),
                ],
              ),
            ),
          ),
        ],
      ),
    );
  }

//  _buildDropDownRow(context) {
//    return Container(
//      height: mediaQuery(context, 'h', 130),
//      width: mediaQuery(context, 'w', 1005),
//      decoration: BoxDecoration(
//        borderRadius: BorderRadius.circular(20),
//        border: Border.all(
//          color: Color(0xFF999C9D),
//          width: 0.5,
//        ),
//        color: Colors.white,
//      ),
//      child: Container(
//        margin: EdgeInsets.only(
//          left: mediaQuery(context, 'w', 25),
//        ),
//        child: DropdownButton<String>(
//            value: packageTextStatus,
//            icon: Icon(Icons.expand_more),
//            iconSize: 30,
//            elevation: 16,
//            style: TextStyle(color: AppColors.Black),
//            underline: Container(
//              height: 0,
//              color: Color(0xFF999C9D),
//            ),
//            onChanged: (String newValue) {
//              if (newValue == "ขอใช้บริการ") {
//                setState(() {
//                  packageStatus = 1;
//                });
//              } else if (newValue == "ระหว่างดำเนินการ") {
//                setState(() {
//                  packageStatus = 2;
//                });
//              } else if (newValue == "ดำเนินการจบแล้ว") {
//                setState(() {
//                  packageStatus = 3;
//                });
//              }
//            },
//            items: <String>['One', 'Two', 'Free', 'Four']
//                .map<DropdownMenuItem<String>>((String value) {
//              return DropdownMenuItem<String>(
//                value: value,
//                child: Text(value),
//              );
//            }).toList(),
//            isExpanded: true),
//      ),
//    );
//  }

  _buildDropDownRow(context, dropdownValue) {
    return Container(
      height: mediaQuery(context, 'h', 130),
      width: mediaQuery(context, 'w', 1005),
      decoration: BoxDecoration(
          borderRadius: BorderRadius.circular(20),
          border: Border.all(
            color: Color(0xFF999C9D),
            width: 0.5,
          ),
          color: Colors.white),
      child: Container(
        margin: EdgeInsets.only(
          left: mediaQuery(context, 'w', 25),
        ),
        child: DropdownButtonHideUnderline(
          child: DropdownButton<String>(
            iconSize: 0,
            icon: Icon(Icons.keyboard_arrow_down),
            underline: SizedBox(),
            items: packageStatusList
                .map(
                  (data) => DropdownMenuItem<String>(
                    child: Container(
                      child: Text(
                        data.value,
                        style: TextStyle(
                          fontSize: mediaQuery(context, "h", 50),
                        ),
                        textScaleFactor: 0.7,
                      ),
                    ),
                    value: data.key,
                  ),
                )
                .toList(),
            isExpanded: true,
            onChanged: (String value) {
              setState(() {
                operationStatus = value;
              });
            },
            value: operationStatus,
          ),
        ),
      ),
    );
  }

  _buildCard(context, status, date, detail, recorder) {
    return Container(
      width: mediaQuery(context, 'w', 1005),
      height: mediaQuery(context, 'h', 550),
      child: Column(
        children: <Widget>[
          Container(
            width: mediaQuery(context, 'w', 1005),
            height: mediaQuery(context, 'h', 120),
            padding: EdgeInsets.only(
              left: mediaQuery(context, 'w', 35),
              top: mediaQuery(context, 'h', 30),
            ),
            decoration: BoxDecoration(
              borderRadius: BorderRadius.only(
                topLeft: Radius.circular(
                  mediaQuery(context, 'h', 50),
                ),
                topRight: Radius.circular(
                  mediaQuery(context, 'h', 50),
                ),
              ),
              color: AppColors.color_gold,
            ),
            child: Text(
              'สถานะ : ' + status.toString() + '  |  วันที่ ' + date,
              style: TextStyle(
                color: Colors.white,
                fontSize: mediaQuery(context, 'h', 40),
                fontWeight: FontWeight.bold,
              ),
            ),
          ),
          Container(
            width: mediaQuery(context, 'w', 1005),
            height: mediaQuery(context, 'h', 370),
            padding: EdgeInsets.fromLTRB(
              mediaQuery(context, 'w', 40),
              mediaQuery(context, 'h', 60),
              mediaQuery(context, 'w', 40),
              mediaQuery(context, 'h', 60),
            ),
            decoration: BoxDecoration(
              borderRadius: BorderRadius.only(
                bottomLeft: Radius.circular(
                  mediaQuery(context, 'h', 40),
                ),
                bottomRight: Radius.circular(
                  mediaQuery(context, 'h', 40),
                ),
              ),
              boxShadow: [
                appShadow(),
              ],
              color: Colors.white,
            ),
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: <Widget>[
                Text(
                  detail,
                  style: TextStyle(
                    color: Color(0xFF383838),
                    fontSize: mediaQuery(context, 'h', 36),
                  ),
                ),
                Container(
                  margin: EdgeInsets.only(
                    top: mediaQuery(context, 'h', 55),
                    bottom: mediaQuery(context, 'h', 35),
                  ),
                  width: mediaQuery(context, 'w', 940),
                  height: mediaQuery(context, 'h', 0.8),
                  color: Color(0xFFC6C6C6),
                ),
                Row(
                  mainAxisAlignment: MainAxisAlignment.end,
                  children: <Widget>[
                    Text(
                      'ผู้บันทึก',
                      style: TextStyle(
                        color: AppColors.color_gold,
                        fontSize: mediaQuery(context, 'h', 36),
                        fontWeight: FontWeight.bold,
                      ),
                    ),
                    Text(
                      ' : ',
                      style: TextStyle(
                        color: AppColors.color_gold,
                        fontSize: mediaQuery(context, 'h', 36),
                      ),
                    ),
                    Text(
                      recorder,
                      style: TextStyle(
                        color: AppColors.color_gold,
                        fontSize: mediaQuery(context, 'h', 36),
                      ),
                    ),
                  ],
                ),
              ],
            ),
          ),
        ],
      ),
    );
  }
} //class

class KeyValueModel {
  String key;
  String value;

  KeyValueModel({this.key, this.value});
}
