import 'package:flutter/material.dart';
import 'package:mwf_app/service/assets.dart';
import 'package:mwf_app/service/screen.dart';

class HeaderDelegate extends SliverPersistentHeaderDelegate {
  final double flexibleSpace;
  final double backGroundHeight;
  final double stackPaddingTop;
  final double titlePaddingTop;
  final Widget title;
  final Widget subTitle;
  final Widget leading;
  final Widget action;

  HeaderDelegate({
    this.flexibleSpace,
    this.backGroundHeight = 190,
    @required this.stackPaddingTop,
    this.titlePaddingTop = 35,
    @required this.title,
    this.subTitle,
    this.leading,
    this.action,
  });

  @override
  Widget build(
      BuildContext context, double shrinkOffset, bool overlapsContent) {
    var percent = shrinkOffset / (maxExtent - minExtent);
    double calculate = 1 - percent < 0 ? 0 : (1 - percent);
    return SizedBox(
      height: maxExtent,
      child: Stack(
        children: <Widget>[
          Container(
            height: minExtent + ((backGroundHeight - minExtent) * calculate),
            width: MediaQuery.of(context).size.width,
            decoration: BoxDecoration(
              image: DecorationImage(
                image: ExactAssetImage(AppAssets.bg_about_layer2),
                fit: BoxFit.fill,
              ),
            ),
          ),
          Positioned(
            top: titlePaddingTop * calculate + mediaQuery(context, 'h', 50),
            bottom: 0.0,
            child: Container(
                padding: EdgeInsets.symmetric(horizontal: 24),
                width: MediaQuery.of(context).size.width,
                child: Wrap(
                  children: <Widget>[
                    Row(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: <Widget>[
                        leading ?? SizedBox(),
                        Column(
                          crossAxisAlignment: CrossAxisAlignment.center,
                          mainAxisSize: MainAxisSize.max,
                          children: <Widget>[
                            Transform.scale(
                              alignment: Alignment.centerLeft,
                              scale: 1.5 + (calculate * .2),
                              child: Padding(
                                padding:
                                    EdgeInsets.only(top: 14 * (1 - calculate)),
                                child: title,
                              ),
                            ),
                            calculate > 0.5
                                ? () {
                                    SizedBox(height: 20);
                                    Opacity(
                                      opacity: calculate,
                                      child: subTitle ?? SizedBox(),
                                    );
                                  }
                                : Container()
                          ],
                        ),
                      ],
                    ),
                  ],
                )),
          ),
//          Positioned(
//            top: minExtent + ((stackPaddingTop - minExtent) * calculate),
//            child: Opacity(
//              opacity: calculate,
//              child: Container(
//                width: MediaQuery.of(context).size.width,
//                child: stackChild,
//              ),
//            ),
//          )
        ],
      ),
    );
  }

  @override
  double get maxExtent => flexibleSpace;

  @override
  double get minExtent {
    return kToolbarHeight + 40;
  }

  @override
  bool shouldRebuild(SliverPersistentHeaderDelegate oldDelegate) => true;
}
