import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:mwf_app/service/assets.dart';
import 'package:mwf_app/service/color.dart';
import 'package:mwf_app/service/screen.dart';
import 'package:mwf_app/service/strings.dart';
import 'package:mwf_app/screen/bottom_menu.dart';

class DetailAdditionalView extends StatefulWidget {
  @override
  _DetailAdditionalViewState createState() => _DetailAdditionalViewState();
}

class _DetailAdditionalViewState extends State<DetailAdditionalView> {
  var dropdownValue;

  @override
  void initState() {
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    double _width = MediaQuery.of(context).size.width;

    return Material(
      color: AppColors.bgColor,
      child: Stack(
        children: <Widget>[
          Stack(
            children: <Widget>[
              Container(
                //รูปภาพ
                width: mediaQuery(context, 'w', 1125),
                height: mediaQuery(context, 'h', 700),
                margin: EdgeInsets.only(
                  top: mediaQuery(context, 'h', 200),
                ),
                decoration: BoxDecoration(
                  image: DecorationImage(
                    image: AssetImage(
                      'assets/images/additional/bg_detail_1.png',
                    ),
                    fit: BoxFit.fitWidth,
                  ),
                ),
              ),
              Container(
                width: _width,
                height: mediaQuery(context, 'h', 450),
                child: Image.asset(
                  AppAssets.bg_service,
                  fit: BoxFit.cover,
                ),
              ),
              Container(
                margin: EdgeInsets.only(
                  right: mediaQuery(context, 'w', 240),
                ),
                width: _width,
                padding: EdgeInsets.fromLTRB(mediaQuery(context, "w", 100),
                    mediaQuery(context, "h", 170), 0, 0),
                child: Text(
                  AppStrings.profileFullName +
                      " : " +
                      AppStrings.profilePosition,
                  textAlign: TextAlign.right,
                  style: TextStyle(
                    color: AppColors.color_profile,
                    fontWeight: FontWeight.bold,
                    fontSize: mediaQuery(context, "w", 30),
                  ),
                ),
              ),
              Container(
                margin: EdgeInsets.only(
                  right: mediaQuery(context, 'w', 240),
                ),
                width: _width,
                padding: EdgeInsets.fromLTRB(mediaQuery(context, "w", 100),
                    mediaQuery(context, "h", 231), 0, 0),
                child: Text(
                  AppStrings.profilePositionName,
                  textAlign: TextAlign.right,
                  style: TextStyle(
                    color: AppColors.color_profile,
                    fontSize: mediaQuery(context, "w", 30),
                  ),
                ),
              ),
              Container(
                width: mediaQuery(context, 'h', 177),
                height: mediaQuery(context, 'h', 155),
                margin: EdgeInsets.only(
                  top: mediaQuery(context, 'h', 130),
                  left: mediaQuery(context, 'w', 940),
                  right: mediaQuery(context, 'w', 30),
                ),
                decoration: BoxDecoration(
                  shape: BoxShape.circle,
                  border: Border.all(
                    color: Colors.white,
                    width: 2,
                  ),
                  image: DecorationImage(
                    fit: BoxFit.fill,
                    image: AssetImage(AppAssets.imageProfile),
                  ),
                ),
              ),
            ],
          ),
          Stack(
            children: <Widget>[
              Container(
                width: _width,
                height: mediaQuery(context, 'h', 175),
                margin: EdgeInsets.only(
                  top: mediaQuery(context, 'h', 2267.16),
                ),
                decoration: BoxDecoration(
                  borderRadius: BorderRadius.only(
                    topRight: Radius.circular(
                      mediaQuery(context, 'h', 100),
                    ),
                  ),
                  color: Color(0xFF7F3F98),
                ),
                child: BottomMenu(),
              ),
              Container(
                width: _width,
                height: mediaQuery(context, 'h', 121.87),
                margin: EdgeInsets.only(
                  top: mediaQuery(context, 'h', 2146),
                ),
                color: Color(0xFF7F3F98),
              ),
              Container(
                width: _width,
                height: mediaQuery(context, 'h', 1370),
                margin: EdgeInsets.only(
                  top: mediaQuery(context, 'h', 900),
                ),
                padding: EdgeInsets.all(
                  mediaQuery(context, 'h', 60),
                ),
                decoration: BoxDecoration(
                  borderRadius: BorderRadius.only(
                    bottomLeft: Radius.circular(
                      mediaQuery(context, 'h', 120),
                    ),
                  ),
                  color: Colors.white,
                ),
                child: Column(
                  children: <Widget>[
                    Text(
                      'นวัตกรรมไทย ดังไกลระดับโลก “หุ่นยนต์ทำความสะอาดลูกถ้วย ขณะจ่ายกระแสไฟฟ้า”',
                      style: TextStyle(
                        color: AppColors.color,
                        fontSize: mediaQuery(context, "h", 60),
                      ),
                    ),
                    Text(
                      '“Corona” (โคโรน่า) ในระบบส่งไฟฟ้า เป็นปรากฏการณ์ปกติที่เกิดขึ้นในระบบส่งจ่ายไฟฟ้าแรงสูง เนื่องจากสภาพอากาศร้อนจัดและแห้งแล้ง ทำให้ลูกถ้วยฉนวนไฟฟ้าสกปรก สูญเสียสภาพความเป็นฉนวน เกิดความเครียดของไฟฟ้าสูง เป็นผลให้อากาศบริเวณโดยรอบเกิดการแตกตัวออกมาในรูปของเสียงและแสง ซึ่งอาจทำให้เกิดการลัดวงจรของอุปกรณ์ไฟฟ้า และเกิดไฟฟ้าดับตามมาได้ แต่ปรากฏการณ์นี้ไม่ได้ทำให้เกิดอันตรายแก่ผู้อยู่อาศัยบริเวณใกล้เคียงแต่อย่างใด เพียงก่อให้เกิดความรำคาญจากเสียงและแสงที่เกิดขึ้นบ้างเท่านั้น',
                      style: TextStyle(
                        color: AppColors.color_text,
                        fontSize: mediaQuery(context, "h", 36),
                      ),
                    ),
                  ],
                ),
              ),
            ],
          ),
        ],
      ),
    );
  }
} //class
