import 'package:flutter/material.dart';
import 'package:font_awesome_flutter/font_awesome_flutter.dart';
import 'package:mwf_app/service/color.dart';
import 'package:mwf_app/service/screen.dart';
import 'package:mwf_app/service/shadow.dart';

class StaffDetail extends StatefulWidget {
  @override
  State<StatefulWidget> createState() {
    return _StaffDetail();
  }
}

class _StaffDetail extends State<StaffDetail> {
  @override
  Widget build(BuildContext context) {
    var mediaquery = MediaQuery.of(context);

    return Container(
      width: mediaquery.size.width,
      margin: EdgeInsets.only(
        top: mediaQuery(context, 'h', 200),
      ),
      decoration: new BoxDecoration(
        borderRadius: BorderRadius.only(
          topLeft: Radius.circular(40.0),
          topRight: Radius.circular(40.0),
        ),
        color: Colors.white,
      ),
      child: Container(
        margin: EdgeInsets.all(mediaQuery(context, 'w', 35)),
        //color: Colors.black26,
        child: Scaffold(
          appBar: AppBar(
            backgroundColor: Colors.white,
            elevation: 0.0,
            leading: SizedBox(),
            title: Row(
              mainAxisSize: MainAxisSize.min,
              children: <Widget>[
                Spacer(),
                Text(
                  "รายละเอียด",
                  style: TextStyle(
                      fontSize: mediaQuery(context, 'w', 70),
                      color: AppColors.color_gold),
                ),
                Spacer(),
              ],
            ),
            actions: <Widget>[
              IconButton(
                icon: Icon(
                  Icons.close,
                  color: Colors.black,
                ),
                onPressed: () {
                  Navigator.pop(context);
                },
              ),
            ],
          ),
          body: Container(
            margin: EdgeInsets.all(mediaQuery(context, 'w', 10)),
            //color: Colors.black26,
            child: Column(
              children: <Widget>[
                Row(
                  children: <Widget>[
                    Text(
                      'วันที่ชำระ : ',
                      style: TextStyle(
                        fontWeight: FontWeight.bold,
                        fontSize: mediaQuery(context, 'w', 40),
                      ),
                    ),
                    Text(
                      '22/06/2563',
                      style: TextStyle(
                        fontSize: mediaQuery(context, 'w', 40),
                      ),
                    ),
                  ],
                ),
                Container(
                  height: mediaQuery(context, 'h', 1650),
                  child: SingleChildScrollView(
                    child: Column(
                      children: <Widget>[
                        SizedBox(
                          height: mediaQuery(context, 'h', 40),
                        ),
                        _buildContent(
                          context,
                          '1',
                          'ค่าไฟฟ้า',
                          '200.00',
                        ),
                        _buildContent(
                          context,
                          '2',
                          'ค่ามิเตอร์',
                          '100.00',
                        ),
                        _buildContent(
                          context,
                          '3',
                          'ค่าภาษี',
                          '0.07',
                        ),
                        Container(
                          width: mediaQuery(context, 'w', 1005),
                          padding: EdgeInsets.all(
                            mediaQuery(context, 'h', 50),
                          ),
                          margin: EdgeInsets.only(
                            bottom: mediaQuery(context, 'h', 40),
                            left: mediaQuery(context, 'h', 10),
                            right: mediaQuery(context, 'h', 10),
                          ),
                          decoration: BoxDecoration(
                            borderRadius: new BorderRadius.all(
                              Radius.circular(
                                mediaQuery(context, 'h', 20),
                              ),
                            ),
                            color: Color(0xFFE6EDF0),
                          ),
                          child: Row(
                            children: <Widget>[
                              Container(
                                width: mediaQuery(context, 'w', 780),
                                child: Wrap(
                                  spacing: 5.0,
                                  runSpacing: 5.0,
                                  direction: Axis.vertical,
                                  children: <Widget>[
                                    Column(
                                      crossAxisAlignment:
                                          CrossAxisAlignment.start,
                                      children: <Widget>[
                                        Row(
                                          crossAxisAlignment:
                                              CrossAxisAlignment.start,
                                          children: <Widget>[
                                            Text(
                                              'รวมยอดชำระ : ',
                                              style: TextStyle(
                                                color: AppColors.color_text,
                                                fontSize: mediaQuery(
                                                    context, 'h', 42),
                                              ),
                                            ),
                                            Text(
                                              '407.07',
                                              style: TextStyle(
                                                color: AppColors.color_text,
                                                fontSize: mediaQuery(
                                                    context, 'h', 42),
                                              ),
                                            ),
                                          ],
                                        ),
                                      ],
                                    ),
                                  ],
                                ),
                              )
                            ],
                          ),
                        )
                      ],
                    ),
                  ),
                ),
              ],
            ),
          ),
          backgroundColor: Colors.white,
        ),
      ),
    );
  }
}

_buildContent(
  context,
  number,
  list,
  price,
) {
  return Container(
    width: mediaQuery(context, 'w', 1005),
    padding: EdgeInsets.all(
      mediaQuery(context, 'h', 50),
    ),
    margin: EdgeInsets.only(
      bottom: mediaQuery(context, 'h', 40),
      left: mediaQuery(context, 'h', 10),
      right: mediaQuery(context, 'h', 10),
    ),
    decoration: BoxDecoration(
      border: Border.all(
        color: AppColors.bgColor,
      ),
      borderRadius: new BorderRadius.all(
        Radius.circular(
          mediaQuery(context, 'h', 20),
        ),
      ),
      boxShadow: [
        appShadow(),
      ],
      color: Colors.white,
    ),
    child: Row(
      children: <Widget>[
        GestureDetector(
          onTap: () {},
          child: Container(
            width: mediaQuery(context, 'w', 780),
            child: Wrap(
              spacing: 5.0,
              runSpacing: 5.0,
              direction: Axis.vertical,
              children: <Widget>[
                Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: <Widget>[
                    Row(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: <Widget>[
                        Text(
                          'ลำดับ : ',
                          style: TextStyle(
                            color: AppColors.color_text,
                            fontSize: mediaQuery(context, 'h', 42),
                          ),
                        ),
                        Text(
                          number,
                          style: TextStyle(
                            color: AppColors.color_text,
                            fontSize: mediaQuery(context, 'h', 40),
                          ),
                        ),
                      ],
                    ),
                    Row(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: <Widget>[
                        Text(
                          'รายการ : ',
                          style: TextStyle(
                            color: AppColors.color_text,
                            fontSize: mediaQuery(context, 'h', 42),
                          ),
                        ),
                        Text(
                          list,
                          style: TextStyle(
                            color: AppColors.color_text,
                            fontSize: mediaQuery(context, 'h', 40),
                          ),
                        ),
                      ],
                    ),
                    Row(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: <Widget>[
                        Text(
                          'ราคา : ',
                          style: TextStyle(
                            color: AppColors.color_text,
                            fontSize: mediaQuery(context, 'h', 42),
                          ),
                        ),
                        Text(
                          price,
                          style: TextStyle(
                            color: AppColors.color_text,
                            fontSize: mediaQuery(context, 'h', 40),
                          ),
                        ),
                      ],
                    ),
                  ],
                ),
              ],
            ),
          ),
        ),
        Flexible(
            child: GestureDetector(
          onTap: () {
            print('ondel');
          },
          child: Container(
            alignment: Alignment.center,
            padding: EdgeInsets.only(left: mediaQuery(context, 'w', 70)),
            child: Center(
              child: Icon(
                FontAwesomeIcons.trashAlt,
                size: mediaQuery(context, 'h', 60),
                color: AppColors.color_gold,
              ),
            ),
          ),
        ))
      ],
    ),
  );
}
