//HistoryPayment_model.dart
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:mwf_app/service/color.dart';
import 'package:mwf_app/service/header.dart';
import 'package:mwf_app/service/loader.dart';
import 'package:mwf_app/service/screen.dart';
import 'package:mwf_app/service/shadow.dart';
import 'package:mwf_app/service/strings.dart';
import 'package:mwf_app/model/history_payment.dart';
import 'package:mwf_app/set9/payment_detail.dart';

class HistoryPayment extends StatefulWidget {
  @override
  _HistoryPaymentState createState() => _HistoryPaymentState();
}

class _HistoryPaymentState extends State<HistoryPayment> {
  bool isLoading = false;
  @override
  void initState() {
    super.initState();
    loadData(); // ดึงข้อมูล
  }

  loadData() async {
    setState(() {
      isLoading = true;
    });
    try{
      final list =
        await HistoryPaymentModel.getData(); // ไปเรียกฟังชั่นดึงข้อมูลจาก api
      HistoryPaymentModel.data.clear();
  
      setState(() {
        list.forEach((v) {
          final list1 = HistoryPaymentModel.fromJson(v);
          HistoryPaymentModel.data.add(list1); // loop เก็บข้อมูล
        });
      });
      await Future.delayed(const Duration(milliseconds: 1000));
      setState(() {
        isLoading = false;
      });
    }catch(e){
      print(e);
      setState(() {
        isLoading = false;
      });
    }
    
  }

  @override
  Widget build(BuildContext context) {
    if (isLoading == true) {
      AppLoader.show();
    }
    if (isLoading == false) {
      AppLoader.hide();
    }
    double _width = MediaQuery.of(context).size.width;

    return Material(
      color: AppColors.bgColor,
      child: Stack(
        children: <Widget>[
          Header.header1(context),
          Header.mainMenu(context),
          Container(
            width: _width,
            height: mediaQuery(context, 'h', 1250),
            margin: EdgeInsets.only(
              top: mediaQuery(context, 'h', 980),
              left: mediaQuery(context, 'w', 60),
              right: mediaQuery(context, 'w', 60),
            ),
            child: SingleChildScrollView(
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: <Widget>[
                  Container(
                    alignment: Alignment.center,
                    child: Text(
                      AppStrings.historyPayment,
                      style: TextStyle(
                        color: AppColors.color_gold,
                        fontSize: mediaQuery(context, 'h', 60),
                      ),
                    ),
                  ),
                  SizedBox(
                    height: mediaQuery(context, 'h', 30),
                  ),
                  Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: <Widget>[
                      SizedBox(
                        height: mediaQuery(context, 'h', 30),
                      ),
                      Column(
                        children: List.generate(
                          HistoryPaymentModel.data.length,
                          (index) {
                            return _buildCard(
                              (index + 1).toString(),
                              HistoryPaymentModel.data[index].amount.toString(),
                              HistoryPaymentModel.data[index].dueDate
                                  .toString(),
                              HistoryPaymentModel.data[index].paymentDate,
                              HistoryPaymentModel.data[index].paymentChannel
                                  .toString(),
                              HistoryPaymentModel.data[index].unitUsed
                                  .toString(),
                              HistoryPaymentModel.data[index].billMonth
                                  .toString(),
                              HistoryPaymentModel.data[index].billItemList,
                            );
                          },
                        ),
                      )
                    ],
                  ),
                  SizedBox(
                    height: mediaQuery(context, 'h', 60),
                  ),
                ],
              ),
            ),
          ),
        ],
      ),
    );
  }

  _buildCard(
      number, payment, dueDate, payDate, method, unitUse, billMonth, itemList) {
    //var f = NumberFormat("#,###.0#", "en_US");
    // String amount = f.format(double.parse(payment));
    String amount = payment;
    return GestureDetector(
      onTap: () {
        print("open Details");
        showDialog(
          context: context,
          builder: (BuildContext context) => PaymentDetail(itemList, payDate),
        );
      },
      child: Container(
        width: mediaQuery(context, 'w', 1005),
//      height: mediaQuery(context, 'h', 380),
        padding: EdgeInsets.all(
          mediaQuery(context, 'h', 50),
        ),
        margin: EdgeInsets.only(
          bottom: mediaQuery(context, 'h', 40),
        ),
        decoration: BoxDecoration(
          borderRadius: BorderRadius.all(
            Radius.circular(
              mediaQuery(context, 'h', 20),
            ),
          ),
          boxShadow: [
            appShadow(),
          ],
          color: Colors.white,
        ),
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: <Widget>[
            Row(
              children: <Widget>[
                Text(
                  'รอบบิล : ',
                  style: TextStyle(
                    color: AppColors.color_text,
                    fontSize: mediaQuery(context, 'h', 40),
                    fontWeight: FontWeight.bold,
                  ),
                ),
                Text(
                  billMonth,
                  style: TextStyle(
                    color: AppColors.color_text,
                    fontSize: mediaQuery(context, 'h', 40),
                  ),
                ),
              ],
            ),
            Row(
              children: <Widget>[
                Text(
                  'หน่วยการใช้ : ',
                  style: TextStyle(
                    color: AppColors.color_text,
                    fontSize: mediaQuery(context, 'h', 40),
                    fontWeight: FontWeight.bold,
                  ),
                ),
                Text(
                  unitUse + " หน่วย",
                  style: TextStyle(
                    color: AppColors.color_text,
                    fontSize: mediaQuery(context, 'h', 40),
                  ),
                ),
              ],
            ),
            Row(
              children: <Widget>[
                Text(
                  'ยอดชำระ : ',
                  style: TextStyle(
                    color: AppColors.color_text,
                    fontSize: mediaQuery(context, 'h', 40),
                    fontWeight: FontWeight.bold,
                  ),
                ),
                Text(
                  amount + " บาท",
                  style: TextStyle(
                    color: AppColors.color_text,
                    fontSize: mediaQuery(context, 'h', 40),
                  ),
                ),
              ],
            ),
            Row(
              children: <Widget>[
                Text(
                  'กำหนดชำระ : ',
                  style: TextStyle(
                    color: AppColors.color_text,
                    fontSize: mediaQuery(context, 'h', 40),
                    fontWeight: FontWeight.bold,
                  ),
                ),
                Text(
                  dueDate,
                  style: TextStyle(
                    color: AppColors.color_text,
                    fontSize: mediaQuery(context, 'h', 40),
                  ),
                ),
              ],
            ),
            Row(
              children: <Widget>[
                Text(
                  'วันที่ชำระ : ',
                  style: TextStyle(
                    color: AppColors.color_text,
                    fontSize: mediaQuery(context, 'h', 40),
                    fontWeight: FontWeight.bold,
                  ),
                ),
                Text(
                  payDate,
                  style: TextStyle(
                    color: AppColors.color_text,
                    fontSize: mediaQuery(context, 'h', 40),
                  ),
                ),
              ],
            ),
            Row(
              children: <Widget>[
                Text(
                  'ช่องทาง : ',
                  style: TextStyle(
                    color: AppColors.color_text,
                    fontSize: mediaQuery(context, 'h', 40),
                    fontWeight: FontWeight.bold,
                  ),
                ),
                Text(
                  method,
                  style: TextStyle(
                    color: AppColors.color_text,
                    fontSize: mediaQuery(context, 'h', 40),
                  ),
                ),
              ],
            ),
          ],
        ),
      ),
    );
  }
} //class
