import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:mwf_app/service/color.dart';
import 'package:mwf_app/service/header.dart';
import 'package:mwf_app/service/screen.dart';
import 'package:mwf_app/service/style.dart';
import 'package:mwf_app/model/package.dart';

//Package_model
class AddAdditionalServices extends StatefulWidget {
  @override
  _AddAdditionalServicesState createState() => _AddAdditionalServicesState();
}

TextEditingController requirement =
    TextEditingController(); // ความต้องการลูกค้า
String statusProcess;

class _AddAdditionalServicesState extends State<AddAdditionalServices> {
  int _radioValue = 0;
  final List<String> _dropdownAct = [
    "อยู่ระหว่างดำเนินการ",
    "Two",
    "Three",
    "Four",
    "Five"
  ]; //The list of values we want on the dropdown
  @override
  void initState() {
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    double _width = MediaQuery.of(context).size.width;

    return Material(
      color: AppColors.bgColor,
      child: Stack(
        children: <Widget>[
          Header.header1(context),
          Header.mainMenu(context),
          Container(
            margin: EdgeInsets.only(
              top: mediaQuery(context, 'h', 950),
            ),
            child: Row(
              mainAxisAlignment: MainAxisAlignment.center,
              children: <Widget>[
                Text(
                  "เพิ่มการให้บริการเสริม",
                  style: AppStyle.headTextStyle(context),
                )
              ],
            ),
          ),
          Container(
//            color: Colors.red,
            width: _width,
            height: mediaQuery(context, 'h', 1100),
            margin: EdgeInsets.only(
              top: mediaQuery(context, 'h', 1100),
              left: mediaQuery(context, 'w', 60),
              right: mediaQuery(context, 'w', 60),
            ),
            child: SingleChildScrollView(
              child: Column(
                children: <Widget>[
                  _buildRow(context, 0),
                  _buildSizeBox(context),
                  _buildRow(context, 1),
                  _buildSizeBox(context),
                  _buildSizeBox(context),
                  _buildTextMenu(context, "ความต้องการของลูกค้า :"),
                  _buildSizeBox(context),
                  _buildTextArea(context, requirement),
                  _buildSizeBox(context),
                  _buildTextMenu(context, "สถานะการดำเนินการ :"),
                  _buildSizeBox(context),
                  _buildDropDown(context, statusProcess, _dropdownAct),
                  _buildSizeBox(context),
                  _buildSizeBox(context),
                  Row(
                    mainAxisAlignment: MainAxisAlignment.spaceEvenly,
                    children: <Widget>[
                      _buildButton(
                          context, "ยกเลิก", Colors.white, AppColors.color),
                      _buildButton(
                          context, "บันทึก", AppColors.color, Colors.white),
                    ],
                  ),
                ],
              ),
            ),
          ),
        ],
      ),
    );
  }

  save() async {
    Map<String, dynamic> data = {
      "customerRequest": requirement.text,
      "packageStatus": statusProcess
    };
    print(data);
    Package.saveData(context, data);
  }

  _buildButton(context, text, bgColor, fontColor) {
    return ButtonTheme(
      minWidth: mediaQuery(context, "w", 477),
      height: mediaQuery(context, "h", 120),
      child: FlatButton(
        shape: new RoundedRectangleBorder(
            borderRadius: new BorderRadius.circular(
              mediaQuery(context, "w", 50),
            ),
            side: BorderSide(color: AppColors.color)),
        color: bgColor,
        textColor: Colors.red,
        padding: EdgeInsets.all(
          mediaQuery(context, "w", 10),
        ),
        onPressed: () {
          if (text == "บันทึก") {
            //
          } else {
            Navigator.of(context).pop(false);
          }
          print(text);
        },
        child: Text(
          text,
          style: TextStyle(
            fontSize: 14.0,
            color: fontColor,
          ),
        ),
      ),
    );
  }

  _buildButtonRow(context, text, bgColor, fontColor) {
    return Row(
      mainAxisAlignment: MainAxisAlignment.center,
      children: <Widget>[
        ButtonTheme(
          minWidth: mediaQuery(context, "w", 1005),
          height: mediaQuery(context, "h", 120),
          child: FlatButton(
            shape: new RoundedRectangleBorder(
                borderRadius: new BorderRadius.circular(
                  mediaQuery(context, "w", 50),
                ),
                side: BorderSide(color: AppColors.color)),
            color: bgColor,
            textColor: Colors.red,
            padding: EdgeInsets.all(
              mediaQuery(context, "w", 10),
            ),
            onPressed: () {
              print(text);
            },
            child: Text(
              text,
              style: TextStyle(
                fontSize: 14.0,
                color: fontColor,
              ),
            ),
          ),
        )
      ],
    );
  }

  _buildDropDown(context, controller, List<String> _dropdownValues) {
    return Row(
      mainAxisAlignment: MainAxisAlignment.center,
      children: <Widget>[
        Container(
          height: mediaQuery(context, 'h', 110),
          width: mediaQuery(context, 'w', 1005),
          padding: EdgeInsets.symmetric(horizontal: 10.0),
          decoration: BoxDecoration(
            color: Colors.white,
            borderRadius: BorderRadius.circular(53.0),
            border: Border.all(
              color: AppColors.color_border,
              style: BorderStyle.solid,
              width: 0.80,
            ),
          ),
          child: DropdownButtonHideUnderline(
            child: DropdownButton(
              value: controller,
              style: TextStyle(
                color: AppColors.Black,
                fontSize: mediaQuery(context, "w", 30),
              ),
              items: _dropdownValues
                  .map(
                    (value) => DropdownMenuItem(
                      child: Text(value),
                      value: value,
                    ),
                  )
                  .toList(),
              onChanged: (newValue) {
                setState(() {
                  controller = newValue;
                  statusProcess = newValue;
                });
                print(controller);
              },
              isExpanded: true,
            ),
          ),
        ),
      ],
    );
  }

  _buildTextArea(context, controller) {
    return Container(
      color: Colors.white,
      child: TextField(
        controller: controller,
        maxLines: 5,
        decoration: InputDecoration(
            fillColor: Colors.white70,
            border: new OutlineInputBorder(
              borderRadius: const BorderRadius.all(
                const Radius.circular(10.0),
              ),
            ),
            hintText: "",
            labelText: ''),
      ),
    );
  }

  _buildTextMenu(context, text) {
    return Row(
      mainAxisAlignment: MainAxisAlignment.start,
      children: <Widget>[
        Text(
          text,
          style: TextStyle(
              fontSize: mediaQuery(context, 'h', 30), color: AppColors.Black),
          textAlign: TextAlign.center,
        ),
      ],
    );
  }

  _buildSizeBox(context) {
    return SizedBox(
      height: mediaQuery(context, "h", 15),
    );
  }

  _buildRow(context, int value) {
    return Row(
      mainAxisAlignment: MainAxisAlignment.center,
      children: <Widget>[
        Row(
          mainAxisAlignment: MainAxisAlignment.center,
          children: <Widget>[
            Container(
              width: mediaQuery(context, 'w', 1005),
              height: mediaQuery(context, 'h', 150),
              decoration: BoxDecoration(
                borderRadius: new BorderRadius.all(
                  Radius.circular(
                    mediaQuery(context, 'h', 140),
                  ),
                ),
                boxShadow: [
                  BoxShadow(
                    offset: Offset(2.0, 2.0),
                    blurRadius: 10.0,
                    color: Color(0xFF000000).withOpacity(0.10),
                  ),
                ],
                color: Colors.white,
              ),
              child: Row(
                children: <Widget>[
                  Container(
                    width: mediaQuery(context, 'h', 350),
                    child: Row(
                      mainAxisAlignment: MainAxisAlignment.center,
                      children: <Widget>[
                        Radio(
                          value: value,
                          groupValue: _radioValue,
                          onChanged: _handleRadioValueChange,
                        ),
                        Text(
                          "PK001",
                          style: TextStyle(
                            fontSize: mediaQuery(context, "w", 30),
                          ),
                        ),
                      ],
                    ),
                  ),
                  Container(
                    width: mediaQuery(context, 'w', 2),
                    height: mediaQuery(context, 'h', 100),
                    color: AppColors.color_gold,
                  ),
                  Container(
                    width: mediaQuery(context, 'h', 500),
                    padding: EdgeInsets.only(
                      left: mediaQuery(context, 'w', 66),
                    ),
                    child: Column(
                      mainAxisAlignment: MainAxisAlignment.center,
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: <Widget>[
                        Text(
                          'บริการรื้อสายหม้อแปลง',
                          textAlign: TextAlign.center,
                          style: TextStyle(
                            fontSize: mediaQuery(context, 'h', 30),
                            color: Color(0xFF383838),
                          ),
                        ),
                      ],
                    ),
                  ),
                  Container(
                    width: mediaQuery(context, 'w', 2),
                    height: mediaQuery(context, 'h', 100),
                    color: AppColors.color_gold,
                  ),
                  Spacer(),
                  Container(
                    alignment: Alignment.center,
//                    alignment: Alignment.topRight,
                    width: mediaQuery(context, 'h', 200),
//                                  padding: EdgeInsets.only(
//                                    right: mediaQuery(context, 'w', 1),
//                                  ),
                    child: Row(
                      mainAxisAlignment: MainAxisAlignment.center,
                      children: <Widget>[
                        Text(
                          'รายละเอียด',
                          style:
                              TextStyle(fontSize: mediaQuery(context, "w", 30)),
                        ),
                      ],
                    ),
                  ),
                  Spacer(),
                ],
              ),
            ),
          ],
        ),
      ],
    );
  }

  void _handleRadioValueChange(int value) {
    setState(() {
      _radioValue = value;
    });
  }
} //class
