import 'dart:async';
import 'package:get/get.dart';
import 'package:flutter/material.dart';
import 'package:flutter/cupertino.dart';
import 'package:need_resume/need_resume.dart';
import 'package:mwf_app/model/Permission_model.dart';
import 'package:google_maps_flutter/google_maps_flutter.dart';

import 'package:mwf_app/service/alert.dart';
import 'package:mwf_app/service/color.dart';
import 'package:mwf_app/service/header.dart';
import 'package:mwf_app/service/loader.dart';
import 'package:mwf_app/service/screen.dart';
import 'package:mwf_app/service/strings.dart';
import 'package:mwf_app/service/fontsize.dart';

import 'package:mwf_app/model/customer_Info.dart';

import 'package:mwf_app/set1/serve_customers.dart';
import 'package:mwf_app/set1/customer_property_edit.dart';

class CustomerProperty extends StatefulWidget {
 
  CustomerProperty();

  @override
  _CustomerPropertyState createState() => _CustomerPropertyState();
}

//CustomerInfo_model
class _CustomerPropertyState extends ResumableState<CustomerProperty> {
  _CustomerPropertyState();

  TextEditingController customerGroup = TextEditingController(); //กลุ่มลูกค้า
  TextEditingController highValue = TextEditingController(); // highValue
  TextEditingController averageValue = TextEditingController(); //มูลค่าเฉลี่ยน
  TextEditingController keyStatus =
      TextEditingController(); // สถานะ key account
  TextEditingController businessPartner =
      TextEditingController(); // Business Partner
  TextEditingController transformSize = TextEditingController(); // ขนาดหม้อแปลง
  TextEditingController website = TextEditingController(); // เว็บไซต์
  TextEditingController latitude = TextEditingController(); //ละจิตูด
  TextEditingController longitude = TextEditingController(); // ลองจิตูด
  TextEditingController inIndustry = TextEditingController(); // เชตอุตสาหกรรม

  String isView = '';
  String isAdd = '';
  String isUpdate = '';
  String isDelete = '';
  String isAll = '';
  //  ตัวแปรกลุ่มลักษณะหลัก
  bool monVal = false; //ระดับแรงดัน 69/115/2
  bool monVal2 = false; // ค่าไฟฟ้าเฉลี่ยนต่อเดือน
  bool monVal3 = false; // กลุ่มเสียงสูญเสียรายได้ SPP
  bool monValOwn = false; // กลุ่มเสียงสูญเสียรายได้จากการผลิตไฟฟ้าใช้เอง
  bool monVal4 = false; // ลูกค้าธุรกิจเสริม
  bool monVal5 = false; // มีศักยภาพสอดคล้อง
  bool monVal6 = false; // มีเครือข่ายทั่วประเทศ
//  ตัวแปรกลุ่มลักษณะรอง
  bool monVal8 = false; //กลุ่มตอบสนอง
  bool monVal9 = false; //ลูกค้าที่มีมูลค่าความเสีบหายสูงจากไฟฟ้าขัดข้อง
  bool monVal10 = false; //ลูกค้าสำคัญรายเดิม

  var customerInfo1; //คุณลักษณะกลุ่มหลัก
  var customerInfo2; //คุณลักษณะกลุ่มรอง

  String industrialArea = ''; //เขตอุตสาหกรรม
  String ruralArea = ''; // เขตเมืองชนบท

  int radioRuralArea = 0;
  int radioIndustrialArea = 0;

  bool isLoading = false;

  List<String> mainGroup =
      []; // ใช้เก็บข้อมูล ุณลักษณะกลุ่มหลัก สำหรับบันทึก api
  List<String> minorGroup =
      []; // ใช้เก็บข้อมูล ุณลักษณะกลุ่มรอง สำหรับบันทึก api
  List<Marker> myMarker = []; //maker map

  @override
  void onReady() {
    print('Screen is ready!');
    print('Permission for this menu ...');
    setPermission();
    getLoadData();
  }

  setPermission() async {
    var data = await Permission.getResource("menuTypeUserData");
    isAdd = data.add;
    isUpdate = data.edit;
    isDelete = data.delete;
    isAll = data.all;
    print("isView -->" + isView);
    print("isAdd -->" + isAdd);
    print("isUpdate -->" + isUpdate);
    print("isDelete -->" + isDelete);
    print("isAll -->" + isAll);
  }
  
  @override
  void deactivate() {
    super.deactivate();
    print('Screen is Deactivate prop!');
  }

  @override
  void onResume() {
    getLoadData();
    print('Screen is resumed!');
  }

  @override
  void onPause() {
    print('Screen is paused!');
  }

  @override
  void dispose() {
    super.dispose();
  }

  void getLoadData() {
    loadData().then((res) {
      if (res != false) {
        setState(() {
          customerGroup.text =
              CustomerInfo.data[0].customerClassification; //กลุ่มลูกค้า
          highValue.text = CustomerInfo.data[0].highValueSize; // highValue
          averageValue.text =
              CustomerInfo.data[0].highValueAmount; //มูลค่าเฉลี่ยน
          keyStatus.text = CustomerInfo.data[0].kamType; // สถานะ key account
          businessPartner.text =
              CustomerInfo.data[0].businessPartner; // Business Partner
          transformSize.text =
              CustomerInfo.data[0].sizeoftransformer; // ขนาดหม้อแปลง
          website.text = CustomerInfo.data[0].website; // เว็บไซต์
          latitude.text = CustomerInfo.data[0].latitude; //ละจิตูด
          longitude.text = CustomerInfo.data[0].longitude; // ลองจิตูด

          print("Latitude : " + CustomerInfo.data[0].latitude);
          print("Longtitude : " + CustomerInfo.data[0].longitude);

          if (CustomerInfo.data[0].isIndustrialArea) {
            radioIndustrialArea = 1;
          } else if (CustomerInfo.data[0].isCountryside) {
            radioIndustrialArea = 2;
          } else if (!CustomerInfo.data[0].isIndustrialArea &&
              !CustomerInfo.data[0].isCountryside) {
            radioIndustrialArea = 3;
          }
          double _latitude = double.parse(CustomerInfo.data[0].latitude);
          double _longitude = double.parse(CustomerInfo.data[0].longitude);
          myMarker.add(Marker(
            markerId: MarkerId(LatLng(_latitude, _longitude).toString()),
            position: LatLng(_latitude, _longitude),
          ));
          isLoading = false;
        });

        if (CustomerInfo.data[0].haveVoltageKv) {
          setState(() {
            monVal = true; //ระดับแรงดัน 69/115/2
          });
        }

        if (CustomerInfo.data[0].haveHighElectricityBill) {
          setState(() {
            monVal2 = true; // ค่าไฟฟ้าเฉลี่ยนต่อเดือน
          });
        }

        if (CustomerInfo.data[0].haveRiskLoseToSpp) {
          setState(() {
            monVal3 = true; // กลุ่มเสียงสูญเสียรายได้
          });
        }
        if (CustomerInfo.data[0].haveRiskLoseToOwnElectric) {
          setState(() {
            monValOwn = true; // กลุ่มเสียงสูญเสียรายได้
          });
        }

        if (CustomerInfo.data[0].havePotentialMoreBusiness) {
          setState(() {
            monVal4 = true; // ลูกค้าธุรกิจเสริม
          });
        }

        if (CustomerInfo.data[0].havePotentialStrategicEconomy) {
          setState(() {
            monVal5 = true; // มีศักยภาพสอดคล้อง
          });
        }

        if (CustomerInfo.data[0].haveConnection) {
          setState(() {
            monVal6 = true; // มีเครือข่ายทั่วประเทศ
          });
        }

        minorGroup.add(
            CustomerInfo.data[0].customerInfo2.toString()); // เพิ่มค่าเข้าไป

        if (CustomerInfo.data[0].haveGoodImageToOrganization) {
          setState(() {
            monVal8 = true; //กลุ่มตอบสนอง
          });
        }

        if (CustomerInfo.data[0].haveLoseMoneyFromElectricProblem) {
          setState(() {
            monVal9 = true; //ลูกค้าที่มีมูลค่าความเสีบหายสูงจากไฟฟ้าขัดข้อง
          });
        }

        if (CustomerInfo.data[0].isOldKam) {
          setState(() {
            monVal10 = true; //ลูกค้าสำคัญรายเดิม
          });
        }

        if (CustomerInfo.data[0].isCountryside) {
          radioRuralArea = 2;
        } else if (!CustomerInfo.data[0].isCountryside) {
          radioRuralArea = 1;
        } else {
          radioRuralArea = 3;
        }
      }
    });
  }

  Future<bool> loadData() async {
    setState(() {
      isLoading = true;
    });
    AppLoader.show();
    try {
      final list =
          await CustomerInfo.getData(); // ไปเรียกฟังชั่นดึงข้อมูลจาก api
      setState(() {
        final customerInfoList = CustomerInfo.fromJson(list);
        CustomerInfo.data.add(customerInfoList); // loop เก็บข้อมูล
      });
      await Future.delayed(const Duration(milliseconds: 2000));
      isLoading = false;
      AppLoader.hide();
      return true;
    } catch (e) {
      setState(() {
        isLoading = false;
      });
      print(e);
      AppLoader.hide();
      return false;
    }
  }

  @override
  Widget build(BuildContext context) {
    Header.routes = ServeCustomer();
    double _width = MediaQuery.of(context).size.width;

    return Material(
      color: AppColors.bgColor,
      child: WillPopScope(
        onWillPop: () async {
          Get.offAll(Header.routes);
          return false;
        },
        child: Stack(
          children: <Widget>[
            Header.headerListPage(context),
            Header.mainMenu(context),
            Container(
              margin: EdgeInsets.only(
                top: mediaQuery(context, 'h', 950),
              ),
              child: Stack(
                children: <Widget>[
                  Row(
                    mainAxisAlignment: MainAxisAlignment.center,
                    children: <Widget>[
                      Text(
                        AppStrings.CustomerProp_CustomerProperty,
                        style: TextStyle(
                          fontSize:
                              mediaQuery(context, 'h', AppFontSize.headText),
                          color: AppColors.color_gold,
                        ),
                        textAlign: TextAlign.center,
                      ),
                    ],
                  ),
                  Padding(
                    padding: EdgeInsets.only(
                      right: mediaQuery(context, "w", 40),
                    ),
                    child: Row(
                      mainAxisAlignment: MainAxisAlignment.end,
                      children: <Widget>[
                        isUpdate == "1" || isUpdate.isEmpty || isAll == "1"
                            ? GestureDetector(
                                onTap: () {
                                  push(
                                    context,
                                    MaterialPageRoute(
                                      builder: (context) =>
                                          CustomerPropertyEdit(),
                                    ),
                                  );
                                },
                                child: ButtonTheme(
                                  minWidth: mediaQuery(context, "w", 200),
                                  height: mediaQuery(context, "h", 80),
                                  child: RaisedButton(
                                    child: Row(
                                      children: <Widget>[
                                        Icon(
                                          Icons.edit,
                                          color: Colors.white,
                                          size: mediaQuery(context, "w", 50),
                                        ),
                                        Text(
                                          'แก้ไข',
                                          style: TextStyle(
                                            color: Colors.white,
                                            fontSize:
                                                mediaQuery(context, "w", 40),
                                          ),
                                        ),
                                      ],
                                    ),
                                    color: AppColors.color,
                                    shape: RoundedRectangleBorder(
                                      borderRadius: BorderRadius.all(
                                        Radius.circular(16.0),
                                      ),
                                    ),
                                    onPressed: () {
                                      push(
                                        context,
                                        MaterialPageRoute(
                                          builder: (context) =>
                                              CustomerPropertyEdit(),
                                        ),
                                      );
                                    },
                                  ),
                                ),
                              )
                            : Text(""),
                      ],
                    ),
                  ),
                ],
              ),
            ),
            Container(
              width: _width,
              height: mediaQuery(context, 'h', 1100),
              margin: EdgeInsets.only(
                top: mediaQuery(context, 'h', 1100),
                left: mediaQuery(context, 'w', 30),
                right: mediaQuery(context, 'w', 30),
              ),
              child: SingleChildScrollView(
                child: Column(
                  children: <Widget>[
                    _buildTextMenu(context, AppStrings.CustomerProp_groupCus),
                    SizedBox(
                      height: mediaQuery(context, "h", 15),
                    ),
                    Row(
                      children: <Widget>[
                        _buildTextField(context, customerGroup),
                      ],
                    ),
                    SizedBox(
                      height: mediaQuery(context, "h", 15),
                    ),
                    _buildTextMenu(context, AppStrings.CustomerProp_HighValue),
                    SizedBox(
                      height: mediaQuery(context, "h", 15),
                    ),
                    Row(
                      children: <Widget>[
                        _buildTextField(context, highValue),
                      ],
                    ),
                    SizedBox(
                      height: mediaQuery(context, "h", 15),
                    ),
                    _buildTextMenu(
                        context, AppStrings.CustomerProp_AverageValue),
                    SizedBox(
                      height: mediaQuery(context, "h", 15),
                    ),
                    Row(
                      children: <Widget>[
                        _buildTextField(context, averageValue),
                      ],
                    ),
                    SizedBox(
                      height: mediaQuery(context, "h", 15),
                    ),
                    _buildTextMenu(
                        context, AppStrings.CustomerProp_KeyAccountStatus),
                    SizedBox(
                      height: mediaQuery(context, "h", 15),
                    ),
                    Row(
                      children: <Widget>[
                        _buildTextField(context, keyStatus),
                      ],
                    ),
                    SizedBox(
                      height: mediaQuery(context, "h", 15),
                    ),
                    _buildTextMenu(
                        context, AppStrings.CustomerProp_BusinessPartner),
                    SizedBox(
                      height: mediaQuery(context, "h", 15),
                    ),
                    Row(
                      children: <Widget>[
                        _buildTextField(context, businessPartner),
                      ],
                    ),
                    SizedBox(
                      height: mediaQuery(context, "h", 15),
                    ),
                    _buildTextMenu(context, AppStrings.CustomerProp_Website),
                    SizedBox(
                      height: mediaQuery(context, "h", 15),
                    ),
                    Row(
                      children: <Widget>[
                        _buildTextField(context, website),
                      ],
                    ),
                    SizedBox(
                      height: mediaQuery(context, "h", 15),
                    ),
                    Row(
                      mainAxisAlignment: MainAxisAlignment.start,
                      children: <Widget>[
                        Text(
                          "พิกัดสำนักงาน",
                          style: TextStyle(
                            fontWeight: FontWeight.bold,
                            fontSize: mediaQuery(context, 'h', 40),
                            color: AppColors.color,
                          ),
                          textAlign: TextAlign.center,
                        ),
                      ],
                    ),
                    SizedBox(
                      height: mediaQuery(context, "h", 15),
                    ),
                    SizedBox(
                      height: mediaQuery(context, "h", 15),
                    ),
                    Row(
                      mainAxisAlignment: MainAxisAlignment.spaceAround,
                      children: <Widget>[
                        Text(
                          AppStrings.CustomerProp_Latitude + " :",
                          style: TextStyle(
                            fontSize: mediaQuery(context, 'h', 40),
                            color: AppColors.Black,
                          ),
                          textAlign: TextAlign.center,
                        ),
                        Text(
                          AppStrings.CustomerProp_Longitude + " :",
                          style: TextStyle(
                            fontSize: mediaQuery(context, 'h', 40),
                            color: AppColors.Black,
                          ),
                          textAlign: TextAlign.center,
                        ),
                      ],
                    ),
                    Row(
                      mainAxisAlignment: MainAxisAlignment.spaceEvenly,
                      children: <Widget>[
                        Container(
                          height: mediaQuery(context, 'h', 105),
                          width: mediaQuery(context, 'w', 490),
                          child: Stack(
                            children: <Widget>[
                              TextField(
                                enabled: false,
                                controller: latitude,
                                decoration: InputDecoration(
                                  border: OutlineInputBorder(
                                    borderRadius: const BorderRadius.all(
                                      const Radius.circular(50.0),
                                    ),
                                  ),
                                  filled: true,
                                  counterText: "",
                                  contentPadding: EdgeInsets.fromLTRB(
                                      10.0, 0.0, 20.0, 10.0),
                                  hintStyle: TextStyle(color: Colors.grey[800]),
                                  fillColor: Colors.white70,
                                ),
                              ),
                            ],
                          ),
                        ),
                        Container(
                          height: mediaQuery(context, 'h', 105),
                          width: mediaQuery(context, 'w', 490),
                          child: Stack(
                            children: <Widget>[
                              TextField(
                                enabled: false,
                                controller: longitude,
                                decoration: InputDecoration(
                                  border: OutlineInputBorder(
                                    borderRadius: const BorderRadius.all(
                                      const Radius.circular(50.0),
                                    ),
                                  ),
                                  filled: true,
                                  counterText: "",
                                  contentPadding: EdgeInsets.fromLTRB(
                                      10.0, 0.0, 20.0, 10.0),
                                  hintStyle: TextStyle(color: Colors.grey[800]),
                                  fillColor: Colors.white70,
                                ),
                              ),
                            ],
                          ),
                        ),
                      ],
                    ),
                    SizedBox(
                      height: mediaQuery(context, "h", 15),
                    ),
                    Row(
                      children: <Widget>[
                        Stack(
                          children: <Widget>[
                            Container(
                              color: Colors.grey,
                              width: mediaQuery(context, 'w', 1005),
                              height: mediaQuery(context, "h", 665),
                              child: GoogleMap(
                                markers: Set.from(myMarker),
                                mapType: MapType.normal,
                                myLocationEnabled: true,
                                initialCameraPosition: CameraPosition(
                                  target: LatLng(
                                    double.parse(
                                      CustomerInfo.data.isNotEmpty
                                          ? CustomerInfo.data[0].latitude
                                          : "0.0",
                                    ),
                                    double.parse(
                                      CustomerInfo.data.isNotEmpty
                                          ? CustomerInfo.data[0].longitude
                                          : "0.0",
                                    ),
                                  ), //bangkok
                                  zoom: 15,
                                ),
                                myLocationButtonEnabled: true,
                              ),
                            ),
                          ],
                        ),
                      ],
                    ),
                    SizedBox(
                      height: mediaQuery(context, "h", 15),
                    ),
                    SizedBox(
                      height: mediaQuery(context, "h", 15),
                    ),
                    Row(
                      mainAxisAlignment: MainAxisAlignment.start,
                      children: <Widget>[
                        Text(
                          AppStrings.CustomerProp_industrialArea,
                          style: TextStyle(
                            fontWeight: FontWeight.bold,
                            fontSize: mediaQuery(context, 'h', 40),
                            color: AppColors.color,
                          ),
                          textAlign: TextAlign.center,
                        ),
                      ],
                    ),
                    _buildRadioIndustrialArea1(context, "ในเขตอุตสาหกรรม"),
                    Row(
                      children: <Widget>[
                        _buildTextField(context, inIndustry),
                      ],
                    ),
                    SizedBox(
                      height: mediaQuery(context, "h", 15),
                    ),
                    SizedBox(
                      height: mediaQuery(context, "h", 15),
                    ),
                    _buildRadioIndustrialArea2(context, "นอกเขตอุตสาหกรรม"),
                    _buildRadioIndustrialArea3(context, "ไม่ระบุ"),
                    SizedBox(
                      height: mediaQuery(context, "h", 15),
                    ),
                    SizedBox(
                      height: mediaQuery(context, "h", 15),
                    ),
                    Row(
                      mainAxisAlignment: MainAxisAlignment.start,
                      children: <Widget>[
                        Text(
                          AppStrings.CustomerProp_RuralArea,
                          style: TextStyle(
                            fontWeight: FontWeight.bold,
                            fontSize: mediaQuery(context, 'h', 40),
                            color: AppColors.color,
                          ),
                          textAlign: TextAlign.center,
                        ),
                      ],
                    ),
                    _buildRadioRuralArea1(context, "เขตเมือง"),
                    _buildRadioRuralArea2(
                        context, AppStrings.CustomerProp_RuralArea_),
                    _buildRadioRuralArea3(context, "ไม่ระบุ"),
                    SizedBox(
                      height: mediaQuery(context, "h", 15),
                    ),
                    Row(
                      mainAxisAlignment: MainAxisAlignment.start,
                      children: <Widget>[
                        Text(
                          AppStrings.CustomerProp_MainGroupFeatures,
                          style: TextStyle(
                            fontWeight: FontWeight.bold,
                            fontSize: mediaQuery(context, 'h', 40),
                            color: AppColors.color,
                          ),
                          textAlign: TextAlign.center,
                        ),
                      ],
                    ),
                    _buildRow1(context, AppStrings.CustomerProp_PressureLevel),
                    _buildRow2(
                        context, AppStrings.CustomerProp_AverageElectPerMonth),
                    _buildRow3(
                        context, AppStrings.CustomerProp_RiskGroupLosingIncome),
                    _buildRow4(context, AppStrings.CustomerProp_Supplementary),
                    _buildRow5(context, AppStrings.CustomerProp_HavePotential),
                    _buildRow6(context, AppStrings.CustomerProp_nationwide),
                    SizedBox(
                      height: mediaQuery(context, "h", 15),
                    ),
                    Row(
                      mainAxisAlignment: MainAxisAlignment.start,
                      children: <Widget>[
                        Text(
                          AppStrings.CustomerProp_SecondaryGroupFeature,
                          style: TextStyle(
                            fontWeight: FontWeight.bold,
                            fontSize: mediaQuery(context, 'h', 40),
                            color: AppColors.color,
                          ),
                          textAlign: TextAlign.center,
                        ),
                      ],
                    ),
                    _buildRow8(context, AppStrings.CustomerProp_ResponseGroup),
                    _buildRow9(
                        context, AppStrings.CustomerProp_CustomersHighDamage),
                    _buildRow10(
                        context, AppStrings.CustomerProp_ExistingCustomers),
                    SizedBox(
                      height: mediaQuery(context, "h", 35),
                    ),
                    SizedBox(
                      height: mediaQuery(context, "h", 100),
                    ),
                  ],
                ),
              ),
            ),
          ],
        ),
      ),
    );
  }

  _buildTextField(context, controller) {
    return Container(
      height: mediaQuery(context, 'h', 110),
      width: mediaQuery(context, 'w', 1005),
      child: TextField(
        textAlign: TextAlign.left,
        style: TextStyle(
          fontSize: mediaQuery(context, "h", 40),
        ),
        enabled: false,
        controller: controller,
        decoration: InputDecoration(
          border: OutlineInputBorder(
            borderRadius: const BorderRadius.all(
              const Radius.circular(50.0),
            ),
          ),
          filled: true,
          counterText: "",
          contentPadding: EdgeInsets.fromLTRB(10.0, 0.0, 20.0, 10.0),
          hintStyle: TextStyle(color: Colors.grey[800]),
          fillColor: Colors.white70,
        ),
      ),
    );
  }

  _buildRow1(context, text) {
    return Row(
      children: <Widget>[
        SizedBox(
          height: mediaQuery(context, 'h', 80),
          child: Checkbox(
            value: monVal,
            onChanged: null,
          ),
        ),
        Text(
          text,
          style: TextStyle(
            fontWeight: FontWeight.bold,
            fontSize: mediaQuery(context, 'h', AppFontSize.label),
            color: AppColors.Black,
          ),
          textAlign: TextAlign.center,
        ),
      ],
    );
  }

  _buildRow2(context, text) {
    return Row(
      children: <Widget>[
        SizedBox(
          height: mediaQuery(context, 'h', 80),
          child: Checkbox(
            value: monVal2,
            onChanged: null,
          ),
        ),
        Text(
          text,
          style: TextStyle(
            fontWeight: FontWeight.bold,
            fontSize: mediaQuery(context, 'h', AppFontSize.label),
            color: AppColors.Black,
          ),
          textAlign: TextAlign.center,
        ),
      ],
    );
  }

  _buildRow3(context, text) {
    return Row(
      children: <Widget>[
        SizedBox(
          height: mediaQuery(context, 'h', 80),
          child: Checkbox(
            value: monVal3,
            onChanged: null,
          ),
        ),
        Text(
          text,
          style: TextStyle(
            fontWeight: FontWeight.bold,
            fontSize: mediaQuery(context, 'h', AppFontSize.label),
            color: AppColors.Black,
          ),
          textAlign: TextAlign.center,
        ),
      ],
    );
  }

  _buildRow4(context, text) {
    return Row(
      children: <Widget>[
        SizedBox(
          height: mediaQuery(context, 'h', 80),
          child: Checkbox(
            value: monVal4,
            onChanged: null,
          ),
        ),
        Text(
          text,
          style: TextStyle(
            fontWeight: FontWeight.bold,
            fontSize: mediaQuery(context, 'h', AppFontSize.label),
            color: AppColors.Black,
          ),
          textAlign: TextAlign.center,
        ),
      ],
    );
  }

  _buildRow5(context, text) {
    return Row(
      children: <Widget>[
        SizedBox(
          height: mediaQuery(context, 'h', 80),
          child: Checkbox(
            value: monVal5,
            onChanged: null,
          ),
        ),
        Text(
          text,
          style: TextStyle(
            fontWeight: FontWeight.bold,
            fontSize: mediaQuery(context, 'h', AppFontSize.label),
            color: AppColors.Black,
          ),
          textAlign: TextAlign.center,
        ),
      ],
    );
  }

  _buildRow6(context, text) {
    return Row(
      children: <Widget>[
        SizedBox(
          height: mediaQuery(context, 'h', 80),
          child: Checkbox(
            value: monVal6,
            onChanged: null,
          ),
        ),
        Text(
          text,
          style: TextStyle(
            fontWeight: FontWeight.bold,
            fontSize: mediaQuery(context, 'h', AppFontSize.label),
            color: AppColors.Black,
          ),
          textAlign: TextAlign.center,
        ),
      ],
    );
  }

  _buildRow8(context, text) {
    return Row(
      children: <Widget>[
        SizedBox(
          height: mediaQuery(context, 'h', 80),
          child: Checkbox(
            value: monVal8,
            onChanged: null,
          ),
        ),
        Text(
          text,
          style: TextStyle(
            fontWeight: FontWeight.bold,
            fontSize: mediaQuery(context, 'h', AppFontSize.label),
            color: AppColors.Black,
          ),
          textAlign: TextAlign.center,
        ),
      ],
    );
  }

  _buildRow9(context, text) {
    return Row(
      children: <Widget>[
        SizedBox(
          height: mediaQuery(context, 'h', 80),
          child: Checkbox(
            value: monVal9,
            onChanged: null,
          ),
        ),
        Text(
          text,
          style: TextStyle(
            fontWeight: FontWeight.bold,
            fontSize: mediaQuery(context, 'h', AppFontSize.label),
            color: AppColors.Black,
          ),
          textAlign: TextAlign.center,
        ),
      ],
    );
  }

  _buildRow10(context, text) {
    return Row(
      children: <Widget>[
        SizedBox(
          height: mediaQuery(context, 'h', 80),
          child: Checkbox(
            value: monVal10,
            onChanged: null,
          ),
        ),
        Text(
          text,
          style: TextStyle(
            fontWeight: FontWeight.bold,
            fontSize: mediaQuery(context, 'h', AppFontSize.label),
            color: AppColors.Black,
          ),
          textAlign: TextAlign.center,
        ),
      ],
    );
  }

  _buildRadioIndustrialArea1(context, text) {
    return Row(
      mainAxisAlignment: MainAxisAlignment.start,
      children: <Widget>[
        SizedBox(
          height: mediaQuery(context, 'h', 80),
          child: Radio(
            value: 1,
            groupValue: radioIndustrialArea,
            onChanged: null,
          ),
        ),
        Text(
          text,
          style: TextStyle(
            fontSize: mediaQuery(context, 'h', AppFontSize.label),
            color: AppColors.Black,
          ),
          textAlign: TextAlign.center,
        ),
      ],
    );
  }

  _buildRadioIndustrialArea2(context, text) {
    return Row(
      mainAxisAlignment: MainAxisAlignment.start,
      children: <Widget>[
        SizedBox(
          height: mediaQuery(context, 'h', 80),
          child: Radio(
            value: 2,
            groupValue: radioIndustrialArea,
            onChanged: null,
          ),
        ),
        Text(
          text,
          style: TextStyle(
            fontSize: mediaQuery(context, 'h', AppFontSize.label),
            color: AppColors.Black,
          ),
          textAlign: TextAlign.center,
        ),
      ],
    );
  }

  _buildRadioIndustrialArea3(context, text) {
    return Row(
      mainAxisAlignment: MainAxisAlignment.start,
      children: <Widget>[
        SizedBox(
          height: mediaQuery(context, 'h', 80),
          child: Radio(
            value: 3,
            groupValue: radioIndustrialArea,
            onChanged: null,
          ),
        ),
        Text(
          text,
          style: TextStyle(
            fontSize: mediaQuery(context, 'h', AppFontSize.label),
            color: AppColors.Black,
          ),
          textAlign: TextAlign.center,
        ),
      ],
    );
  }

  _buildRadioRuralArea1(context, text) {
    return Row(
      mainAxisAlignment: MainAxisAlignment.start,
      children: <Widget>[
        SizedBox(
          height: mediaQuery(context, 'h', 80),
          child: Radio(
            value: 1,
            groupValue: radioRuralArea,
            onChanged: null,
          ),
        ),
        Text(
          text,
          style: TextStyle(
            fontSize: mediaQuery(context, 'h', AppFontSize.label),
            color: AppColors.Black,
          ),
          textAlign: TextAlign.center,
        ),
      ],
    );
  }

  _buildRadioRuralArea2(context, text) {
    return Row(
      mainAxisAlignment: MainAxisAlignment.start,
      children: <Widget>[
        SizedBox(
          height: mediaQuery(context, 'h', 80),
          child: Radio(
            value: 2,
            groupValue: radioRuralArea,
            onChanged: null,
          ),
        ),
        Text(
          text,
          style: TextStyle(
            fontSize: mediaQuery(context, 'h', AppFontSize.label),
            color: AppColors.Black,
          ),
          textAlign: TextAlign.center,
        ),
      ],
    );
  }

  _buildRadioRuralArea3(context, text) {
    return Row(
      mainAxisAlignment: MainAxisAlignment.start,
      children: <Widget>[
        SizedBox(
          height: mediaQuery(context, 'h', 80),
          child: Radio(
            value: 3,
            groupValue: radioRuralArea,
            onChanged: null,
          ),
        ),
        Text(
          text,
          style: TextStyle(
            fontSize: mediaQuery(context, 'h', AppFontSize.label),
            color: AppColors.Black,
          ),
          textAlign: TextAlign.center,
        ),
      ],
    );
  }

  _buildTextMenu(context, text) {
    return Row(
      mainAxisAlignment: MainAxisAlignment.start,
      children: <Widget>[
        Text(
          text + " :",
          style: TextStyle(
            fontSize: mediaQuery(context, 'h', AppFontSize.label),
            color: AppColors.color,
          ),
          textAlign: TextAlign.center,
        ),
      ],
    );
  }

//  ฟังชั่นบันทึก
  saveCustomerPropertyEdit(context) async {
    List<dynamic> checkNull = [
      customerGroup.text,
      highValue.text,
      averageValue.text,
      keyStatus.text,
      businessPartner.text,
      transformSize.text,
      website.text,
      latitude.text,
      longitude.text,
      inIndustry.text
    ];
    bool checkNullForm = await checkForm(checkNull);
    if (checkNullForm) {
      Map<String, dynamic> data = {
        "customerGroup": customerGroup.text, //กลุ่มลูกค้า
        "highValue": highValue.text, // highValue
        "value": averageValue.text, //มูลค่าเฉลี่ย
        "keyAccountStatus": keyStatus.text, //สถานะ key account
        "businessPartner": businessPartner.text, //Business Partner
        "sizeoftransformer": transformSize.text, // ขนาดหม้อแปลง
        "website": website.text, // website
        "latitude": latitude.text, // latitude
        "longtitude": longitude.text, // longitude
        "industrialarea": inIndustry.text, // เชตอุตสาหกรรม
      };
      await CustomerInfo.saveData(context, data);
    } else {
      alertForm(context, "แจ้งเตือน", "กรอกข้อมูลไม่ครบ");
    }
  }
} //class
