import 'package:flutter/material.dart';
import 'package:mwf_app/service/assets.dart';
import 'package:mwf_app/service/navigator.dart';
import 'package:mwf_app/service/screen.dart';
import 'package:mwf_app/service/strings.dart';
import 'package:mwf_app/set1/schedule.dart';
import 'package:mwf_app/set2/notification.dart';
import 'package:mwf_app/set7/chat_home.dart';
import 'package:mwf_app/home.dart';

class BottomMenuLandScape extends StatefulWidget {
  @override
  _BottomMenuLandScape createState() => _BottomMenuLandScape();
}

String currentPage = 'home';

class _BottomMenuLandScape extends State<BottomMenuLandScape> {
  @override
  Widget build(BuildContext context) {
    return Row(
      mainAxisAlignment: MainAxisAlignment.spaceEvenly,
      crossAxisAlignment: CrossAxisAlignment.start,
      children: <Widget>[
        homeIcon(),
        alertIcon(),
        chatIcon(),
        scheduleIcon(),
      ],
    );
  }

  homeIcon() {
    if (currentPage == 'home') {
      return GestureDetector(
        onTap: () {
          setState(() {
            currentPage = 'home';
          });
          print(currentPage);
          Nav.push(
            context,
            HomePage(),
          );
        },
        child: Container(
          width: mediaQuery(context, 'w', 200),
          height: mediaQuery(context, 'h', 210),
          decoration: BoxDecoration(
            borderRadius: new BorderRadius.only(
              bottomLeft: Radius.circular(
                mediaQuery(context, 'h', 20),
              ),
              bottomRight: Radius.circular(
                mediaQuery(context, 'h', 20),
              ),
            ),
            color: Colors.white,
          ),
          child: Container(
            margin: EdgeInsets.only(
              top: mediaQuery(context, 'h', 20),
            ),
            child: Column(
              mainAxisAlignment: MainAxisAlignment.center,
              children: <Widget>[
                Image.asset(
                  AppAssets.bottomMenu_home_purple,
                  width: mediaQuery(context, 'w', 98),
                  height: mediaQuery(context, 'h', 98),
                ),
                SizedBox(
                  height: mediaQuery(context, 'h', 14.4),
                ),
                Text(
                  AppStrings.menu_home,
                  style: TextStyle(
                    fontSize: mediaQuery(context, 'h', 43),
                    color: Color(0xFF7F3F98),
                  ),
                )
              ],
            ),
          ),
        ),
      );
    } else {
      return GestureDetector(
        onTap: () {
          setState(() {
            currentPage = 'home';
          });
          print(currentPage);
          Nav.push(
            context,
            HomePage(),
          );
        },
        child: Container(
          color: Colors.transparent,
          width: mediaQuery(context, 'w', 200),
          height: mediaQuery(context, 'h', 210),
          child: Container(
            margin: EdgeInsets.only(
              top: mediaQuery(context, 'h', 35),
            ),
            child: Column(
              mainAxisAlignment: MainAxisAlignment.center,
              children: <Widget>[
                Image.asset(
                  AppAssets.bottomMenu_home_white,
                  width: mediaQuery(context, 'w', 98),
                  height: mediaQuery(context, 'h', 98),
                ),
                SizedBox(
                  height: mediaQuery(context, 'h', 14),
                ),
                Text(
                  AppStrings.menu_home,
                  style: TextStyle(
                    fontSize: mediaQuery(context, 'h', 43),
                    color: Colors.white,
                  ),
                )
              ],
            ),
          ),
        ),
      );
    }
  }

  alertIcon() {
    if (currentPage == 'alert') {
      return GestureDetector(
        onTap: () {
          setState(() {
            currentPage = 'alert';
          });
          print(currentPage);
          Nav.push(
            context,
            NotificationPage(),
          );
        },
        child: Container(
          width: mediaQuery(context, 'w', 200),
          height: mediaQuery(context, 'h', 210),
          decoration: BoxDecoration(
            borderRadius: new BorderRadius.only(
              bottomLeft: Radius.circular(
                mediaQuery(context, 'h', 20),
              ),
              bottomRight: Radius.circular(
                mediaQuery(context, 'h', 20),
              ),
            ),
            color: Colors.white,
          ),
          child: Container(
            margin: EdgeInsets.only(
              top: mediaQuery(context, 'h', 35),
            ),
            child: GestureDetector(
              onTap: () {
                setState(() {
                  currentPage = 'alert';
                });
                print(currentPage);
                Nav.push(
                  context,
                  NotificationPage(),
                );
              },
              child: Column(
                mainAxisAlignment: MainAxisAlignment.center,
                children: <Widget>[
                  Image.asset(
                    AppAssets.bottomMenu_alert_purple,
                    width: mediaQuery(context, 'w', 98),
                    height: mediaQuery(context, 'h', 98),
                  ),
                  SizedBox(
                    height: mediaQuery(context, 'h', 13.8),
                  ),
                  Text(
                    AppStrings.menu_alert,
                    style: TextStyle(
                      fontSize: mediaQuery(context, 'h', 43),
                      color: Color(0xFF7F3F98),
                    ),
                  )
                ],
              ),
            ),
          ),
        ),
      );
    } else {
      return GestureDetector(
        onTap: () {
          setState(() {
            currentPage = 'alert';
          });
          print(currentPage);
          Nav.push(
            context,
            NotificationPage(),
          );
        },
        child: Container(
          color: Colors.transparent,
          width: mediaQuery(context, 'w', 200),
          height: mediaQuery(context, 'h', 210),
          child: Container(
            margin: EdgeInsets.only(
              top: mediaQuery(context, 'h', 35),
            ),
            child: Column(
              mainAxisAlignment: MainAxisAlignment.center,
              children: <Widget>[
                Image.asset(
                  AppAssets.bottomMenu_alert_white,
                  width: mediaQuery(context, 'w', 90),
                  height: mediaQuery(context, 'h', 90),
                ),
                SizedBox(
                  height: mediaQuery(context, 'h', 13.8),
                ),
                Text(
                  AppStrings.menu_alert,
                  style: TextStyle(
                    fontSize: mediaQuery(context, 'h', 45),
                    color: Colors.white,
                  ),
                )
              ],
            ),
          ),
        ),
      );
    }
  }

  chatIcon() {
    if (currentPage == 'chat') {
      return GestureDetector(
        onTap: () {
          setState(() {
            currentPage = 'chat';
          });
          print(currentPage);
          Nav.push(
            context,
            Chathome(),
          );
        },
        child: Container(
          width: mediaQuery(context, 'w', 200),
          height: mediaQuery(context, 'h', 210),
          decoration: BoxDecoration(
            borderRadius: new BorderRadius.only(
              bottomLeft: Radius.circular(
                mediaQuery(context, 'h', 20),
              ),
              bottomRight: Radius.circular(
                mediaQuery(context, 'h', 20),
              ),
            ),
            color: Colors.white,
          ),
          child: Container(
            margin: EdgeInsets.only(
              top: mediaQuery(context, 'h', 40),
            ),
            child: Column(
              children: <Widget>[
                Image.asset(
                  AppAssets.bottomMenu_chat_purple,
                  width: mediaQuery(context, 'w', 90),
                  height: mediaQuery(context, 'h', 90),
                ),
                SizedBox(
                  height: mediaQuery(context, 'h', 12.9),
                ),
                Text(
                  AppStrings.menu_chat,
                  style: TextStyle(
                    fontSize: mediaQuery(context, 'h', 43),
                    color: Color(0xFF7F3F98),
                  ),
                )
              ],
            ),
          ),
        ),
      );
    } else {
      return GestureDetector(
        onTap: () {
          setState(() {
            currentPage = 'chat';
          });
          print(currentPage);
          Nav.push(
            context,
            Chathome(),
          );
        },
        child: Container(
          color: Colors.transparent,
          width: mediaQuery(context, 'w', 200),
          height: mediaQuery(context, 'h', 200),
          child: Container(
            margin: EdgeInsets.only(
              top: mediaQuery(context, 'h', 40),
            ),
            child: Column(
              children: <Widget>[
                Image.asset(
                  AppAssets.bottomMenu_chat_white,
                  width: mediaQuery(context, 'w', 90),
                  height: mediaQuery(context, 'h', 90),
                ),
                SizedBox(
                  height: mediaQuery(context, 'h', 5),
                ),
                Text(
                  AppStrings.menu_chat,
                  style: TextStyle(
                    fontSize: mediaQuery(context, 'h', 43),
                    color: Colors.white,
                  ),
                )
              ],
            ),
          ),
        ),
      );
    }
  }

  scheduleIcon() {
    if (currentPage == 'schedule') {
      return GestureDetector(
        onTap: () {
          setState(() {
            currentPage = 'schedule';
          });
          print(currentPage);
          Nav.push(
            context,
            Schedule(),
          );
        },
        child: Container(
          width: mediaQuery(context, 'w', 200),
          height: mediaQuery(context, 'h', 210),
          padding: EdgeInsets.only(
            top: mediaQuery(context, 'h', 40),
          ),
          decoration: BoxDecoration(
            borderRadius: new BorderRadius.only(
              bottomLeft: Radius.circular(
                mediaQuery(context, 'h', 20),
              ),
              bottomRight: Radius.circular(
                mediaQuery(context, 'h', 20),
              ),
            ),
            color: Colors.white,
          ),
          child: Column(
            mainAxisAlignment: MainAxisAlignment.center,
            children: <Widget>[
              Image.asset(
                AppAssets.bottomMenu_calendar_purple,
                width: mediaQuery(context, 'w', 90),
                height: mediaQuery(context, 'h', 90),
              ),
              SizedBox(
                height: mediaQuery(context, 'h', 13.8),
              ),
              Text(
                AppStrings.menu_schedule,
                style: TextStyle(
                  fontSize: mediaQuery(context, 'h', 43),
                  color: Color(0xFF7F3F98),
                ),
              )
            ],
          ),
        ),
      );
    } else {
      return GestureDetector(
        onTap: () {
          setState(() {
            currentPage = 'schedule';
          });
          print(currentPage);
          Nav.push(
            context,
            Schedule(),
          );
        },
        child: Container(
          color: Colors.transparent,
          width: mediaQuery(context, 'w', 200),
          height: mediaQuery(context, 'h', 210),
          padding: EdgeInsets.only(
            top: mediaQuery(context, 'h', 40),
          ),
          child: Column(
            mainAxisAlignment: MainAxisAlignment.center,
            children: <Widget>[
              Image.asset(
                AppAssets.bottomMenu_calendar_white,
                width: mediaQuery(context, 'w', 90),
                height: mediaQuery(context, 'h', 90),
              ),
              SizedBox(
                height: mediaQuery(context, 'h', 13.8),
              ),
              Text(
                AppStrings.menu_schedule,
                style: TextStyle(
                  fontSize: mediaQuery(context, 'h', 43),
                  color: Colors.white,
                ),
              )
            ],
          ),
        ),
      );
    }
  }
}
