import 'package:mwf_app/service/api.dart';
import 'package:mwf_app/service/url.dart';

class VoiceSuggestion {
  String id;
  String suggestion;

  VoiceSuggestion({
    this.id,
    this.suggestion,
  });

  static getData() async {
    final response = await AppApi.apiGetRequest(
      AppUrl.Voice_Suggestion_ReadList +
          "?Id=" +
          AppUrl.Id +
          "&AuthenKey=" +
          AppUrl.AuthenKey,
    ); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static saveData(context, Map<String, dynamic> data) async {
    final response =
        await AppApi.post(AppUrl.Voice_Suggestion_Create, data); // เรียกใช้ api
    print(response);
    if (response['statusCode'] == 200) {
      //Nav.push(context, Schedule());
    }
  }

  static deleteData(
    context,
    String id,
  ) async {
    Map<String, dynamic> data = {"Id": id, "AuthenKey": AppUrl.AuthenKey};
    final response =
        await AppApi.post(AppUrl.Voice_Suggestion_Delete, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static updateData(
    context,
    String id,
    String suggestion,
  ) async {
    Map<String, dynamic> data = {
      "Id": id,
      "Suggestion": suggestion,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response =
        await AppApi.post(AppUrl.Voice_Suggestion_Update, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static List<VoiceSuggestion> data = []; // ตัวแปรที่จะเรียกใช้งาน

  VoiceSuggestion.fromJson(Map<String, dynamic> json) {
    id = json['Id'];
    suggestion = json['Suggestion'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['Id'] = this.id;
    data['Suggestion'] = this.suggestion;
    return data;
  }
}
