import 'package:flutter/material.dart';
import 'package:flutter/widgets.dart';
import 'package:mwf_app/service/api.dart';
import 'package:mwf_app/service/url.dart';
import 'package:mwf_app/service/loader.dart';
import 'package:mwf_app/set2/visiting_plan_list.dart';

class ListProblme {
  String categoryProblemId;
  String categoryProblem;

  ListProblme(
    this.categoryProblemId,
    this.categoryProblem,
  );
}

class ListDocumentFile {
  String uploadFileVisitId; //guid
  String userFileName; //string
  String fileDescription; //string
  int fileSize; //int
  String fileContent; //"base64Binary
  String fileUrl;

  ListDocumentFile(
    this.uploadFileVisitId,
    this.userFileName,
    this.fileDescription,
    this.fileSize,
    this.fileContent,
    this.fileUrl,
  );
}

class VisitIdClass {
  String visitId;

  VisitIdClass(this.visitId);
}

class VisitPlan {
  String visitId;
  String visitPlanDate;
  String visitObjective;
  String visitTeamPosition;
  String visitStatus;
  String customerId;
  String authenKey;

  VisitPlan({
    this.visitId,
    this.visitPlanDate,
    this.visitObjective,
    this.visitTeamPosition,
    this.visitStatus,
    this.customerId,
    this.authenKey,
  });

  VisitPlan.fromJson(Map<String, dynamic> json) {
    visitId = json['VisitId'];
    visitPlanDate = json['VisitPlanDate'];
    visitObjective = json['VisitObjective'];
    visitTeamPosition = json['VisitTeamPosition'];
    visitStatus = json['VisitStatus'];
    customerId = json['customerId'];
    authenKey = json['authenKey'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = Map<String, dynamic>();
    data['VisitId'] = this.visitId;
    data['VisitPlanDate'] = this.visitPlanDate;
    data['VisitObjective'] = this.visitObjective;
    data['VisitTeamPosition'] = this.visitTeamPosition;
    data['VisitStatus'] = this.visitStatus;
    data['customerId'] = this.customerId;
    data['authenKey'] = this.authenKey;
    return data;
  }
}

class DataListProb {
  String categoryProblemId;
  String categoryProblem;

  DataListProb({
    this.categoryProblemId,
    this.categoryProblem,
  });

  static getDataListProb() async {
    final response = await AppApi.apiGetRequest(
      AppUrl.CategoryProblem_ReadList + "?AuthenKey=" + AppUrl.AuthenKey,
    ); // เรียกใช้ api

    return response;
  }
}

class DataListVisitOBJ {
  String visitObjectiveId;
  String visitObjectiveName;

  DataListVisitOBJ({
    this.visitObjectiveId,
    this.visitObjectiveName,
  });

  static getDataListVitsitOBJ() async {
    final response = await AppApi.apiGetRequest(
      AppUrl.VisitObjectiveList + "?AuthenKey=" + AppUrl.AuthenKey,
    ); // เรียกใช้ api

    return response;
  }
}

class VisitPlanCreate {
  String visitId;
  String customerId;
  String employeeId;
  String customerName;
  String ca;
  String customerAddress;
  String tsicID;
  String tsicName;
  String branchID;
  String branchname;
  String visitDate;
  String purposeVisit;
  String employeename;
  String employeePosition;
  String authenKey;
  String visit;
  String employeeSurname;
  String visitPlanDate;
  String proposeTypeID;
  String proposeTypename;
  String description;
  String pathfilename;
  String attacthfile;
  String filesname;
  String visitObjective;
  String visitTeamPosition;
  String visitStatus;
  String visitObjectiveId;
  String planDateStart;
  String planDateEnd;
  String visitPlanEndDate;
  String visitPlanStartDate;
  dynamic visitTeamInfo;
  String visitTeamId;
  String detailProblem;
  String processDetail;
  String statusSolvingProblem;
  dynamic categoryProblemInfo;
  dynamic visitDocumentInfo;
  String visitNumber;
  String visitYear;

  VisitPlanCreate({
    this.visitId,
    this.customerId,
    this.employeeId,
    this.customerName,
    this.ca,
    this.customerAddress,
    this.tsicID,
    this.tsicName,
    this.branchID,
    this.branchname,
    this.visitDate,
    this.purposeVisit,
    this.employeename,
    this.employeePosition,
    this.authenKey,
    this.visit,
    this.employeeSurname,
    this.visitPlanDate,
    this.proposeTypeID,
    this.proposeTypename,
    this.description,
    this.pathfilename,
    this.attacthfile,
    this.filesname,
    this.visitObjective,
    this.visitTeamPosition,
    this.visitStatus,
    this.visitObjectiveId,
    this.planDateStart,
    this.planDateEnd,
    this.visitPlanStartDate,
    this.visitPlanEndDate,
    this.visitTeamInfo,
    this.visitTeamId,
    this.detailProblem,
    this.statusSolvingProblem,
    this.visitDocumentInfo,
    this.categoryProblemInfo,
    this.processDetail,
  });

  static getData() async {
    final response = await AppApi.apiGetRequest(
      AppUrl.VisitPlan_ReadList +
          "?CustomerID=" +
          AppUrl.CustomerID +
          "&AuthenKey=" +
          AppUrl.AuthenKey,
    ); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static getVisitNumber(String customerID) async {
    final response = await AppApi.apiGetRequest(
      AppUrl.GetVisitNumber +
          "?customerId=" +
          customerID +
          "&AuthenKey=" +
          AppUrl.AuthenKey,
    ); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static getDataEdit(String visitID) async {
    final response = await AppApi.apiGetRequest(AppUrl.VisitPlan_Read +
        "?VisitID=" +
        visitID +
        "&AuthenKey=" +
        AppUrl.AuthenKey); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

//=============================================================================
//                          VisitResult_Update
//=============================================================================

  static visitResultUpdate(context, data) async {
    print(AppUrl.VisitResult_Update);
    final response = await AppApi.postString(AppUrl.VisitResult_Update, data);
    print(response);
    if (response['statusCode'] == 200) {
      AppLoader.showSuccess('เพิ่มข้อมูลสำเร็จ');
      await Future.delayed(const Duration(milliseconds: 2000));
      Navigator.pushReplacement(
          context,
          MaterialPageRoute(
              builder: (context) => VisitingPlanList()));
    } else {
      AppLoader.showError('เพิ่มข้อมูลไม่สำเร็จ');
      //Nav.push(context, AddActivity(null));
    }

    data = "";
    return response;
  }

  //=============================================================================
  //
  //=============================================================================

  static saveData(context, data) async {
    print(data);
    final response =
        await AppApi.postString(AppUrl.VisitPlan_Create, data); // เรียกใช้ api
    print(response);
    if (response['Message'] != "") {
      AppLoader.showError('เพิ่มข้อมูลไม่สำเร็จ');
    } else {
      await Future.delayed(const Duration(milliseconds: 1000));
      AppLoader.showSuccess('เพิ่มข้อมูลสำเร็จ');
      await Future.delayed(const Duration(milliseconds: 1000));
      Navigator.pushReplacement(
          context,
          MaterialPageRoute(
              builder: (context) => VisitingPlanList()));
    }

    data = "";
    return response;
  }

  static visitPlanUpdate(context, data) async {
    final response =
        await AppApi.postString(AppUrl.VisitPlan_Update, data); // เรียกใช้ api

    print(response);
    if (response['Message'] != "") {
      AppLoader.showError('เพิ่มข้อมูลไม่สำเร็จ');
    } else {
      AppLoader.showSuccess('เพิ่มข้อมูลสำเร็จ');
      await Future.delayed(const Duration(milliseconds: 500));
      Navigator.pushReplacement(
          context,
          MaterialPageRoute(
              builder: (context) => VisitingPlanList()));
    }

    data = "";
    return response;
  }

  static deleteData(
    context,
    String visitID,
  ) async {
    final response = await AppApi.httpDelete(
      AppUrl.VisitPlan_Delete +
          "?VisitID=" +
          visitID +
          "&authenKey=" +
          AppUrl.AuthenKey,
    ); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static updateData(
    context,
    String customerId,
    String visitNumber,
    String visitYear,
    DateTime visitPlanStartDate,
    DateTime visitPlanEndDate,
    String companyRepresentativeFullName,
    String visitObjectiveId,
    String visitTeamId,
    String employeeNumber,
    String displayName,
    String positionTeam,
    String isLeader,
    String visitPlanCreateResult,
  ) async {
    Map<String, dynamic> data = {
      "VisitID": customerId,
      "CustomerID": visitNumber,
      "EmployeeID": visitYear,
      "CustomerName": visitPlanStartDate,
      "CA": visitPlanEndDate,
      "CustomerAddress": companyRepresentativeFullName,
      "TSICID": visitObjectiveId,
      "TSICName": visitTeamId,
      "BranchID": employeeNumber,
      "Branchname": displayName,
      "positionTeam": positionTeam,
      "PurposeVisit": isLeader,
      "Employeename": visitPlanCreateResult,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response =
        await AppApi.post(AppUrl.VisitPlan_Update, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static List<VisitPlanCreate> data = []; // ตัวแปรที่จะเรียกใช้งาน

  VisitPlanCreate.fromJson(Map<String, dynamic> json) {
    visitId = json['VisitId'];
    visitPlanDate = json['VisitPlanDate'].toString();
    visitObjective = json['VisitObjective'].toString();
    visitTeamPosition = json['VisitTeamPosition'].toString();
    visitObjectiveId = json['VisitObjectiveId'].toString();
    planDateStart = json['PlanDateStart'].toString();
    planDateEnd = json['PlanDateEnd'].toString();
    visitPlanStartDate = json['visitPlanStartDate'].toString();
    visitPlanEndDate = json['visitPlanEndDate'].toString();
    visitTeamInfo = json['VisitTeamInfo'];
    visitTeamId = json['VisitTeamId'];
    visitDate = json['VisitDate'];
    visitNumber = json['VisitNumber'];
    visitYear = json['VisitYear'];

    detailProblem = json['DetailProblem'];
    processDetail = json['ProcessDetail'];
    statusSolvingProblem = json['StatusSolvingProblem'];
    categoryProblemInfo = json['CategoryProblemInfo'];
    visitDocumentInfo = json['VisitDocumentInfo'];

    if (visitTeamPosition == "null") {
      visitTeamPosition = "-";
    }
    visitStatus = json['VisitStatus'].toString();
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = Map<String, dynamic>();
    data['VisitId'] = this.visitId;
    data['VisitPlanDate'] = this.visitPlanDate;
    data['VisitObjective'] = this.visitObjective;
    data['VisitTeamPosition'] = this.visitTeamPosition;
    data['VisitStatus'] = this.visitStatus;
    data['VisitObjectiveId'] = this.visitObjectiveId;
    data['PlanDateStart'] = this.planDateStart;
    data['PlanDateEnd'] = this.planDateEnd;
    data['VisitTeamInfo'] = this.visitTeamInfo;
    data['VisitTeamId'] = this.visitTeamId;
    data['VisitDate'] = this.visitDate;
    data['visitPlanStartDate'] = this.visitPlanStartDate;
    data['visitPlanEndDate'] = this.visitPlanEndDate;
    data['DetailProblem'] = this.detailProblem;
    data['ProcessDetail'] = this.processDetail;
    data['StatusSolvingProblem'] = this.statusSolvingProblem;
    data['CategoryProblemInfo'] = this.categoryProblemInfo;
    data['VisitDocumentInfo'] = this.visitDocumentInfo;
    data['VisitNumber'] = this.visitNumber;
    data['VisitYear'] = this.visitYear;

    return data;
  }
}

class VisitPlanInfo {
  String customerId;
  String visitNumber;
  String visitYear;
  String visitPlanStartDate;
  String visitPlanEndDate;
  String companyRepresentativeFullName;
  String visitObjectiveId;
  VisitTeam visitTeam;
  String authenKey;

  VisitPlanInfo({
    this.customerId,
    this.visitNumber,
    this.visitYear,
    this.visitPlanStartDate,
    this.visitPlanEndDate,
    this.companyRepresentativeFullName,
    this.visitObjectiveId,
    this.visitTeam,
    this.authenKey,
  });

  VisitPlanInfo.fromJson(Map<String, dynamic> json) {
    customerId = json['customerId'];
    visitNumber = json['visitNumber'];
    visitYear = json['visitYear'];
    visitPlanStartDate = json['visitPlanStartDate'];
    visitPlanEndDate = json['visitPlanEndDate'];
    companyRepresentativeFullName = json['companyRepresentativeFullName'];
    visitObjectiveId = json['visitObjectiveId'];
    visitTeam = json['visitTeam'] != null
        ? VisitTeam.fromJson(json['visitTeam'])
        : null;
    authenKey = json['authenKey'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = Map<String, dynamic>();
    data['customerId'] = this.customerId;
    data['visitNumber'] = this.visitNumber;
    data['visitYear'] = this.visitYear;
    data['visitPlanStartDate'] = this.visitPlanStartDate;
    data['visitPlanEndDate'] = this.visitPlanEndDate;
    data['companyRepresentativeFullName'] = this.companyRepresentativeFullName;
    data['visitObjectiveId'] = this.visitObjectiveId;
    if (this.visitTeam != null) {
      data['visitTeam'] = this.visitTeam.toJson();
    }
    data['authenKey'] = this.authenKey;
    return data;
  }
}

class VisitTeam {
  List<VisitTeamInfo> visitTeamInfo;

  VisitTeam({this.visitTeamInfo});

  VisitTeam.fromJson(Map<String, dynamic> json) {
    if (json['VisitTeamInfo'] != null) {
      visitTeamInfo = List<VisitTeamInfo>();
      json['VisitTeamInfo'].forEach((v) {
        visitTeamInfo.add(VisitTeamInfo.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = Map<String, dynamic>();
    if (this.visitTeamInfo != null) {
      data['VisitTeamInfo'] =
          this.visitTeamInfo.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class VisitTeamInfo {
  String visitTeamId;
  String employeeNumber;
  String displayName;
  String positionTeam;
  String isLeader;

  VisitTeamInfo({
    this.visitTeamId,
    this.employeeNumber,
    this.displayName,
    this.positionTeam,
    this.isLeader,
  });

  VisitTeamInfo.fromJson(Map<String, dynamic> json) {
    visitTeamId = json['VisitTeamId'];
    employeeNumber = json['EmployeeNumber'];
    displayName = json['DisplayName'];
    positionTeam = json['PositionTeam'];
    isLeader = json['IsLeader'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = Map<String, dynamic>();
    data['VisitTeamId'] = this.visitTeamId;
    data['EmployeeNumber'] = this.employeeNumber;
    data['DisplayName'] = this.displayName;
    data['PositionTeam'] = this.positionTeam;
    data['IsLeader'] = this.isLeader;
    return data;
  }
}
