import 'package:flutter/material.dart';
import 'package:flutter/widgets.dart';
import 'package:mwf_app/service/api.dart';
import 'package:mwf_app/service/loader.dart';
import 'package:mwf_app/service/url.dart';
import 'package:mwf_app/set3/offer_additional_list.dart';

class Package {
  String id;
  String pName;
  String pDetail;
  String pStatusType;
  String sequence;
  String status;
  String customerName;
  String startDate;
  String endDate;
  String createBy;
  String createDate;
  String updateBy;
  String updateDate;
  String strStartDate;
  String strEndDate;
  String strCreateDate;
  String strUpdateDate;
  var createTypeAccount;
  String prId;
  String imageFile;

  Package({
    this.id,
    this.pName,
    this.pDetail,
    this.pStatusType,
    this.sequence,
    this.status,
    this.customerName,
    this.startDate,
    this.endDate,
    this.createBy,
    this.createDate,
    this.updateBy,
    this.updateDate,
    this.strStartDate,
    this.strEndDate,
    this.strCreateDate,
    this.strUpdateDate,
    this.imageFile,
    this.createTypeAccount,
    this.prId,
  });

  static List<dynamic> requestAdditionalList = [
    {
      "packageID": "PK001",
      "packageName": "บริการล้างลูกถ้วย",
      "process": "อยู่ระหว่างการดำเนินการ",
      "ca": "0123456789",
      "customerName": "บริษัท สหการประมูล จำกัด (มหาชน)",
      "customerAddress":
          "518 ซอยรามคำแหง 39 แขวงวังทองหลาง เขตวังทองหลาง\nกรุงเทพมหานคร 10240",
    },
    {
      "packageID": "PK002",
      "packageName": "บริการล้างลูกถ้วย",
      "process": "อยู่ระหว่างการดำเนินการ",
      "ca": "0123456789",
      "customerName": "บริษัท สหการประมูล จำกัด (มหาชน)",
      "customerAddress":
          "518 ซอยรามคำแหง 39 แขวงวังทองหลาง เขตวังทองหลาง\nกรุงเทพมหานคร 10240",
    },
  ];

  static getData() async {
    print(AppUrl.Package_ReadList + "?AuthenKey=" + AppUrl.AuthenKey);
    final response = await AppApi.apiGetRequest(AppUrl.Package_ReadList +
        "?AuthenKey=" +
        AppUrl.AuthenKey); // เรียกใช้ api
    dataReadList.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static getDataReadList() async {
    final response = await AppApi.apiGetRequest(AppUrl.Package_ReadList +
        "?AuthenKey=" +
        AppUrl.AuthenKey); // เรียกใช้ api
    print(response);
    dataReadList.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static getDataPackageStatusList() async {
    final response = await AppApi.apiGetRequest(
        AppUrl.StatusServiceType_ReadList +
        "?AuthenKey=" + AppUrl.AuthenKey); // เรียกใช้ api
    print(AppUrl.StatusServiceType_ReadList +
        "?AuthenKey=" + AppUrl.AuthenKey);
    print(response);
    return response;
  }

  static saveData(context, Map<String, dynamic> data) async {
    final response =
        await AppApi.post(AppUrl.Package_Create, data); // เรียกใช้ api
    print(response);
    if (response['statusCode'] == 200) {
      //Nav.push(context, Schedule());
    }
  }

  static saveDataRequestCus(context, Map<String, dynamic> data) async {
    final response =
        await AppApi.post(AppUrl.Package_Create, data); // เรียกใช้ api
    print(response);
    if (response['statusCode'] == 200) {
      //Nav.push(context, Schedule());
    }
  }

  static packageRequestCreate(context, Map<String, dynamic> data) async {
    print(AppUrl.PackageRequest_Create);
    print(data);
    final response = await AppApi.postWithMap(
        AppUrl.PackageRequest_Create, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      AppLoader.showSuccess("บันทึกสำเร็จ");
      Navigator.pushReplacement(
          context,
          MaterialPageRoute(
              builder: (context) => OfferAdditionalList()));
    }
  }

  static packageRequestUpdate(context, Map<String, dynamic> data) async {
    final response =
        await AppApi.post(AppUrl.PackageRequest_Update, data); // เรียกใช้ api
    print(response);
    if (response['statusCode'] == 200) {
      AppLoader.showSuccess("บันทึกสำเร็จ");
    }
  }

  static packageRequestHistoryCreate(context, Map<String, dynamic> data) async {
    final response = await AppApi.post(
        AppUrl.PackageRequestHistory_Create, data); // เรียกใช้ api
    print(response);
    if (response['statusCode'] == 200) {
      AppLoader.showSuccess("บันทึกสำเร็จ");
    }
  }

  static deleteData(
    context,
    String id,
  ) async {
    Map<String, dynamic> data = {"Id": id, "AuthenKey": AppUrl.AuthenKey};
    final response =
        await AppApi.post(AppUrl.Package_Delete, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static updateData(
    context,
    String id,
    String pName,
    String pDetail,
    String pStatusType,
    DateTime startDate,
    DateTime endDate,
    String createBy,
    DateTime createDate,
    String updateBy,
    DateTime updateDate,
    String imageFile,
  ) async {
    Map<String, dynamic> data = {
      "Id": id,
      "P_Name": pName,
      "P_Detail": pDetail,
      "P_StatusType": pStatusType,
      "StartDate": startDate,
      "EndDate": endDate,
      "CreateBy": createBy,
      "CreateDate": createDate,
      "UpdateBy": updateBy,
      "UpdateDate": updateDate,
      "ImageFile": imageFile,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response =
        await AppApi.post(AppUrl.Package_Update, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static List<Package> data = []; // ตัวแปรที่จะเรียกใช้งาน
  static List<Package> dataReadList = []; // ตัวแปรหน้ารายการแสนอบริการเสริม
  Package.fromJson(Map<String, dynamic> json) {
    id = json['Id'];
    pName = json['P_Name'];
    pDetail = json['P_Detail'];
    pStatusType = json['P_StatusType'].toString();
    sequence = json['Sequence'].toString();
    status = json['Status'];
    customerName = json['CustomerName'].toString();
    startDate = json['StartDate'].toString();
    endDate = json['EndDate'].toString();
    createBy = json['CreateBy'];
    createDate = json['CreateDate'].toString();
    updateBy = json['UpdateBy'];
    updateDate = json['UpdateDate'].toString();
    createTypeAccount = json['CreateTypeAccount'].toString();
    strStartDate = json['strStartDate'];
    strEndDate = json['strEndDate'];
    strCreateDate = json['strCreateDate'];
    strUpdateDate = json['strUpdateDate'];
    imageFile = json['ImageFile'].toString();
    prId = json['PR_Id'].toString();

    if (imageFile.isEmpty) {
      imageFile = 'https://www.freeiconspng.com/uploads/no-image-icon-11.PNG';
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = Map<String, dynamic>();
    data['Id'] = this.id;
    data['P_Name'] = this.pName;
    data['P_Detail'] = this.pDetail;
    data['P_StatusType'] = this.pStatusType;
    data['Sequence'] = this.sequence;
    data['Status'] = this.status;
    data['CustomerName'] = this.customerName;
    data['StartDate'] = this.startDate;
    data['EndDate'] = this.endDate;
    data['CreateBy'] = this.createBy;
    data['CreateDate'] = this.createDate;
    data['UpdateBy'] = this.updateBy;
    data['UpdateDate'] = this.updateDate;
    data['strStartDate'] = this.strCreateDate;
    data['strEndDate'] = this.strEndDate;
    data['strCreateDate'] = this.strCreateDate;
    data['strUpdateDate'] = this.strUpdateDate;
    data['CreateTypeAccount'] = this.createTypeAccount;
    data['ImageFile'] = this.imageFile;

    return data;
  }
}
