import 'package:mwf_app/service/api.dart';
import 'package:mwf_app/service/url.dart';
import 'package:mwf_app/service/loader.dart';
import 'package:flutter/widgets.dart';

class MapLocation {
  String customerID;
  String mapID;
  dynamic longtitude;
  dynamic latitude;
  dynamic location;

  MapLocation({
    this.customerID,
    this.mapID,
    this.latitude,
    this.longtitude,
    this.location,
  });

  static getData() async {
    final response = await AppApi.apiGetRequest(
      AppUrl.MapLocation_Read +
          "?customerId=" +
          AppUrl.CustomerID +
          "&AuthenKey=" +
          AppUrl.AuthenKey,
    ); // เรียกใช้ api

    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static saveData(context, Map<String, dynamic> data) async {
    final response =
        await AppApi.post(AppUrl.MapLocation_Create, data); // เรียกใช้ api
    print(response);
    if (response['statusCode'] == 200) {
      //Nav.push(context, Schedule());
    }
  }

  static deleteData(
    context,
    String customerID,
  ) async {
    Map<String, dynamic> data = {
      "CustomerID": customerID,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response =
        await AppApi.post(AppUrl.MapLocation_Delete, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static updateData(
    context,
    //String customerID,
    //String mapID,
    String latitude,
    String longtitude,
    //String location,
  ) async {
    Map<String, dynamic> data = {
      "CustomerID": AppUrl.CustomerID,
      //"MapID": mapID,
      "Latitude": latitude,
      "Longtitude": longtitude,
      //"Location": location,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response =
        await AppApi.post2(AppUrl.MapLocation_Update, data); // เรียกใช้ api

    print(response);
    if (response['statusCode'] == 200) {
      AppLoader.showSuccess('บันทึกสำเร็จ');
      Navigator.pop(context);
      return "บันทึกสำเร็จ";
    } else {
      AppLoader.showError('บันทึกไม่สำเร็จ');
      return 'บันทึกไม่สำเร็จ';
    }
  }

  static List<MapLocation> data = []; // ตัวแปรที่จะเรียกใช้งาน

  MapLocation.fromJson(Map<String, dynamic> json) {
    customerID = json['CustomerID'];
    mapID = json['MapID'];
    latitude = json['Latitude'];
    longtitude = json['Longtitude'];
    location = json['Location'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['CustomerID'] = this.customerID;
    data['MapID'] = this.mapID;
    data['Latitude'] = this.latitude;
    data['Longtitude'] = this.longtitude;
    data['Location'] = this.location;
    return data;
  }
}
