import 'package:mwf_app/service/api.dart';
import 'package:mwf_app/service/strings.dart';
import 'package:mwf_app/service/url.dart';

class HistoryPaymentModel {
  String billMonth;
  String amount;
  String paymentChannel;
  String dueDate;
  String paymentDate;
  String unitUsed;
  List<BillItemList> billItemList;

  HistoryPaymentModel(
      {this.billMonth,
      this.amount,
      this.paymentChannel,
      this.dueDate,
      this.paymentDate,
      this.unitUsed,
      this.billItemList});

  static getData() async {
    var url = AppUrl.HistoryPayment +
        "?CA=" +
        AppStrings.serviceElectricityUserNumberName +
        "&AuthenKey=" +
        AppUrl.AuthenKey;

    final response = await AppApi.apiGetRequest(url); // เรียกใช้ api

    return response;
  }

  static getDataDetail(String billID) async {
    print(billID);
    final response = await AppApi.apiGetRequest(
        AppUrl.HistoryPaymentDetail_View +
            "?BillID=" +
            billID +
            "&AuthenKey=" +
            AppUrl.AuthenKey); // เรียกใช้ api
    dataDetail.clear(); // เคลียข้อมูลเดิมออกก่อน

    return response;
  }

  static List<HistoryPaymentModel> dataCurrentYear = [];
  static List<HistoryPaymentModel> dataPrevYear = [];
  static List<HistoryPaymentModel> data = [];

  static List<BillItemList> dataDetail = []; // ตัวแปรที่จะเรียกใช้งาน

  HistoryPaymentModel.fromJson(Map<dynamic, dynamic> json) {
    billMonth = json['BillMonth'];
    amount = json['Amount'].toString();
    paymentChannel = json['PaymentChannel'];
    dueDate = json['DueDate'];
    paymentDate = json['PaymentDate'];
    unitUsed = json['UnitUsed'].toString();
    if (json['BillItemList'] != null) {
      billItemList = new List<BillItemList>();
      json['BillItemList'].forEach((v) {
        billItemList.add(new BillItemList.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['BillMonth'] = this.billMonth;
    data['Amount'] = this.amount;
    data['PaymentChannel'] = this.paymentChannel;
    data['DueDate'] = this.dueDate;
    data['PaymentDate'] = this.paymentDate;
    data['UnitUsed'] = this.unitUsed;
    if (this.billItemList != null) {
      data['BillItemList'] = this.billItemList.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class BillItemList {
  String sequenceNumber;
  String itemName;
  String amount;
  String unit;

  BillItemList({this.sequenceNumber, this.itemName, this.amount, this.unit});

  BillItemList.fromJson(Map<dynamic, dynamic> json) {
    sequenceNumber = json['SequenceNumber'].toString();
    itemName = json['ItemName'];
    amount = json['Amount'].toString();
    unit = json['Unit'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['SequenceNumber'] = this.sequenceNumber;
    data['ItemName'] = this.itemName;
    data['Amount'] = this.amount;
    data['Unit'] = this.unit;
    return data;
  }
}
