import 'package:mwf_app/service/api.dart';
import 'package:mwf_app/service/url.dart';

class HistoryContactCustomer {
  String historyContactCustomerID;
  String historyContactID;
  String employeeID;
  String customerName;
  String cA;
  String customerAddress;
  String tSICID;
  String tSICName;
  String branchID;
  String branchname;
  String visitDate;
  String purposeVisit;
  String employeename;
  String employeePosition;
  String authenKey;
  String visit;
  String employeeSurname;
  String visitPlanDate;
  String proposeTypeID;
  String proposeTypename;
  String description;
  String pathfilename;
  String attacthfile;
  String filename;

  HistoryContactCustomer({
    this.historyContactCustomerID,
    this.historyContactID,
    this.employeeID,
    this.customerName,
    this.cA,
    this.customerAddress,
    this.tSICID,
    this.tSICName,
    this.branchID,
    this.branchname,
    this.visitDate,
    this.purposeVisit,
    this.employeename,
    this.employeePosition,
    this.authenKey,
    this.visit,
    this.employeeSurname,
    this.visitPlanDate,
    this.proposeTypeID,
    this.proposeTypename,
    this.description,
    this.pathfilename,
    this.attacthfile,
    this.filename,
  });

  static getData() async {
    final response = await AppApi.apiGetRequest(
      AppUrl.HistoryContactCustomer_ReadList +
          "?HistoryContactCustomerID=" +
          AppUrl.HistoryContactCustomerID +
          "&AuthenKey=" +
          AppUrl.AuthenKey,
    ); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static saveData(context, Map<String, dynamic> data) async {
    final response = await AppApi.post(
      AppUrl.HistoryContactCustomer_Create,
      data,
    ); // เรียกใช้ api
    print(response);
    if (response['statusCode'] == 200) {
      //Nav.push(context, Schedule());
    }
  }

  static deleteData(
    context,
    String historyContactCustomerID,
  ) async {
    Map<String, dynamic> data = {
      "HistoryContactCustomerID": historyContactCustomerID,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response = await AppApi.post(
      AppUrl.HistoryContactCustomer_Delete,
      data,
    ); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static updateData(
    context,
    String historyContactCustomerID,
    String historyContactID,
    String employeeID,
    String customerName,
    String cA,
    String customerAddress,
    String tSICID,
    String tSICName,
    String branchID,
    String branchname,
    DateTime visitDate,
    String purposeVisit,
    String employeename,
    String employeePosition,
    String authenKey,
    String visit,
    String employeeSurname,
    DateTime visitPlanDate,
    String proposeTypeID,
    String proposeTypename,
    String description,
    String pathfilename,
    String attacthfile,
    String filename,
  ) async {
    Map<String, dynamic> data = {
      "HistoryContactCustomerID": historyContactCustomerID,
      "HistoryContactID": historyContactID,
      "EmployeeID": employeeID,
      "CustomerName": customerName,
      "CA": cA,
      "CustomerAddress": customerAddress,
      "TSICID": tSICID,
      "TSICName": tSICName,
      "BranchID": branchID,
      "Branchname": branchname,
      "VisitDate": visitDate,
      "PurposeVisit": purposeVisit,
      "Employeename": employeename,
      "EmployeePosition": employeePosition,
      "Visit": visit,
      "EmployeeSurname": employeeSurname,
      "VisitPlanDate": visitPlanDate,
      "ProposeTypeID": proposeTypeID,
      "ProposeTypename": proposeTypename,
      "Description": description,
      "Pathfilename": pathfilename,
      "Attacthfile": attacthfile,
      "filename": filename,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response = await AppApi.post(
        AppUrl.HistoryContactCustomer_Update, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static List<HistoryContactCustomer> data = []; // ตัวแปรที่จะเรียกใช้งาน

  HistoryContactCustomer.fromJson(Map<String, dynamic> json) {
    historyContactCustomerID = json['HistoryContactCustomerID'];
    historyContactID = json['HistoryContactID'];
    employeeID = json['EmployeeID'];
    customerName = json['CustomerName'];
    cA = json['CA'];
    customerAddress = json['CustomerAddress'];
    tSICID = json['TSICID'];
    tSICName = json['TSICName'];
    branchID = json['BranchID'];
    branchname = json['Branchname'];
    visitDate = json['VisitDate'];
    purposeVisit = json['PurposeVisit'];
    employeename = json['Employeename'];
    employeePosition = json['EmployeePosition'];
    authenKey = json['AuthenKey'];
    visit = json['Visit'];
    employeeSurname = json['EmployeeSurname'];
    visitPlanDate = json['VisitPlanDate'];
    proposeTypeID = json['ProposeTypeID'];
    proposeTypename = json['ProposeTypename'];
    description = json['Description'];
    pathfilename = json['Pathfilename'];
    attacthfile = json['Attacthfile'];
    filename = json['filename'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['HistoryContactCustomerID'] = this.historyContactCustomerID;
    data['HistoryContactID'] = this.historyContactID;
    data['EmployeeID'] = this.employeeID;
    data['CustomerName'] = this.customerName;
    data['CA'] = this.cA;
    data['CustomerAddress'] = this.customerAddress;
    data['TSICID'] = this.tSICID;
    data['TSICName'] = this.tSICName;
    data['BranchID'] = this.branchID;
    data['Branchname'] = this.branchname;
    data['VisitDate'] = this.visitDate;
    data['PurposeVisit'] = this.purposeVisit;
    data['Employeename'] = this.employeename;
    data['EmployeePosition'] = this.employeePosition;
    data['AuthenKey'] = this.authenKey;
    data['Visit'] = this.visit;
    data['EmployeeSurname'] = this.employeeSurname;
    data['VisitPlanDate'] = this.visitPlanDate;
    data['ProposeTypeID'] = this.proposeTypeID;
    data['ProposeTypename'] = this.proposeTypename;
    data['Description'] = this.description;
    data['Pathfilename'] = this.pathfilename;
    data['Attacthfile'] = this.attacthfile;
    data['filename'] = this.filename;
    return data;
  }
}
