import 'package:flutter/widgets.dart';
import 'package:mwf_app/service/api.dart';
import 'package:mwf_app/service/loader.dart';
import 'package:mwf_app/service/url.dart';

class HistoryContact {
  String customerCommunicateId;
  String communicateDate;
  String communicateWith;
  String communicateDetail;
  String communicateDirectionId;
  String communicateChannelId;
  String categoryContactId;

  HistoryContact({
    this.customerCommunicateId,
    this.communicateDate,
    this.communicateWith,
    this.communicateDetail,
    this.communicateDirectionId,
    this.communicateChannelId,
    this.categoryContactId,
  });

  static getData() async {
    final response = await AppApi.apiGetRequest(
      AppUrl.HistoryContact_ReadList +
          "?customerId=" +
          AppUrl.CustomerID +
          "&AuthenKey=" +
          AppUrl.AuthenKey,
    ); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static getHistoryContactRead(String historyId) async {
    final response = await AppApi.apiGetRequest(
      AppUrl.HistoryContact_Read +
          "?customerCommunicateId=" +
          historyId +
          "&AuthenKey=" +
          AppUrl.AuthenKey,
    ); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static getCommunicateDirectionList() async {
    final response = await AppApi.apiGetRequest(
        AppUrl.CommunicateDirectionList +
            "?AuthenKey=" +
            AppUrl.AuthenKey); // เรียกใช้ api
    return response;
  }

  static getContactChanelReadList() async {
    final response = await AppApi.apiGetRequest(AppUrl.ContactChanel_ReadList +
        "?AuthenKey=" +
        AppUrl.AuthenKey); // เรียกใช้ api
    return response;
  }

  static getCustomerCareReadList() async {
    final response = await AppApi.apiGetRequest(AppUrl.CustomerCare_ReadList +
        "?customerId=" +
        AppUrl.CustomerID +
        "&AuthenKey=" +
        AppUrl.AuthenKey); // เรียกใช้ api
    return response;
  }

  static getCustomerContactReadList() async {
    final response = await AppApi.apiGetRequest(
        AppUrl.CustomerContact_ReadList +
            "?customerID=" +
            AppUrl.CustomerID +
            "&AuthenKey=" +
            AppUrl.AuthenKey); // เรียกใช้ api
    return response;
  }

  static getCategoryContactList() async {
    final response = await AppApi.apiGetRequest(AppUrl.CategoryContactList +
        "?AuthenKey=" +
        AppUrl.AuthenKey); // เรียกใช้ api

    return response;
  }

  static getCommunicateChannelList() async {
    final response = await AppApi.apiGetRequest(AppUrl.CommunicateChannel +
        "?AuthenKey=" +
        AppUrl.AuthenKey); // เรียกใช้ api

    return response;
  }

  static getFormContactReadList() async {
    final response = await AppApi.apiGetRequest(AppUrl.FormContact_ReadList +
        "?AuthenKey=" +
        AppUrl.AuthenKey); // เรียกใช้ api

    return response;
  }

  static getContactReasonList() async {
    final response = await AppApi.apiGetRequest(AppUrl.ContactReason_ReadList +
        "?customerID=" +
        AppUrl.CustomerID +
        "&AuthenKey=" +
        AppUrl.AuthenKey); // เรียกใช้ api

    return response;
  }

  static saveData(context, Map<String, dynamic> data) async {
    final response = await AppApi.postWithMap(
        AppUrl.HistoryContact_Create, data); // เรียกใช้ api
    if (response['statusCode'] == 200) {
      AppLoader.showSuccess('บันทึกสำเร็จ');
      Navigator.pop(context);
    } else {
      AppLoader.showError('บันทึกไม่สำเร็จ');
      return false;
    }
  }

  static deleteData(
    context,
    String historyContactID,
  ) async {
    Map<String, dynamic> data = {
      "customerCommunicateId": historyContactID.toString(),
      "AuthenKey": AppUrl.AuthenKey.toString()
    };
    final response = await AppApi.postWithMap(
        AppUrl.HistoryContact_Delete, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      AppLoader.showSuccess('ลบสำเร็จ');
//      getData();
      return true;
    } else {
      return false;
    }
  }

  static updateData(
    context,
    String customerId,
    String communicateDate,
    String communicateWith,
    String communicateDirectionId,
    String communicateDetail,
    String communicateEmployee,
    String communicateChannelId,
    String categoryContactId,
    String authenKey,
    String historyContactCreateResult,
  ) async {
    Map<String, dynamic> data = {
      "customerId": customerId,
      "communicateDate": communicateDate,
      "communicateWith": communicateWith,
      "communicateDirectionId": communicateDirectionId,
      "communicateDetail": communicateDetail,
      "communicateEmployee": communicateEmployee,
      "communicateChannelId": communicateChannelId,
      "categoryContactId": categoryContactId,
      //"authenKey": authenKey,
      "HistoryContact_CreateResult": historyContactCreateResult,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response =
        await AppApi.post(AppUrl.HistoryContact_Update, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static List<HistoryContact> data = []; // ตัวแปรที่จะเรียกใช้งาน

  HistoryContact.fromJson(Map<String, dynamic> json) {
    customerCommunicateId = json['CustomerCommunicateId'];
    communicateDate = json['CommunicateDate'];
    communicateWith = json['CommunicateWith'];
    communicateDetail = json['CommunicateDetail'];
    communicateDirectionId = json['CommunicateDirectionId'];
    communicateChannelId = json['CommunicateChannelId'];
    categoryContactId = json['CategoryContactId'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['communicateDirectionId'] = this.customerCommunicateId;
    data['communicateDate'] = this.communicateDate;
    data['communicateWith'] = this.communicateWith;
    data['communicateDetail'] = this.communicateDetail;
    return data;
  }
}
