import 'package:mwf_app/service/api.dart';
import 'package:mwf_app/service/url.dart';

class Employee {
  String id;
  String employeeID;
  String employeeName;
  String employeeSurname;
  String employeeEmail;
  String employeePhone;

  Employee({
    this.id,
    this.employeeID,
    this.employeeName,
    this.employeeSurname,
    this.employeeEmail,
    this.employeePhone,
  });

  static getData() async {
    final response = await AppApi.apiGetRequest(
      AppUrl.Employee_ReadList +
          "?Id=" +
          AppUrl.Id +
          "&AuthenKey=" +
          AppUrl.AuthenKey,
    ); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static saveData(context, Map<String, dynamic> data) async {
    final response =
        await AppApi.post(AppUrl.Employee_Create, data); // เรียกใช้ api
    print(response);
    if (response['statusCode'] == 200) {
      //Nav.push(context, Schedule());
    }
  }

  static deleteData(
    context,
    String id,
  ) async {
    Map<String, dynamic> data = {"Id": id, "AuthenKey": AppUrl.AuthenKey};
    final response =
        await AppApi.post(AppUrl.Employee_Delete, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static updateData(
    context,
    String id,
    String employeeID,
    String employeeName,
    String employeeSurname,
    String employeeEmail,
    String employeePhone,
    String employeePosition,
  ) async {
    Map<String, dynamic> data = {
      "Id": id,
      "EmployeeID": employeeID,
      "EmployeeName": employeeName,
      "EmployeeSurname": employeeSurname,
      "EmployeeEmail": employeeEmail,
      "EmployeePhone": employeePhone,
      "EmployeePosition": employeePosition,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response =
        await AppApi.post(AppUrl.Employee_Update, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static List<Employee> data = []; // ตัวแปรที่จะเรียกใช้งาน

  Employee.fromJson(Map<String, dynamic> json) {
    id = json['Id'];
    employeeID = json['EmployeeID'];
    employeeName = json['EmployeeName'];
    employeeSurname = json['EmployeeSurname'];
    employeeEmail = json['EmployeeEmail'];
    employeePhone = json['EmployeePhone'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['Id'] = this.id;
    data['EmployeeID'] = this.employeeID;
    data['EmployeeName'] = this.employeeName;
    data['EmployeeSurname'] = this.employeeSurname;
    data['EmployeeEmail'] = this.employeeEmail;
    data['EmployeePhone'] = this.employeePhone;
    return data;
  }
}
