import 'package:mwf_app/service/api.dart';
import 'package:mwf_app/service/url.dart';

class ElectricShutdownPlan {
  String electricShutdownId;
  String startDate;
  String endDate;
  String electricShutdownDetail;
  String customerId;
  String authenKey;

  ElectricShutdownPlan({
    this.electricShutdownId,
    this.startDate,
    this.endDate,
    this.electricShutdownDetail,
    this.customerId,
    this.authenKey,
  });

  static getData() async {
    //AppUrl.ElectricShutdownPlan_ReadList +
    final response = await AppApi.apiGetRequest(
      AppUrl.ElectricShutdownPlan_Read +
          "?customerId=" +
          AppUrl.CustomerID +
          "&AuthenKey=" +
          AppUrl.AuthenKey,
    ); // เรียกใช้ api

    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static saveData(context, Map<String, dynamic> data) async {
    final response = await AppApi.post(
        AppUrl.ElectricShutdownPlan_Create, data); // เรียกใช้ api
    print(response);
    if (response['statusCode'] == 200) {
      //Nav.push(context, Schedule());
    }
  }

  static deleteData(
    context,
    String electricShutdownID,
  ) async {
    Map<String, dynamic> data = {
      "ElectricShutdownID": electricShutdownID,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response = await AppApi.post(
      AppUrl.ElectricShutdownPlan_Delete,
      data,
    ); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static updateData(
    context,
    String electricShutdownId,
    String electricShutdownDetail,
    String customerId,
    String authenKey,
    DateTime startdate,
    DateTime enddate,
  ) async {
    Map<String, dynamic> data = {
      "ElectricShutdownId": electricShutdownId,
      "ElectricShutdownDetail": electricShutdownDetail,
      "customerId": customerId,
      //"authenKey": authenKey,
      "StartDate": startdate,
      "EndDate": enddate,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response = await AppApi.post(
        AppUrl.ElectricShutdownPlan_Update, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static List<ElectricShutdownPlan> data = []; // ตัวแปรที่จะเรียกใช้งาน

  ElectricShutdownPlan.fromJson(Map<String, dynamic> json) {
    electricShutdownId = json['EleCtricShutdownId'];
    startDate = json['StartDate'];
    endDate = json['EndDate'];
    electricShutdownDetail = json['electricShutdownDetail'];
    customerId = json['customerId'];
//    authenKey = json['authenKey'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['ElectricShutdownId'] = this.electricShutdownId;
    data['StartDate'] = this.startDate;
    data['EndDate'] = this.endDate;
    data['ElectricShutdownDetail'] = this.electricShutdownDetail;
    data['customerId'] = this.customerId;
//    data['authenKey'] = this.authenKey;
    return data;
  }
}
