import 'package:mwf_app/service/api.dart';
import 'package:mwf_app/service/url.dart';

class DashboardCricle {
  String text;
  String value;
  String percent;
  String customerID;
  String year;
  String month;
  String authenKey;

  DashboardCricle({
    this.text,
    this.value,
    this.percent,
    this.customerID,
    this.year,
    this.month,
    this.authenKey,
  });

  static getData() async {
    final response = await AppApi.apiGetRequest(
      AppUrl.DashboardCircle_ReadList +
          "?YearID=" +
          AppUrl.YearID +
          "?MonthID=" +
          AppUrl.MonthID +
          "&AuthenKey=" +
          AppUrl.AuthenKey,
    ); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static saveData(context, Map<String, dynamic> data) async {
    final response =
        await AppApi.post(AppUrl.DashboardCircle_Create, data); // เรียกใช้ api
    print(response);
    if (response['statusCode'] == 200) {
      //Nav.push(context, Schedule());
    }
  }

  static deleteData(
    context,
    String yearID,
    String monthID,
  ) async {
    Map<String, dynamic> data = {
      "YearID": yearID,
      "MonthID": monthID,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response =
        await AppApi.post(AppUrl.DashboardCircle_Delete, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static updateData(
    context,
    String text,
    String value,
    String percent,
    String customerID,
    String year,
    String month,
    String authenKey,
  ) async {
    Map<String, dynamic> data = {
      "Text": text,
      "Value": value,
      "Percent": percent,
      "CustomerID": customerID,
      "Year": year,
      "Month": month,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response =
        await AppApi.post(AppUrl.DashboardCircle_Update, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static List<DashboardCricle> data = []; // ตัวแปรที่จะเรียกใช้งาน

  DashboardCricle.fromJson(Map<String, dynamic> json) {
    text = json['Text'];
    value = json['Value'];
    percent = json['Percent'];
    customerID = json['CustomerID'];
    year = json['Year'];
    month = json['Month'];
    authenKey = json['authenKey'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['Text'] = this.text;
    data['Value'] = this.value;
    data['Percent'] = this.percent;
    data['CustomerID'] = this.customerID;
    data['Year'] = this.year;
    data['Month'] = this.month;
    data['authenKey'] = this.authenKey;
    return data;
  }
}
