import 'package:get/get.dart';

import 'package:mwf_app/service/api.dart';
import 'package:mwf_app/service/loader.dart';
import 'package:mwf_app/service/url.dart';
import 'package:mwf_app/set2/activity_relationship.dart';

class CustomerRelation {
  String relationshipActivityId;
  String relationshipActivityName;
  String relationshipActivityStartDate;
  String relationshipActivityEndDate;
  String relationshipActivityPlace;
  String categoryRelationshipActivityId;
  String categoryRelationshipActivityName;
  String regionCode;
  String numberofPeopleInvite;
  String numberofPeopleAttending;
  String authenKey;

  String customerRelationshipActivityId;
  String activityId;
  String activityName;
  String activityTypeId;
  String activityTypeName;
  String startDate;
  String endDate;
  String location;

  CustomerRelation({
    this.customerRelationshipActivityId,
    this.activityId,
    this.activityName,
    this.activityTypeId,
    this.activityTypeName,
    this.startDate,
    this.endDate,
    this.location,
    this.numberofPeopleInvite,
    this.numberofPeopleAttending,
    this.authenKey,
    this.relationshipActivityId,
    this.relationshipActivityName,
    this.relationshipActivityStartDate,
    this.relationshipActivityEndDate,
    this.relationshipActivityPlace,
    this.regionCode,
    this.categoryRelationshipActivityId,
    this.categoryRelationshipActivityName,
  });

  static getData() async {
    print(AppUrl.CustomerRelation_ReadList +
            "?customerId=" +
            AppUrl.CustomerID +
            "&authenKey=" +
            AppUrl.AuthenKey);
    final response = await AppApi.apiGetRequest(
        AppUrl.CustomerRelation_ReadList +
            "?customerId=" +
            AppUrl.CustomerID +
            "&authenKey=" +
            AppUrl.AuthenKey); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    //print(response);
    return response;
  }

  static deleteData(
    context,
    String customerRelationID,
  ) async {
    Map<String, dynamic> data = {
      "CustomerRelationID": customerRelationID,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response = await AppApi.postWithMap(
        AppUrl.CustomerRelation_Delete, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      AppLoader.showSuccess('ลบสำเร็จ');
      return true;
    } else {
      AppLoader.showError('ลบข้อมูลไม่สำเร็จ');
      return false;
    }
  }

  static updateData(
    context,
    String customerRelationId,
    String activityId,
    String numberofPeopleInvite,
    String numberofPeopleAttending,
    // String AuthenKey,
  ) async {
    Map<String, dynamic> data = {
      "customerRelationId": customerRelationId.toString(),
      "relationActivityId": activityId.toString(),
      //"ActivityName": activityName,
      "customerId": AppUrl.CustomerID.toString(),
      // "ActivityTypeId": activityTypeId,
      // "StartDate": startDate,
      // "EndDate": endDate,
      // "Location": location,
      // "ActivityTypeName": activityTypeName,
      "numberofPeopleInvite": numberofPeopleInvite.toString(),
      "numberofPeopleAttending": numberofPeopleAttending.toString(),
      "authenKey": AppUrl.AuthenKey.toString()
    };

    final response = await AppApi.postWithMap(
        AppUrl.CustomerRelation_Update, data); // เรียกใช้ api
    if (response['statusCode'] != 200) {
      AppLoader.showError('เพิ่มข้อมูลไม่สำเร็จ');
    } else {
      AppLoader.showSuccess('เพิ่มข้อมูลสำเร็จ');
      await Future.delayed(Duration(seconds: 1));
      Get.offAll(ActivityRelationship());
    }

    data.clear();
    return response;
  }

  static List<CustomerRelation> data = []; // ตัวแปรที่จะเรียกใช้งาน

  CustomerRelation.fromJson(Map<String, dynamic> json) {
    customerRelationshipActivityId = json['CustomerRelationshipActivityId'];
    activityId = json['ActivityId'];
    activityName = json['ActivityName'];
    activityTypeId = json['ActivityTypeId'];
    activityTypeName = json['ActivityTypeName'];
    startDate = json['StartDate'];
    endDate = json['EndDate'];
    location = json['Location'];

    numberofPeopleInvite = json['NumberofPeopleInvite'] == null
        ? "0"
        : json['NumberofPeopleInvite'].toString();
    numberofPeopleAttending = json['NumberofPeopleAttending'] == null
        ? "0"
        : json['NumberofPeopleAttending'].toString();
    authenKey = json['authenKey'];

// New API
    relationshipActivityId = json['RelationshipActivityId'];
    relationshipActivityName = json['RelationshipActivityName'];
    relationshipActivityStartDate = json['RelationshipActivityStartDate'];
    relationshipActivityEndDate = json['RelationshipActivityEndDate'];
    relationshipActivityPlace = json['RelationshipActivityPlace'];
    regionCode = json['RegionCode'];
    categoryRelationshipActivityId = json['CategoryRelationshipActivityId'];
    categoryRelationshipActivityName = json['CategoryRelationshipActivityName'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['RelationshipActivityId'] = this.relationshipActivityId;
    data['RelationshipActivityName'] = this.relationshipActivityName;
    data['RelationshipActivityStartDate'] = this.relationshipActivityStartDate;
    data['RelationshipActivityEndDate'] = this.relationshipActivityEndDate;
    data['RelationshipActivityPlace'] = this.relationshipActivityPlace;
    data['CategoryRelationshipActivityId'] =
        this.categoryRelationshipActivityId;
    data['CategoryRelationshipActivityName'] =
        this.categoryRelationshipActivityName;
    data['RegionCode'] = this.regionCode;
    data['NumberofPeopleInvite'] = this.numberofPeopleInvite;
    data['NumberofPeopleAttending'] = this.numberofPeopleAttending;
    data['authenKey'] = this.authenKey;
    return data;
  }

  //===========================================================================================
  //                                CustomerRelation_Read
  //===========================================================================================

  static getDataEdit(
    context,
    String customerRelationID,
  ) async {
    final response = await AppApi.apiGetRequest(AppUrl.CustomerRelation_Read +
        "?customerRelationshipActivityId=" +
        customerRelationID +
        "&authenKey=" +
        AppUrl.AuthenKey); // เรียกใช้ api
    data.clear();
    return response;
  }

  //===========================================================================================
  //                                CustomerRelation_Search
  //===========================================================================================

  static getDataSearch(
    context,
    String activityName, //ชื่อเรื่อง
    String activityTypeId, //ประเภท
    String startDate,
    String endDate,
  ) async {
    Map<String, dynamic> data = {
      "activityName": activityName,
      "activityTypeId": activityTypeId,
      "startDate": startDate,
      "endDate": endDate,
      "authenKey": AppUrl.AuthenKey
    };
    print(data);
    final response = await AppApi.apiGetRequest(AppUrl.CustomerRelation_Search +
        "?activityName=" +
        activityName +
        "&activityTypeId=" +
        activityTypeId +
        "&startDate=" +
        startDate +
        "&endDate=" +
        endDate +
        "&authenKey=" +
        AppUrl.AuthenKey); // เรียกใช้ api
    data.clear();
    return response;
  }

  //===========================================================================================
  //                                CustomerRelation_Create
  //===========================================================================================
  static saveData(
      context,
      String relationshipActivityId, //ชื่อเรื่อง
      String numberofPeopleInvite,
      String numberofPeopleAttending) async {
    Map<String, dynamic> data = {
      "customerId": AppUrl.CustomerID, //ID Card ที่ถูกเลิอกไว้จากหน้าค้นหา
      "relationActivityId":
          relationshipActivityId, // มาจากค่านี้ this.relationshipActivityId; จากการค้นหา
      "numberofPeopleInvite": numberofPeopleInvite,
      "numberofPeopleAttending": numberofPeopleAttending,
      "authenKey": AppUrl.AuthenKey
    };
    print(data);
    final response = await AppApi.postWithMap(
        AppUrl.CustomerRelation_Create, data); // เรียกใช้ api
    if (response['statusflag'] == true) {
      AppLoader.showSuccess('เพิ่มข้อมูลสำเร็จ');
      await Future.delayed(Duration(seconds: 1));
      Get.offAll(ActivityRelationship());
    } else {
      AppLoader.showError('เพิ่มข้อมูลไม่สำเร็จเนื่องจาก กิจกรรมนี้เคยเข้าร่วมแล้ว');
    }
    data.clear();
    return response;
  }
}

class CustomerRelationInfo {
  String customerRelationshipActivityId;
  String activityId;
  String activityName;
  String activityTypeId;
  String activityTypeName;
  String startDate;
  String endDate;
  String location;
  String numberofPeopleInvite;
  String numberofPeopleAttending;
  String authenKey;

  CustomerRelationInfo({
    this.customerRelationshipActivityId,
    this.activityId,
    this.activityName,
    this.activityTypeId,
    this.activityTypeName,
    this.startDate,
    this.endDate,
    this.location,
    this.numberofPeopleInvite,
    this.numberofPeopleAttending,
    this.authenKey,
  });

  CustomerRelationInfo.fromJson(Map<String, dynamic> json) {
    customerRelationshipActivityId = json['CustomerRelationshipActivityId'];
    activityId = json['ActivityId'];
    activityName = json['ActivityName'];
    activityTypeId = json['ActivityTypeId'];
    activityTypeName = json['ActivityTypeName'];
    startDate = json['StartDate'];
    endDate = json['EndDate'];
    location = json['Location'];
    numberofPeopleInvite = json['NumberofPeopleInvite'];
    numberofPeopleAttending = json['NumberofPeopleAttending'];
    authenKey = json['authenKey'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = Map<String, dynamic>();
    data['CustomerRelationshipActivityId'] =
        this.customerRelationshipActivityId;
    data['ActivityId'] = this.activityId;
    data['ActivityName'] = this.activityName;
    data['ActivityTypeId'] = this.activityTypeId;
    data['ActivityTypeName'] = this.activityTypeName;
    data['StartDate'] = this.startDate;
    data['EndDate'] = this.endDate;
    data['Location'] = this.location;
    data['NumberofPeopleInvite'] = this.numberofPeopleInvite;
    data['NumberofPeopleAttending'] = this.numberofPeopleAttending;
    data['authenKey'] = this.authenKey;
    return data;
  }
}
