import 'package:flutter/material.dart';
import 'package:flutter/widgets.dart';
import 'package:mwf_app/service/api.dart';
import 'package:mwf_app/service/loader.dart';
import 'package:mwf_app/service/url.dart';
import 'package:mwf_app/set3/customer_staff_list.dart';

class CustomerCare {
  String customerSaleInfoId;
  String employeeNumber;
  String employeeFullName;
  String employeeEmail;
  String customerCareStartDate;
  String customerCareEndDate;
  String employeeContact;
  String customerId;
  String authenKey;

  CustomerCare(
      {this.customerSaleInfoId,
      this.employeeNumber,
      this.employeeFullName,
      this.employeeEmail,
      this.customerCareStartDate,
      this.customerCareEndDate,
      this.employeeContact,
      this.customerId,
      this.authenKey});

  static getData() async {
    final response = await AppApi.apiGetRequest(AppUrl.CustomerCare_ReadList +
        "?CustomerID=" +
        AppUrl.CustomerID +
        "&authenKey=" +
        AppUrl.AuthenKey); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static getSearchData(String employeeNumber, String employeeName,
      String employeeSurname, String employeeEmail) async {
    final response = await AppApi.apiGetRequest(AppUrl.CustomerCare_Search +
        "?employeeNumber=" +
        employeeNumber +
        "&employeeName=" +
        employeeName +
        "&employeeSurname=" +
        employeeSurname +
        "&email=" +
        employeeEmail +
        "&authenKey=" +
        AppUrl.AuthenKey); // เรียกใช้ api
    dataList.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static createData(context, Map<String, dynamic> data) async {
    final response = await AppApi.postWithMap(
        AppUrl.CustomerCare_Create, data); // เรียกใช้ api
    print(response);
    if (response['statusCode'] == 200) {
      AppLoader.showSuccess("บันทึกสำเร็จ");
      await new Future.delayed(const Duration(milliseconds: 1000));
      Navigator.pushReplacement(
          context,
          MaterialPageRoute(
              builder: (context) => Customerstaff_list()));
    }
  }

  static saveData(context, Map<String, dynamic> data) async {
    final response =
        await AppApi.post(AppUrl.CustomerCare_Create, data); // เรียกใช้ api
    print(response);
    if (response['statusCode'] == 200) {
      //Nav.push(context, Schedule());
    }
  }

  static updateData(context, Map<String, dynamic> data) async {
    final response = await AppApi.postWithMap(
        AppUrl.CustomerCare_Update, data); // เรียกใช้ api
    print(response);
    if (response['statusCode'] == 200) {
      AppLoader.showSuccess("แก้ไขสำเร็จ");
      await new Future.delayed(const Duration(milliseconds: 2000));
      Navigator.pushReplacement(
          context,
          MaterialPageRoute(
              builder: (context) => Customerstaff_list()));
    }
  }

  static delete(context, Map<String, dynamic> data) async {
    final response = await AppApi.postWithMap(
        AppUrl.CustomerCare_Delete, data); // เรียกใช้ api
    print(response);
    if (response['statusCode'] == 200) {
      return true;
    }
  }

  static List<CustomerCare> dataList = []; // ตัวแปรที่จะเรียกใช้งาน
  static List<CustomerCare> data = []; // ตัวแปรที่จะเรียกใช้งาน

  CustomerCare.fromJson(Map<String, dynamic> json) {
    customerSaleInfoId = json['CustomerSaleInfoId'];
    employeeNumber = json['EmployeeNumber'];
    employeeFullName = json['EmployeeFullName'];
    customerCareStartDate = json['CustomerCareStartDate'];
    customerCareEndDate = json['CustomerCareEndDate'];
    employeeContact = json['EmployeeContact'];
    customerId = json['customerId'];
    authenKey = json['authenKey'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['customerSaleInfoId'] = this.customerSaleInfoId;
    data['EmployeeNumber'] = this.employeeNumber;
    data['EmployeeFullName'] = this.employeeFullName;
    data['startDate'] = this.customerCareStartDate;
    data['endDate'] = this.customerCareEndDate;
    data['EmployeeContact'] = this.employeeContact;
    data['customerId'] = this.customerId;
    data['authenKey'] = this.authenKey;
    return data;
  }
}

class CustomerCareInfo {
  static List<CustomerCareInfo> dataList = []; //
  String saleInfoId;
  String customerId;
  String employeeNumber;
  String employeeFullName;
  String telephoneNo;
  String email;
  String startDate;
  String endDate;
  String authenKey;

  CustomerCareInfo(
      {this.saleInfoId,
      this.customerId,
      this.startDate,
      this.endDate,
      this.employeeNumber,
      this.employeeFullName,
      this.telephoneNo,
      this.email,
      this.authenKey});

  static getSearchData(String employeeNumber, String employeeName,
      String employeeSurname, String employeeEmail) async {
    final response = await AppApi.apiGetRequest(AppUrl.CustomerCare_Search +
        "?employeeNumber=" +
        employeeNumber +
        "&employeeName=" +
        employeeName +
        "&employeeSurname=" +
        employeeSurname +
        "&email=" +
        employeeEmail +
        "&authenKey=" +
        AppUrl.AuthenKey); // เรียกใช้ api
    dataList.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  CustomerCareInfo.fromJson(Map<String, dynamic> json) {
    saleInfoId = json['SaleInfoId'];
    customerId = json['customerId'];
    employeeNumber = json['EmployeeNumber'];
    employeeFullName = json['EmployeeFullName'];
    telephoneNo = json['TelephoneNo'];
    email = json['Email'];
    startDate = json['StartDate'];
    endDate = json['EndDate'];
    authenKey = json['AuthenKey'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['SaleInfoId'] = this.saleInfoId;
    data['customerId'] = this.customerId;
    data['EmployeeNumber'] = this.employeeNumber;
    data['EmployeeFullName'] = this.employeeFullName;
    data['TelephoneNo'] = this.telephoneNo;
    data['Email'] = this.email;
    data['StartDate'] = this.startDate;
    data['EndDate'] = this.endDate;
    data['AuthenKey'] = this.authenKey;
    return data;
  }
}
