import 'package:mwf_app/service/api.dart';
import 'package:mwf_app/service/url.dart';
import 'package:mwf_app/model/user.dart';

class ChatDetail {
  String id;
  String chatMasterId;
  String chatMaster;
  String accountId;
  String typeChat;
  String typeAccount;
  int type;
  List<User> userRead = [];
  String content;
  String createAt;
  String time;
  int status;
  String fileUrl;
  int totalPage;
  int readcnt;
  String fileName;

  ChatDetail({
    this.id,
    this.chatMasterId,
    this.chatMaster,
    this.accountId,
    this.typeChat,
    this.typeAccount,
    this.type,
    this.userRead,
    this.content,
    this.createAt,
    this.time,
    this.status,
    this.fileUrl,
    this.totalPage,
    this.readcnt,
    this.fileName,
  });

  static List<ChatDetail> data = [];

  static getData(String typeChat, nextPage) async {
    String nextPages = nextPage.toString();
    print(
      AppUrl.ChatDetail_ByChatMasterList +
         "?AccountId=" +
          AppUrl.userID +
          "&AuthenKey=" +
          AppUrl.AuthenKey +
          "&TypeAccount=" +
          AppUrl.typeAccount +
          "&TypeChat=" +
          typeChat +
          "&ChatMasterId=" +
          AppUrl.chatMasterId +
          "&CA=" +
          AppUrl.CA +
          "&CustomerId=" +
          AppUrl.CustomerID +
          "&saleInfoId=" +
          AppUrl.userID
    );

    final response = await AppApi.apiGetRequest(
      AppUrl.ChatDetail_ByChatMasterList +
          "?AccountId=" +
          AppUrl.userID +
          "&AuthenKey=" +
          AppUrl.AuthenKey +
          "&TypeAccount=" +
          AppUrl.typeAccount +
          "&TypeChat=" +
          typeChat +
          "&ChatMasterId=" +
          AppUrl.chatMasterId +
          "&CA=" +
          AppUrl.CA +
          "&CustomerId=" +
          AppUrl.CustomerID +
          "&saleInfoId=" +
          AppUrl.userID
          // "&currentPage="+
          // nextPages,
    );

    return response;
  }

  static getFile(id){
    String url = AppUrl.ChatMaster_GetFile + "?Id=" + id + "&AuthenKey=" + AppUrl.AuthenKey;
    return url;
  }

  ChatDetail.fromJson(Map<String, dynamic> json) {
    id = json['Id'];
    chatMasterId = json['ChatMasterId'];
    chatMaster = json['ChatMaster'];
    accountId = json['AccountId'];
    typeChat = json['TypeChat'];
    typeAccount = json['TypeAccount'];
    type = json['Type'];
    userRead.add(User.fromJson(json['user']));
    content = json['content'];
    createAt = json['createAt'];
    time = json['Time'];
    status = json['Status'];
    fileUrl = json['fileUrl'];
    totalPage = json['TotalPage'];
    readcnt = json['ReadsCnt'];
    fileName = json['FileName'] == "" ? "ไม่มีชื่อไฟล์" : json['FileName'];
  }
}
