import 'package:mwf_app/service/api.dart';
import 'package:mwf_app/service/url.dart';

class ActivityType {
  String activityTypeID;
  String activityType;

  ActivityType({
    this.activityTypeID,
    this.activityType,
  });

  static getData() async {
    final response = await AppApi.apiGetRequest(
      AppUrl.ActivityType_ReadList + "?AuthenKey=" + AppUrl.AuthenKey,
    ); // เรียกใช้ api

    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static List<ActivityType> data = []; // ตัวแปรที่จะเรียกใช้งาน

  ActivityType.fromJson(Map<String, dynamic> json) {
    activityTypeID = json['ActivityId'];
    activityType = json['ActivityType'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = Map<String, dynamic>();
    data['ActivityId'] = this.activityTypeID;
    data['ActivityType'] = this.activityType;
    return data;
  }
}
