import 'package:mwf_app/service/api.dart';
import 'package:mwf_app/service/navigator.dart';
import 'package:mwf_app/service/url.dart';

class TimelineCustomer {
  String timelineID;
  String cA;
  String customerName;
  String customerID;
  String address;

  TimelineCustomer({this.customerID, this.cA, this.customerName, this.address});

  static getData() async {
    final response = await AppApi.apiGetRequest(AppUrl.CustomerList_ReadList +
        "?SaleInfoId=" +
        AppUrl.userID +
        "&AuthenKey=" +
        AppUrl.AuthenKey); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static List<TimelineCustomer> data = []; // ตัวแปรที่จะเรียกใช้งาน

  TimelineCustomer.fromJson(Map<String, dynamic> json) {
//    timelineID = json['TimelineID'];
    customerID = json['CustomerId'];
    cA = json['Ca'];
    customerName = json['CustomerName'];
    address = json['Address'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['CustomerId'] = this.customerID;
    data['CA'] = this.cA;
    data['CustomerName'] = this.customerName;
    data['Address'] = this.address;
    return data;
  }
}
