import 'package:flutter/widgets.dart';
import 'package:mwf_app/service/alert.dart';
import 'package:mwf_app/service/api.dart';
import 'package:mwf_app/service/navigator.dart';
import 'package:mwf_app/service/url.dart';
import 'package:mwf_app/set6/service_report_user.dart';
import 'package:mwf_app/set6/service_survey.dart';

class Survey {
  String sQCode;
  String sQId;
  String sGId;
  String sQName;
  String sQDescription;
  bool sQStatus;
  String statDate;
  String endDate;
  String sQCId;
  String sQCName;
  String sQCType;
  String isRequired;
  String sQCFormat;
  String sQCErrMsg;
  String sQDId;
  String sQDQuestion;
  String sAId;
  String sAAnswer1;
  String sAAnswer2;
  String customerId;
  String createDate;

  Survey(
      {this.sQCode,
      this.sQId,
      this.sGId,
      this.sQName,
      this.sQDescription,
      this.sQStatus,
      this.statDate,
      this.endDate,
      this.sQCId,
      this.sQCName,
      this.sQCType,
      this.isRequired,
      this.sQCFormat,
      this.sQCErrMsg,
      this.sQDId,
      this.sQDQuestion,
      this.sAId,
      this.sAAnswer1,
      this.sAAnswer2,
      this.customerId,
      this.createDate});

  static List<dynamic> surveyList = [
    {
      "no": "1",
      "sGId": "S0004",
      "sQName": "อุปกรณ์ไฟฟ้าส่องสว่าง",
      "statDate": "10/02/2563 10:00:00",
      "endDate": "12/02/2563 16:00:00",
    },
    {
      "no": "2",
      "sGId": "S0004",
      "sQName": "อุปกรณ์ไฟฟ้าส่องสว่าง",
      "statDate": "10/02/2563 10:00:00",
      "endDate": "12/02/2563 16:00:00",
    },
    {
      "no": "3",
      "sGId": "S0004",
      "sQName": "อุปกรณ์ไฟฟ้าส่องสว่าง",
      "statDate": "10/02/2563 10:00:00",
      "endDate": "12/02/2563 16:00:00",
    },
  ]; // รายการแบบสำรวจ
  static getData() async {
    print(AppUrl.SurveyQuestionList + "?AuthenKey=" + AppUrl.AuthenKey);
    final response = await AppApi.apiGetRequest(AppUrl.SurveyQuestionList +
        "?AuthenKey=" +
        AppUrl.AuthenKey); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static getDataBySQID(String sq_id) async {
    try {
      print(AppUrl.SurveyQuestionRecord_ReadList +
          "?SQ_Id=" +
          sq_id +
          "&AuthenKey=" +
          AppUrl.AuthenKey); // เรียกใช้ api
      final response = await AppApi.apiGetRequest(
          AppUrl.SurveyQuestionRecord_ReadList +
              "?SQ_Id=" +
              sq_id +
              "&AuthenKey=" +
              AppUrl.AuthenKey); // เรียกใช้ api
      dataList.clear(); // เคลียข้อมูลเดิมออกก่อน
      return response;
    } catch (e) {
      print(e);
    }
  }

  static getDataBySQIDForm(String sq_id) async {
    try {
      final response = await AppApi.apiGetRequest(AppUrl.SurveyQuestion_Read +
          "?SQ_Id=" +
          sq_id +
          "&AuthenKey=" +
          AppUrl.AuthenKey); // เรียกใช้ api
      SurveyQuestionChoice.dataListForm.clear(); // เคลียข้อมูลเดิมออกก่อน
      return response;
    } catch (e) {
      print(e);
    }
  }

  static saveData(context, Map<String, dynamic> data) async {
    final response =
        await AppApi.post(AppUrl.Survey_Create, data); // เรียกใช้ api
    print(response);
    if (response['statusCode'] == 200) {
      alertForm(context, "สำเร็จ", "เพิ่มข้อมูลสำเร็จ");
//      Nav.push(context, service_survey());
//      Navigator.of(context).pop(true);
      Navigator.pop(context);
    }
  }

  static deleteData(context, String SRCQ_Id) async {
    print(AppUrl.SurveyQuestionRecord_Delete);
    print(SRCQ_Id);
    Map<String, dynamic> data = {
      "SRCQ_Id": SRCQ_Id, 
      "AuthenKey" : AppUrl.AuthenKey
    };
    final response = await AppApi.post(
        AppUrl.SurveyQuestionRecord_Delete, data); // เรียกใช้ api
    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static getVoice_Provine() async {
    final response = await AppApi.apiGetRequest(AppUrl.Voc_Provinelist +
        "?AuthenKey=" +
        AppUrl.AuthenKey); // เรียกใช้ api

    return response;
  }

  static updateData(
    context,
    String sQ_Id,
    String sG_Id,
    String sQ_Name,
    String sQ_Description,
    String sQ_Status,
    DateTime statDate,
    DateTime endDate,
    String sQC_Id,
    String sQC_Name,
    String sQC_Type,
    String isRequired,
    String sQC_Format,
    String sQC_Err_Msg,
    String sQD_Id,
    String sQD_Question,
    String sA_Id,
    String sA_Answer1,
    String sA_Answer2,
    String customerId,
    DateTime createDate,
  ) async {
    Map<String, dynamic> data = {
      "SQ_Id": sQ_Id,
      "SG_Id": sG_Id,
      "SQ_Name": sQ_Name,
      "SQ_Description": sQ_Description,
      "SQ_Status": sQ_Status,
      "StatDate": statDate,
      "EndDate": endDate,
      "SQC_Id": sQC_Id,
      "SQC_Name": sQC_Name,
      "SQC_Type": sQC_Type,
      "IsRequired": isRequired,
      "SQC_Format": sQC_Format,
      "SQC_Err_Msg": sQC_Err_Msg,
      "SQD_Id": sQD_Id,
      "SQD_Question": sQD_Question,
      "SA_Id": sA_Id,
      "SA_Answer1": sA_Answer1,
      "SA_Answer2": sA_Answer2,
      "CustomerId": customerId,
      "CreateDate": createDate,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response =
        await AppApi.post(AppUrl.Survey_Update, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static List<Survey> data = []; // ตัวแปรที่จะเรียกใช้งาน

  static List<Survey> dataList = []; // ตัวแปรที่จะเรียกใช้งาน
  // ตัวแปรที่จะเรียกใช้งาน
  Survey.fromJson(Map<String, dynamic> json) {
    sQCode = json['SQ_Code'].toString();
    sQId = json['SQ_Id'];
    sGId = json['SG_Id'];
    sQName = json['SQ_Name'];
    sQDescription = json['SQ_Description'];
    sQStatus = json['SQ_Status'];
    statDate = json['StatDate'];
    endDate = json['EndDate'];
    sQCId = json['SQC_Id'];
    sQCName = json['SQC_Name'];
    sQCType = json['SQC_Type'];
    isRequired = json['IsRequired'];
    sQCFormat = json['SQC_Format'];
    sQCErrMsg = json['SQC_Err_Msg'];
    sQDId = json['SQD_Id'];
    sQDQuestion = json['SQD_Question'];
    sAId = json['SA_Id'];
    sAAnswer1 = json['SA_Answer1'];
    sAAnswer2 = json['SA_Answer2'];
    customerId = json['CustomerId'];
    createDate = json['CreateDate'];
  }

  Survey.fromJsonList(Map<String, dynamic> json) {
    sQCode = json['SQ_Code'].toString();
    sQId = json['SQ_Id'];
    sGId = json['SG_Id'];
    sQName = json['SQ_Name'];
    sQDescription = json['SQ_Description'];
    sQStatus = json['SQ_Status'];
    statDate = json['strStartDate'];
    endDate = json['strEndDate'];
    if (endDate == "") {
      endDate = "-";
    }
    createDate = json['strCreateDate'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['sQCode'] = this.sQCode;
    data['SQ_Id'] = this.sQId;
    data['SG_Id'] = this.sGId;
    data['SQ_Name'] = this.sQName;
    data['SQ_Description'] = this.sQDescription;
    data['SQ_Status'] = this.sQStatus;
    data['StatDate'] = this.statDate;
    data['EndDate'] = this.endDate;
    data['SQC_Id'] = this.sQCId;
    data['SQC_Name'] = this.sQCName;
    data['SQC_Type'] = this.sQCType;
    data['IsRequired'] = this.isRequired;
    data['SQC_Format'] = this.sQCFormat;
    data['SQC_Err_Msg'] = this.sQCErrMsg;
    data['SQD_Id'] = this.sQDId;
    data['SQD_Question'] = this.sQDQuestion;
    data['SA_Id'] = this.sAId;
    data['SA_Answer1'] = this.sAAnswer1;
    data['SA_Answer2'] = this.sAAnswer2;
    data['CustomerId'] = this.customerId;
    data['CreateDate'] = this.createDate;
    return data;
  }
}

class SurveyQuestion {
  String SQD_Id;
  String SQ_Id;
  String SQD_Question;
  String SQD_Type;
  String SQD_Sequence;
  bool IsRequired;
  String strStartDate;
  String strEndDate;
  List<SurveyQuestionChoice> dataChoice = [];
  String SQC_Ans;

  SurveyQuestion(
      {this.SQD_Id,
      this.SQ_Id,
      this.SQD_Question,
      this.SQD_Type,
      this.SQD_Sequence,
      this.IsRequired,
      this.strStartDate,
      this.strEndDate,
      this.dataChoice,
      this.SQC_Ans});

  static List<SurveyQuestion> dataListForm = []; // ตัวแปรที่จะเรียกใช้งาน
  SurveyQuestion.fromJson(Map<String, dynamic> json) {
    SQD_Id = json['SQD_Id'];
    SQ_Id = json['SQ_Id'];
    SQD_Question = json['SQD_Question'].toString();
    SQD_Type = json['SQD_Type'].toString();
    SQD_Sequence = json['SQD_Sequence'].toString();
    IsRequired = json['IsRequired'];
    strStartDate = json['strStartDate'];
    strEndDate = json['strEndDate'];
    final list = json['SurveyQuestionChoice'];
    list.forEach((v) {
      final planList = SurveyQuestionChoice.fromJson(v);
      print(planList.SQC_Name);
      dataChoice.add(planList);
    });
  }
}

class SurveyQuestionChoice {
  String SQC_Id;
  String SQD_Id;
  String SQC_Sequence;
  String SQC_Name;
  String SQC_Type;
  bool IsRequired;
  String SQC_Formate;
  String SQC_Err_Msg;
  String SQC_Ans;

  SurveyQuestionChoice(
      {this.SQC_Id,
      this.SQD_Id,
      this.SQC_Sequence,
      this.SQC_Name,
      this.SQC_Type,
      this.IsRequired,
      this.SQC_Formate,
      this.SQC_Err_Msg,
      this.SQC_Ans});

  static List<SurveyQuestionChoice> dataListForm = []; // ตัวแปรที่จะเรียกใช้งาน
  SurveyQuestionChoice.fromJson(Map<String, dynamic> json) {
    SQC_Id = json['SQC_Id'];
    SQD_Id = json['SQD_Id'];
    SQC_Sequence = json['SQC_Sequence'].toString();
    SQC_Name = json['SQC_Name'];
    SQC_Type = json['SQC_Type'];
    IsRequired = json['IsRequired'];
    SQC_Formate = json['SQC_Formate'];
    SQC_Err_Msg = json['SQC_Err_Msg'];
    SQC_Ans = json['SQC_Ans'];
  }
}

class SurveyQuestionRecordReadList {
  String sRcqId;
  String sQId;
  int sRcqSequence;
  String customerId;
  String createBy;
  String createDate;
  String strCreateDate;
  String updateBy;
  String updateDate;

  SurveyQuestionRecordReadList(
      {this.sRcqId,
      this.sQId,
      this.sRcqSequence,
      this.customerId,
      this.createBy,
      this.createDate,
      this.strCreateDate,
      this.updateBy,
      this.updateDate});

  static List<SurveyQuestionRecordReadList> dataList =
      []; // ตัวแปรที่จะเรียกใช้งาน
  SurveyQuestionRecordReadList.fromJsonList(Map<String, dynamic> json) {
    sRcqId = json['SRCQ_Id'];
    sQId = json['SQ_Id'];
    sRcqSequence = json['SRCQ_Sequence'];
    customerId = json['CustomerId'];
    createBy = json['CreateBy'];
    createDate = json['CreateDate'];
    strCreateDate = json['strCreateDate'];
    updateBy = json['UpdateBy'];
    updateDate = json['UpdateDate'];
  }
}

class AnswerSurveyList {
  String SQC_Id;
  String SQD_Id;
  String customerId;
  String SA_Answer1;

  AnswerSurveyList(
    this.SQC_Id,
    this.SQD_Id,
    this.customerId,
    this.SA_Answer1,
  );

  static List<AnswerSurveyList> data = [];

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['SQC_Id'] = this.SQC_Id;
    data['SQD_Id'] = this.SQD_Id;
    data['customerId'] = this.customerId;
    data['SA_Answer1'] = this.SA_Answer1;
    return data;
  }
}
