import 'package:mwf_app/service/api.dart';
import 'package:mwf_app/service/navigator.dart';
import 'package:mwf_app/service/url.dart';
import 'package:mwf_app/set1/schedule.dart';

class SumShutdownNotification {
  String sumShutdownNotification;
  String employeeID;
  String authenKey;

  SumShutdownNotification(
      {this.sumShutdownNotification, this.employeeID, this.authenKey});

  static getData() async {
    final response = await AppApi.apiGetRequest(
        AppUrl.SumShutdownNotification_ReadList +
            "?SumShutdownNotification=" +
            AppUrl.SumShutdownNotification +
            "&AuthenKey=" +
            AppUrl.AuthenKey); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static saveData(context, Map<String, dynamic> data) async {
    final response = await AppApi.post(
        AppUrl.SumShutdownNotification_Create, data); // เรียกใช้ api
    print(response);
    if (response['statusCode'] == 200) {
      //Nav.push(context, Schedule());
    }
  }

  static deleteData(
    context,
    String sumShutdownNotification,
  ) async {
    Map<String, dynamic> data = {
      "SumShutdownNotification": sumShutdownNotification,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response = await AppApi.post(
        AppUrl.SumShutdownNotification_Delete, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static updateData(
    context,
    String sumShutdownNotification,
    String employeeID,
    String authenKey,
  ) async {
    Map<String, dynamic> data = {
      "SumShutdownNotification": sumShutdownNotification,
      "EmployeeID": employeeID,
      "AuthenKey": authenKey,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response = await AppApi.post(
        AppUrl.SumShutdownNotification_Update, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static List<SumShutdownNotification> data = []; // ตัวแปรที่จะเรียกใช้งาน

  SumShutdownNotification.fromJson(Map<String, dynamic> json) {
    sumShutdownNotification = json['SumShutdownNotification'];
    employeeID = json['EmployeeID'];
    authenKey = json['AuthenKey'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['SumShutdownNotification'] = this.sumShutdownNotification;
    data['EmployeeID'] = this.employeeID;
    data['AuthenKey'] = this.authenKey;
    return data;
  }
}
