import 'package:mwf_app/service/api.dart';
import 'package:mwf_app/service/navigator.dart';
import 'package:mwf_app/service/url.dart';
import 'package:mwf_app/set1/schedule.dart';

class SumPackageOptionNotification {
  String sumPackageOptionNotification;
  String employeeID;
  String packagesID;
  String authenKey;

  SumPackageOptionNotification(
      {this.sumPackageOptionNotification,
      this.employeeID,
      this.packagesID,
      this.authenKey});

  static getData() async {
    final response = await AppApi.apiGetRequest(
        AppUrl.SumPackageOptionNotification_ReadList +
            "?SumPackageOptionNotification=" +
            AppUrl.SumPackageOptionNotification +
            "&AuthenKey=" +
            AppUrl.AuthenKey); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static saveData(context, Map<String, dynamic> data) async {
    final response = await AppApi.post(
        AppUrl.SumPackageOptionNotification_Create, data); // เรียกใช้ api
    print(response);
    if (response['statusCode'] == 200) {
      //Nav.push(context, Schedule());
    }
  }

  static deleteData(
    context,
    String sumPackageOptionNotification,
  ) async {
    Map<String, dynamic> data = {
      "SumPackageOptionNotification": sumPackageOptionNotification,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response = await AppApi.post(
        AppUrl.SumPackageOptionNotification_Delete, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static updateData(
    context,
    String sumPackageOptionNotification,
    String employeeID,
    String packagesID,
    String authenKey,
  ) async {
    Map<String, dynamic> data = {
      "SumPackageOptionNotification": sumPackageOptionNotification,
      "EmployeeID": employeeID,
      "PackagesID": packagesID,
      "AuthenKey": authenKey,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response = await AppApi.post(
        AppUrl.SumPackageOptionNotification_Update, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static List<SumPackageOptionNotification> data = []; // ตัวแปรที่จะเรียกใช้งาน

  SumPackageOptionNotification.fromJson(Map<String, dynamic> json) {
    sumPackageOptionNotification = json['SumPackageOptionNotification'];
    employeeID = json['EmployeeID'];
    packagesID = json['PackagesID'];
    authenKey = json['AuthenKey'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['SumPackageOptionNotification'] = this.sumPackageOptionNotification;
    data['EmployeeID'] = this.employeeID;
    data['PackagesID'] = this.packagesID;
    data['AuthenKey'] = this.authenKey;
    return data;
  }
}
