import 'package:mwf_app/service/api.dart';
import 'package:mwf_app/service/navigator.dart';
import 'package:mwf_app/service/url.dart';
import 'package:mwf_app/set1/schedule.dart';

class SumPackageNotification {
  String sumPackageNotificationID;
  String employeeID;
  String authenKey;

  SumPackageNotification(
      {this.sumPackageNotificationID, this.employeeID, this.authenKey});

  static getData() async {
    final response = await AppApi.apiGetRequest(
        AppUrl.SumPackageNotification_ReadList +
            "?SumPackageNotificationID=" +
            AppUrl.SumPackageNotificationID +
            "&AuthenKey=" +
            AppUrl.AuthenKey); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static saveData(context, Map<String, dynamic> data) async {
    final response = await AppApi.post(
        AppUrl.SumPackageNotification_Create, data); // เรียกใช้ api
    print(response);
    if (response['statusCode'] == 200) {
      //Nav.push(context, Schedule());
    }
  }

  static deleteData(
    context,
    String sumPackageNotificationID,
  ) async {
    Map<String, dynamic> data = {
      "SumPackageNotificationID": sumPackageNotificationID,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response = await AppApi.post(
        AppUrl.SumPackageNotification_Delete, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static updateData(
    context,
    String sumPackageNotificationID,
    String employeeID,
    String authenKey,
  ) async {
    Map<String, dynamic> data = {
      "SumPackageNotificationID": sumPackageNotificationID,
      "EmployeeID": employeeID,
      "AuthenKey": authenKey,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response = await AppApi.post(
        AppUrl.SumPackageNotification_Update, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static List<SumPackageNotification> data = []; // ตัวแปรที่จะเรียกใช้งาน

  SumPackageNotification.fromJson(Map<String, dynamic> json) {
    sumPackageNotificationID = json['SumPackageNotificationID'];
    employeeID = json['EmployeeID'];
    authenKey = json['AuthenKey'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['SumPackageNotificationID'] = this.sumPackageNotificationID;
    data['EmployeeID'] = this.employeeID;
    data['AuthenKey'] = this.authenKey;
    return data;
  }
}
